/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.sapbw;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.olap.provider.sapbw.SAPBWTransformation;

public final class UseOLAPForDiffHierarchiesFromSameDimension
extends SAPBWTransformation {
    private static final String DOUBLE_QUOTES = "\"";

    public UseOLAPForDiffHierarchiesFromSameDimension() {
        this.mName = "Throw exception when there are different hierarchies from the same dimension in the query.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery = (MDXQuery)node;
        StringBuilder sb = new StringBuilder();
        for (IHierarchy hierarchy : mdxQuery.getReferencedMultipleHierarchies()) {
            sb.append(DOUBLE_QUOTES);
            sb.append(hierarchy.getV5UniqueName());
            sb.append(DOUBLE_QUOTES);
            sb.append(",");
        }
        sb.setLength(sb.length() - 1);
        throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_MultipleHierarchiesFromSameDimension, sb.toString());
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node;
        if (mdxQuery.getReferencedMultipleHierarchies().size() == 0) {
            this.traceQueryCondition(false, "No hierarchies from the same dimension.", trace);
            return false;
        }
        this.traceQueryCondition(true, "Found different hierarchies from the same dimension in the query.", trace);
        return true;
    }
}

