/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.tm1;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEBaseQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.tm1.TM1Transformation;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.Iterator;

public final class ReOrderCrossjoins
extends TM1Transformation {
    public ReOrderCrossjoins() {
        this.mName = "Re-Order Crossjoin Location";
        this.mPassNumbers = new int[]{46};
        this.mTypes = new int[]{1030};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        IXQEQueryNode ancestorCrossjoin = node;
        while (ancestorCrossjoin.getParent().getType() == 1030) {
            IXQEQueryNode parent = ancestorCrossjoin.getParent();
            ancestorCrossjoin.extract();
            ancestorCrossjoin = parent;
        }
        while (ancestorCrossjoin.getNumberChildren() > 2) {
            Iterator<IXQEQueryNode> it = ancestorCrossjoin.getChildrenIterator();
            XQEBaseQueryNode target = null;
            AbstractMDXSet setChild = null;
            while (it.hasNext()) {
                setChild = (AbstractMDXSet)it.next();
                if (setChild.getNumberOfProjectedTuples() >= 0) {
                    target = setChild;
                    break;
                }
                if (target == null || !setChild.isFilteringOperator(true)) continue;
                target = setChild;
            }
            if (target == null) {
                target = (AbstractMDXSet)ancestorCrossjoin.getChild(0);
            }
            int index = target.getParent().getPositionOfChild(target);
            AbstractMDXSet previous = null;
            AbstractMDXSet next = null;
            if (index == 0) {
                next = (AbstractMDXSet)ancestorCrossjoin.getChild(index + 1);
            } else if (index == ancestorCrossjoin.getNumberChildren() - 1) {
                previous = (AbstractMDXSet)ancestorCrossjoin.getChild(ancestorCrossjoin.getNumberChildren() - 2);
            } else {
                next = (AbstractMDXSet)ancestorCrossjoin.getChild(index + 1);
                previous = (AbstractMDXSet)ancestorCrossjoin.getChild(index - 1);
                if (previous.getType() == 1030) {
                    next = null;
                } else if (next.getNumberOfProjectedTuples() >= 0 || next.isFilteringOperator(true)) {
                    previous = null;
                } else {
                    next = null;
                }
            }
            IXQEQueryNode newCrossjoin = factory.createNode(1030);
            target.insertParent(newCrossjoin);
            if (next != null) {
                next.move(newCrossjoin);
                continue;
            }
            previous.move(newCrossjoin, 0);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        node.throwOnInvalidChildCategories();
        if (node.getParent().getType() != 1030) {
            this.traceNodeCondition(false, "The parent node is not an MDXCrossjoin node.", trace);
            return false;
        }
        if (node.getChild(0).getType() == 1030 || node.getChild(1).getType() == 1030) {
            this.traceNodeCondition(false, "One of the child nodes is a MDXCrossjoin node.", trace);
            return false;
        }
        IXQEQueryNode crossjoin = node;
        while (crossjoin.getParent().getType() == 1030) {
            int index = crossjoin.getParent().getPositionOfChild(crossjoin);
            AbstractMDXSet crossjoinSet = index == 0 ? (AbstractMDXSet)crossjoin.getParent().getChild(1) : (AbstractMDXSet)crossjoin.getParent().getChild(0);
            if (crossjoinSet.isFilteringOperator(true) || crossjoinSet.getNumberOfProjectedTuples() != -1) {
                this.traceNodeCondition(true, "The crossjoins should be re-ordered.", trace);
                return true;
            }
            crossjoin = crossjoin.getParent();
        }
        this.traceNodeCondition(false, "No ancestor crossjoin nodes need to be re-ordered.", trace);
        return false;
    }
}

