/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.tm1;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXDimensionProperties;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.tm1.TMRTransformation;

public final class SetTMRDirectDimensionProperties
extends TMRTransformation {
    public SetTMRDirectDimensionProperties() {
        this.mName = "Set TMR default dimension properties on axis";
        this.mPassNumbers = new int[]{2, 46};
        this.mTypes = new int[]{1006};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXEdge edge = (MDXEdge)node;
        String[] propsToAdd = new String[]{"MEMBER_CAPTION", "DESCRIPTION"};
        for (int i = 0; i < propsToAdd.length; ++i) {
            edge.addMemberProperty(propsToAdd[i]);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        MDXEdge edge = (MDXEdge)node;
        MDXQuery mdxQuery = (MDXQuery)edge.getAncestorOfType(1002);
        if (mdxQuery.getDataSourceType().equals("TMR")) {
            IDataSourceCapabilities capabilities = mdxQuery.getCapabilities();
            if (capabilities == null) {
                return false;
            }
            if (capabilities.getBooleanValue("v5.useLocalOLAP", Boolean.FALSE)) {
                return false;
            }
        }
        MDXDimensionProperties props = edge.getDimensionProperties();
        String[] propsToCheckForAdd = new String[]{"MEMBER_CAPTION", "DESCRIPTION"};
        for (int i = 0; i < propsToCheckForAdd.length; ++i) {
            if (props.containsMemberProperty(propsToCheckForAdd[i])) continue;
            this.traceNodeCondition(true, propsToCheckForAdd[i] + " property not set.", trace);
            return true;
        }
        this.traceNodeCondition(false, "Default properties already set.", trace);
        return false;
    }
}

