/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.ragged_unbalanced;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.TNodeSort;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.olap.optimization.generate.ReplaceGenerateWithHierarchize;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import java.util.List;

public abstract class AbstractRaggedUnbalancedTransformation
extends Transformation {
    public static final String NUMBER_OF_MISSING_RAGGED_ANCESTORS = "numOfMissingRaggedAncestors";
    protected static final String NESTING_ORDER_IS_BROKEN = "Nesting order is broken.";
    protected static final String NESTING_EXPLICIT_MEMBERS = "Nesting explicit members.";
    protected static final int BROKEN_ORDER = -2;
    public static final int LEVELS_OVERLAP = -1;
    protected static final int DIFFERENT_HIERARCHY = 0;
    public static final int REVERSE_ORDER = 1;
    public static final int NATURAL_ORDER = 2;
    protected static final int NO_WRN = -1;
    public static final int WRN_R = 1;
    public static final int WRN_U = 2;
    public static final String UNBALANCED_COMPENSATION_HIERARCHIZE = "ubCompensationReplaceWithHierarchize";
    public static final String UNBALANCED_COMPENSATION_APPLIED = "ubCompensationApplied";
    public static final String RAGGED_COMPENSATION_HIERARCHIZE = "raggedCompensationReplaceWithHierarchize";
    public static final String RAGGED_COMPENSATION_APPLIED = "raggedCompensationApplied";
    protected static int[] mCogTypes = new int[]{1027, 1026};

    public static IHierarchy getHierarchy(AbstractMDXSet node) {
        MDXHierInfo hierInfo = node.getHierarchyInfo();
        IHierarchy hierarchy = null;
        if (hierInfo.getNumProjectedHierarchies() > 0) {
            hierarchy = hierInfo.getProjectedHierarchy(0);
        }
        return hierarchy;
    }

    protected static List<ILevel> getLevels(AbstractMDXSet node) {
        List<ILevel> levels = null;
        if (node.isOfTypes(mCogTypes)) {
            AbstractMDXSet prjExpr = AbstractRaggedUnbalancedTransformation.getProjSet(node);
            levels = prjExpr.getLevelInfo().getProjectedLevels(AbstractRaggedUnbalancedTransformation.getHierarchy(node));
        } else if (node.getType() == 1039) {
            levels = ((MDXSet)node).getLevelInfo().getProjectedLevels(AbstractRaggedUnbalancedTransformation.getHierarchy(node));
        } else {
            node.throwInternalError("");
        }
        return levels;
    }

    protected static AbstractMDXSet getProjSet(AbstractMDXSet cogMDX) {
        cogMDX.throwOnInvalidChildCategories();
        AbstractMDXSet abstractMDXSet = null;
        if (!cogMDX.isOfTypes(mCogTypes)) {
            cogMDX.throwInternalError("mCogTypes");
        }
        abstractMDXSet = (AbstractMDXSet)cogMDX.getChild(0);
        return abstractMDXSet;
    }

    protected String getRaggedNLevelProperty(AbstractMDXSet node) {
        String value = null;
        if (node.getType() == 1117) {
            value = this.getRaggedNLevelProperty((AbstractMDXSet)node.getChild(0));
        } else if (node.isOfCategory(1021)) {
            value = node.getRaggedNLevelProperty();
        } else {
            node.throwInternalError("");
        }
        return value;
    }

    protected boolean isDescendantInSummary(CogMDXGroup ancestor, CogMDXGroup descendant) {
        IXQEQueryNode ancestorSummary = descendant.getAncestorOfCategory(1080);
        boolean result = false;
        if (ancestorSummary != null) {
            result = ancestorSummary.isAncestor(ancestor);
        }
        return result;
    }

    protected boolean nodeConditionForRagged(CogMDXGroup targetGroup, StringBuilder msgStr) {
        MDXQuery mdxQuery = (MDXQuery)targetGroup.getAncestorOfType(1002);
        if (mdxQuery.getCogMDXGroupsNotRequiringRaggedCompensation().contains(targetGroup) && msgStr != null) {
            msgStr.append("Ragged compensation is not required.");
            return false;
        }
        if (this.isMetadataRequest(targetGroup, msgStr)) {
            mdxQuery.addCogMDXGroupNotRequiringRaggedCompensation(targetGroup);
            return msgStr != null;
        }
        IHierarchy targetHier = AbstractRaggedUnbalancedTransformation.getHierarchy(targetGroup);
        boolean isUnProcessedRagged = this.getRaggedNLevelProperty(targetGroup).equals("unprocessedRaggedNested");
        if (targetHier != null && !targetHier.isShell() && targetHier.isRagged() && isUnProcessedRagged) {
            if (!this.allFollowingSiblingsAreProcessed(targetGroup, msgStr)) {
                if (msgStr != null) {
                    msgStr.append("The target node is nesting at least one unprocessed ragged CogMDXGroup node.");
                }
                return false;
            }
        } else {
            if (msgStr != null) {
                msgStr.append("This node does not project a ragged hierarchy.");
            }
            return false;
        }
        IXQEQueryNode[] cogMDXAncestors = targetGroup.getAncestorsOfType(1027);
        int ancestorsCount = 0;
        for (int i = 0; i < cogMDXAncestors.length; ++i) {
            IHierarchy ancestorHierarchy = AbstractRaggedUnbalancedTransformation.getHierarchy((AbstractMDXSet)cogMDXAncestors[i]);
            CogMDXGroup currAncestor = (CogMDXGroup)cogMDXAncestors[i];
            if (ancestorHierarchy == null || !ancestorHierarchy.equals(targetHier) || this.isDescendantInSummary(currAncestor, targetGroup)) continue;
            AbstractMDXSet currAncestorFirstChild = (AbstractMDXSet)currAncestor.getChild(0);
            if (!currAncestorFirstChild.isRaggedUnbalancedCompensationApplicable()) {
                if (msgStr != null) {
                    return true;
                }
                this.warningRaggedCompensationIsNotApplicable(targetGroup, currAncestor, targetHier);
                return false;
            }
            ++ancestorsCount;
        }
        String s1 = "The node has no ancestor CogMDXGroup node.";
        if (ancestorsCount == 0) {
            if (msgStr != null) {
                msgStr.append("The node has no ancestor CogMDXGroup node.");
            }
            return false;
        }
        CogMDXGroup ancestorGroup = (CogMDXGroup)targetGroup.getAncestorOfTypes(this.mTypes);
        if (ancestorGroup == null) {
            if (msgStr != null) {
                msgStr.append("The node has no ancestor CogMDXGroup node.");
            }
            return false;
        }
        IHierarchy ancestorHierarchy = AbstractRaggedUnbalancedTransformation.getHierarchy(ancestorGroup);
        if (ancestorHierarchy == null || !ancestorHierarchy.equals(targetHier)) {
            if (msgStr != null) {
                msgStr.append("The CogMDXGroup ancestor of this node is not of the same ragged hierarchy.");
            }
            return false;
        }
        if (this.firstChildOnlyProjectsRootLevelExplicitMembers(targetGroup, msgStr)) {
            return msgStr != null;
        }
        int warningType = -1;
        if (msgStr == null) {
            warningType = 1;
        }
        if (AbstractRaggedUnbalancedTransformation.isNestingOrderBroken(targetGroup, targetHier, mdxQuery, false, warningType)) {
            if (msgStr != null) {
                msgStr = new StringBuilder(NESTING_ORDER_IS_BROKEN);
                return true;
            }
            return false;
        }
        boolean includeSelf = false;
        IXQEQueryNode[] nestedCogMDXGroups = targetGroup.getDescendantsOfType(1027, includeSelf);
        if (nestedCogMDXGroups.length > 0) {
            for (IXQEQueryNode nestedCogMDXGroup : nestedCogMDXGroups) {
                CogMDXGroup currNestedGroup = (CogMDXGroup)nestedCogMDXGroup;
                IHierarchy nestedHierarchy = AbstractRaggedUnbalancedTransformation.getHierarchy(currNestedGroup);
                if (this.isDescendantInSummary(targetGroup, currNestedGroup) || nestedHierarchy == null || !nestedHierarchy.equals(targetHier) || !this.getRaggedNLevelProperty(currNestedGroup).equals("unprocessedRaggedNested")) continue;
                if (msgStr != null) {
                    msgStr.append("There are none unprocessed ragged nested CogMDXGroup nodes of the same hierarchy.");
                }
                return false;
            }
        }
        if (!AbstractRaggedUnbalancedTransformation.isNotReplaceableWithHierarchize(targetGroup)) {
            MDXEdge edge;
            if (msgStr != null) {
                msgStr = new StringBuilder("Is replaceable with hierarchize.");
            }
            if ((edge = (MDXEdge)targetGroup.getAncestorOfType(1006)) != null) {
                edge.setPropertyValue(RAGGED_COMPENSATION_HIERARCHIZE, true);
            }
            mdxQuery.addCogMDXGroupNotRequiringRaggedCompensation(targetGroup);
            return false;
        }
        if (msgStr != null) {
            msgStr.append("The target node is an unprocessed ragged nested CogMDXGroup.");
        }
        return true;
    }

    private boolean isMetadataRequest(IXQEQueryNode node, StringBuilder msgStr) {
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery.getPropertyValue(V5Query.QueryHint.QUERY_INTENT.getPropertyName()) != null && mdxQuery.getPropertyValue(V5Query.QueryHint.QUERY_INTENT.getPropertyName()).equals("metadata")) {
            if (msgStr != null) {
                msgStr.append("Metadata request does not require ragged compensation.");
            }
            return true;
        }
        return false;
    }

    protected boolean firstChildOnlyProjectsRootLevelExplicitMembers(CogMDXGroup targetGroup, StringBuilder msgStr) {
        IHierarchy targetHier = AbstractRaggedUnbalancedTransformation.getHierarchy(targetGroup);
        AbstractMDXSet firstSet = (AbstractMDXSet)targetGroup.getChild(0);
        MDXLevelInfo nodeFirstChildLevelInfo = firstSet.getLevelInfo();
        if (nodeFirstChildLevelInfo.getNumProjectedLevels(targetHier) == 1 && nodeFirstChildLevelInfo.getProjectedLevels(targetHier).get(0).isRootLevel() && firstSet.projectsOnlyExplicitMembers(targetHier)) {
            if (msgStr != null) {
                msgStr.append("The first child of the MDXGroup only projects the root level.");
            } else {
                this.warningGroupOnlyProjectsRootLevelExplicitMembers(targetGroup, targetHier);
            }
            return true;
        }
        return false;
    }

    private void warningGroupOnlyProjectsRootLevelExplicitMembers(CogMDXGroup targetGroup, IHierarchy targetHierarchy) {
        MDXQuery mdxQuery = (MDXQuery)targetGroup.getAncestorOfType(1002);
        if (mdxQuery.addCogMDXGroupNotRequiringRaggedCompensation(targetGroup) && targetGroup.getAncestorOfType(1012) == null) {
            int aSeverity = 3;
            String refDataItemName = targetGroup.getRefDataItemProperty();
            targetGroup.getPlanningEnvironment().getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_R_GroupOnlyProjectsRootLevelExplicitMembers, refDataItemName, targetHierarchy.getUniqueName()));
        }
    }

    private void warningRaggedCompensationIsNotApplicable(CogMDXGroup targetGroup, CogMDXGroup ancestorGroup, IHierarchy targetHierarchy) {
        MDXQuery mdxQuery = (MDXQuery)targetGroup.getAncestorOfType(1002);
        boolean ancestorReportedForTheFirstTime = !mdxQuery.getCogMDXGroupsNotRequiringRaggedCompensation().contains(ancestorGroup);
        targetGroup.setRaggedNLevelProperty("compensationNAForRaggedNested");
        if (mdxQuery.addCogMDXGroupNotRequiringRaggedCompensation(targetGroup) && targetGroup.getAncestorOfType(1012) == null && !targetGroup.getRaggedNLevelProperty().equals("compensationNAForRaggedNested") && ancestorReportedForTheFirstTime) {
            int aSeverity = 3;
            String refDataItemName = ancestorGroup.getRefDataItemProperty();
            targetGroup.getPlanningEnvironment().getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_R_RaggedCompensationIsNotApplicable, targetHierarchy.getUniqueName(), refDataItemName));
        }
    }

    protected boolean allFollowingSiblingsAreProcessed(IXQEQueryNode node, StringBuilder msgStr) {
        IXQEQueryNode parentNode = node.getParent();
        IXQEQueryNode[] siblingCogMDXGroups = parentNode.getChildrenOfType(node.getType());
        int targetPosition = parentNode.getPositionOfChild(node);
        for (int i = 0; i < siblingCogMDXGroups.length; ++i) {
            CogMDXGroup siblingCogMDXGroup = (CogMDXGroup)siblingCogMDXGroups[i];
            if (targetPosition >= parentNode.getPositionOfChild(siblingCogMDXGroup)) continue;
            IHierarchy siblingHierarchy = AbstractRaggedUnbalancedTransformation.getHierarchy(siblingCogMDXGroup);
            boolean isUnProcessedRagSibling = this.getRaggedNLevelProperty(siblingCogMDXGroup).equals("unprocessedRaggedNested");
            if (siblingHierarchy == null || siblingHierarchy.isShell() || !siblingHierarchy.isRagged() || !isUnProcessedRagSibling) continue;
            if (msgStr != null) {
                msgStr.append("Sibling node (nodeId=");
                msgStr.append(siblingCogMDXGroup.getId());
                msgStr.append(") must be processed first.");
            }
            return false;
        }
        return true;
    }

    protected void checkHierarchyNestingOrder(IXQEQueryNode node, MDXQuery mdxQuery, IHierarchy nodeHierarchy) {
        List<ILevel> levels;
        AbstractMDXNode cogMDXAncestor = (AbstractMDXNode)node.getAncestorOfTypes(this.mTypes);
        if (cogMDXAncestor != null && cogMDXAncestor.getHierarchyInfo().getProjectedHierarchy(0).equals(nodeHierarchy) && (levels = mdxQuery.getLevelInfo().getProjectedLevels(nodeHierarchy)).size() > 1) {
            AbstractMDXNode nodeChild = (AbstractMDXNode)node.getChild(0);
            if (nodeChild.getType() == 1039 && nodeChild.getNumberChildren() == 1 && nodeChild.getChild(0).getType() == 1013) {
                return;
            }
            ILevel nodeHighestLevel = nodeChild.getLevelInfo().getHighestProjectedLevel(nodeHierarchy);
            AbstractMDXNode ancestorChild = (AbstractMDXNode)cogMDXAncestor.getChild(0);
            ILevel ancestorLowestLevel = ancestorChild.getLevelInfo().getLowestProjectedLevel(nodeHierarchy);
            if (nodeHighestLevel.getIndex() < ancestorLowestLevel.getIndex()) {
                throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_UnsuppBrokenHierOrderForRagged);
            }
        }
    }

    protected MDXLevelInfo getCobinedLevelInfo(IHierarchy hierarchy, AbstractMDXSet[] sets) {
        MDXLevelInfo outerLevelInfo = new MDXLevelInfo();
        outerLevelInfo.appendProjectedHierarchy(sets[0].getLevelInfo(), hierarchy);
        for (int i = 1; i < sets.length; ++i) {
            MDXLevelInfo currLevelInfo = sets[i].getLevelInfo();
            outerLevelInfo.unionProjectedLevels(currLevelInfo, hierarchy);
        }
        return outerLevelInfo;
    }

    public static boolean isNotReplaceableWithHierarchize(CogMDXGroup targetGroup) {
        boolean status = true;
        IHierarchy firstChildHierarchy = AbstractRaggedUnbalancedTransformation.getHierarchy(targetGroup);
        MDXLevelInfo firstChildLevelInfo = ((AbstractMDXSet)targetGroup.getChild(0)).getLevelInfo();
        MDXLevelInfo targetGroupLevelInfo = targetGroup.getLevelInfo();
        if (targetGroupLevelInfo.getNumProjectedLevels(firstChildHierarchy) > 0 && firstChildLevelInfo.getNumProjectedLevels(firstChildHierarchy) > 0 && targetGroupLevelInfo.getLowestProjectedLevel(firstChildHierarchy).compareTo(firstChildLevelInfo.getLowestProjectedLevel(firstChildHierarchy)) == 0 && AbstractRaggedUnbalancedTransformation.isInNaturalHierOrder(targetGroup)) {
            status = ReplaceGenerateWithHierarchize.isNotReplaceableWithHierarchize(targetGroup);
        }
        return status;
    }

    protected static boolean isInNaturalHierOrder(IXQEQueryNode node) {
        boolean status = false;
        IHierarchy firstChildHierarchy = AbstractRaggedUnbalancedTransformation.getHierarchy((CogMDXGroup)node);
        MDXLevelInfo nodeFirstChildLevelInfo = ((AbstractMDXNode)node.getChild(0)).getLevelInfo();
        AbstractMDXSet nextOuterSet = (AbstractMDXSet)node.getAncestorOfTypes(mCogTypes);
        if (nextOuterSet != null && ((AbstractMDXSet)nextOuterSet.getChild(0)).getHierarchyInfo().projectsHierarchy(firstChildHierarchy)) {
            ILevel outerLowestLevel = ((AbstractMDXSet)nextOuterSet.getChild(0)).getLevelInfo().getLowestProjectedLevel(firstChildHierarchy);
            ILevel innerHighestLevel = nodeFirstChildLevelInfo.getHighestProjectedLevel(firstChildHierarchy);
            if (innerHighestLevel != null && outerLowestLevel != null && innerHighestLevel.getIndex() >= outerLowestLevel.getIndex()) {
                status = true;
            }
        }
        return status;
    }

    public static boolean isNestingOrderBroken(CogMDXGroup targetGroup, IHierarchy targetHierarchy, MDXQuery mdxQuery, boolean refuseReverse, int warningType) {
        AbstractMDXSet ancestorGroup;
        int[] cogTypes = new int[]{1027};
        boolean isOrderBroken = false;
        int orderType = 2;
        MDXLevelInfo prevLevelInfo = ((AbstractMDXSet)targetGroup.getChild(0)).getLevelInfo();
        if (prevLevelInfo.getHighestProjectedLevel(targetHierarchy) == null) {
            if (warningType != -1) {
                AbstractRaggedUnbalancedTransformation.warningNestingOrderBroken(targetGroup, targetHierarchy, warningType, -2, ancestorGroup);
            }
            return true;
        }
        AbstractMDXSet currTargetNode = targetGroup;
        Boolean isNaturalOrder = null;
        for (ancestorGroup = (AbstractMDXSet)targetGroup.getAncestorOfTypes(cogTypes); ancestorGroup != null && (orderType = AbstractRaggedUnbalancedTransformation.isNestingOrderNatural(currTargetNode, ancestorGroup, targetHierarchy)) != 0; ancestorGroup = (AbstractMDXSet)ancestorGroup.getAncestorOfTypes(cogTypes)) {
            if (orderType == -2 || orderType == -1) {
                isOrderBroken = true;
                break;
            }
            if (refuseReverse && orderType == 1) {
                isOrderBroken = true;
                break;
            }
            if (isNaturalOrder == null) {
                isNaturalOrder = orderType == 2 ? Boolean.TRUE : Boolean.FALSE;
            } else {
                if (isNaturalOrder.equals(Boolean.TRUE) && orderType == 1) {
                    isOrderBroken = true;
                    orderType = -2;
                    break;
                }
                if (isNaturalOrder.equals(Boolean.FALSE) && orderType == 2) {
                    isOrderBroken = true;
                    orderType = -2;
                    break;
                }
            }
            currTargetNode = ancestorGroup;
        }
        if (isOrderBroken) {
            if (warningType != -1) {
                AbstractRaggedUnbalancedTransformation.warningNestingOrderBroken(targetGroup, targetHierarchy, warningType, orderType, ancestorGroup);
            }
            return true;
        }
        return false;
    }

    private static void warningNestingOrderBroken(CogMDXGroup targetGroup, IHierarchy targetHierarchy, int warningType, int orderType, AbstractMDXSet ancestorGroup) {
        MDXQuery mdxQuery = (MDXQuery)targetGroup.getAncestorOfType(1002);
        if (mdxQuery.addRUCogMDXGroupWithBrokenHierarchyLevelOrder(targetGroup, warningType) && targetGroup.getAncestorOfType(1012) == null) {
            int aSeverity = 3;
            String refDataItemName1 = targetGroup.getRefDataItemProperty();
            String refDataItemName2 = "";
            if (ancestorGroup != null) {
                refDataItemName2 = ancestorGroup.getRefDataItemProperty();
            }
            IMessageKey.Param3 aCode = null;
            String unknownOrdereType = "orderType?";
            if (warningType == 1) {
                switch (orderType) {
                    case -1: {
                        aCode = XQEMessageKeys.WRN_R_HierarchyLevelsOverlap;
                        break;
                    }
                    case -2: {
                        aCode = XQEMessageKeys.WRN_R_HierarchyLevelOrderIsBroken;
                        break;
                    }
                    default: {
                        targetGroup.throwInternalError("orderType?");
                        break;
                    }
                }
            } else {
                switch (orderType) {
                    case -1: {
                        aCode = XQEMessageKeys.WRN_U_HierarchyLevelsOverlap;
                        break;
                    }
                    case 1: {
                        aCode = XQEMessageKeys.WRN_U_HierarchyLevelsInReverseOrder;
                        break;
                    }
                    case -2: {
                        aCode = XQEMessageKeys.WRN_U_HierarchyLevelOrderIsBroken;
                        break;
                    }
                    default: {
                        targetGroup.throwInternalError("orderType?");
                    }
                }
            }
            targetGroup.getPlanningEnvironment().getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, aCode, refDataItemName1, refDataItemName2, targetHierarchy.getUniqueName()));
        }
    }

    public static int isNestingOrderNatural(AbstractMDXSet descendantNode, AbstractMDXSet ancestorNode, IHierarchy targetHier) {
        MDXLevelInfo ancestorLevelInfo = ((AbstractMDXSet)ancestorNode.getChild(0)).getLevelInfo();
        MDXLevelInfo descendantLevelInfo = ((AbstractMDXSet)descendantNode.getChild(0)).getLevelInfo();
        int result = AbstractRaggedUnbalancedTransformation.isNestingOrderNatural(descendantLevelInfo, ancestorLevelInfo, targetHier);
        if (result == -1) {
            AbstractMDXSet descFirstSet = (AbstractMDXSet)descendantNode.getChild(0);
            if (targetHier.isUnbalanced()) {
                List<IXQEQueryNode> descendants = descFirstSet.getDescendantsOfTypeOrdered(1052, true);
                List<IXQEQueryNode> ascendants = descFirstSet.getDescendantsOfTypeOrdered(1045, true);
                if (!descendants.isEmpty() && ascendants.isEmpty() && descFirstSet.projectsOnlyAscendantsOrDescendantsOfCurrentMember(true)) {
                    return 2;
                }
            }
            List<ILevel> descProjLevelsSkipCalc = descendantLevelInfo.getProjectedLevelsSkipCalculation(targetHier);
            MDXLevelInfo descHierInfoSkipCalc = new MDXLevelInfo();
            if (!descHierInfoSkipCalc.isEmpty()) {
                descHierInfoSkipCalc.addProjectedLevels(descProjLevelsSkipCalc);
            }
            List<ILevel> ancProjLevelsSkipCalc = ancestorLevelInfo.getProjectedLevelsSkipCalculation(targetHier);
            MDXLevelInfo ancHierInfoSkipCalc = new MDXLevelInfo();
            if (!ancProjLevelsSkipCalc.isEmpty()) {
                ancHierInfoSkipCalc.addProjectedLevels(ancProjLevelsSkipCalc);
            }
            AbstractMDXSet ascFirstSet = (AbstractMDXSet)ancestorNode.getChild(0);
            if (descFirstSet.projectsCalculatedMember() && ascFirstSet.projectsCalculatedMember()) {
                if (descProjLevelsSkipCalc.isEmpty() && !ancProjLevelsSkipCalc.isEmpty()) {
                    result = 2;
                } else if (!descProjLevelsSkipCalc.isEmpty() && ancProjLevelsSkipCalc.isEmpty()) {
                    result = 2;
                } else if (!descProjLevelsSkipCalc.isEmpty() && !ancProjLevelsSkipCalc.isEmpty()) {
                    boolean calcLevelHaveBeenRemovedTargetHierIsProjected;
                    boolean bl = calcLevelHaveBeenRemovedTargetHierIsProjected = descHierInfoSkipCalc.getHierarchyInfo() != null && descHierInfoSkipCalc.getHierarchyInfo().projectsHierarchy(targetHier) && descendantLevelInfo.getHierarchyInfo() != null && descendantLevelInfo.getHierarchyInfo().projectsHierarchy(targetHier) && !descHierInfoSkipCalc.compareProjectedLevels(descendantLevelInfo, targetHier) || ancHierInfoSkipCalc.getHierarchyInfo() != null && ancHierInfoSkipCalc.getHierarchyInfo().projectsHierarchy(targetHier) && ancestorLevelInfo.getHierarchyInfo() != null && ancestorLevelInfo.getHierarchyInfo().projectsHierarchy(targetHier) && !ancHierInfoSkipCalc.compareProjectedLevels(ancestorLevelInfo, targetHier);
                    if (calcLevelHaveBeenRemovedTargetHierIsProjected) {
                        descendantLevelInfo.clearProjectedLevels(targetHier);
                        descendantLevelInfo.replaceProjectedLevels(descHierInfoSkipCalc, targetHier);
                        ancestorLevelInfo.clearProjectedLevels(targetHier);
                        ancestorLevelInfo.replaceProjectedLevels(ancHierInfoSkipCalc, targetHier);
                        result = AbstractRaggedUnbalancedTransformation.isNestingOrderNatural(descendantLevelInfo, ancestorLevelInfo, targetHier);
                    }
                }
            } else if (descFirstSet.getType() == 1039 && descFirstSet.getChild(0).getType() == 1076) {
                result = 2;
            }
        }
        return result;
    }

    public static int isNestingOrderNatural(MDXLevelInfo descendantLevelInfo, MDXLevelInfo ancestorLevelInfo, IHierarchy targetHierarchy) {
        if (ancestorLevelInfo.getHighestProjectedLevel(targetHierarchy) == null) {
            return 0;
        }
        if (ancestorLevelInfo.getHighestProjectedLevel(targetHierarchy) == null) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_XQEQueryNodeInternalError_INTERNAL, null, "ancestorLevelInfo.getHighestProjectedLevel(targetHierarchy) == null");
        }
        if (descendantLevelInfo.getHighestProjectedLevel(targetHierarchy) == null) {
            return 2;
        }
        List<ILevel> descendantLevels = descendantLevelInfo.getProjectedLevels(targetHierarchy);
        List<ILevel> ancestorLevels = ancestorLevelInfo.getProjectedLevels(targetHierarchy);
        if (descendantLevels.size() == 1 && ancestorLevels.size() == 1 && descendantLevels.get(0).getUniqueName().equals(ancestorLevels.get(0).getUniqueName())) {
            return 2;
        }
        int levelOrder = 2;
        if (descendantLevelInfo.projectedLevelsOverlap(ancestorLevelInfo, targetHierarchy)) {
            levelOrder = -1;
        }
        int result = levelOrder;
        if (levelOrder != -1) {
            boolean bIsNaturalOrder = descendantLevelInfo.getHighestProjectedLevel(targetHierarchy).getIndex() > ancestorLevelInfo.getHighestProjectedLevel(targetHierarchy).getIndex();
            result = 2;
            if (!bIsNaturalOrder) {
                result = 1;
            }
        }
        return result;
    }

    public boolean applyRaggedCompensation(MDXQuery mdxQuery) {
        return mdxQuery.getCapabilities().getBooleanValue("applyRaggedCompensation", true);
    }

    public static boolean applyUnbalancedCompensation(MDXQuery mdxQuery) {
        return mdxQuery.getCapabilities().isSupported("applyUnbalancedCompensation");
    }

    protected AbstractMDXSet createCompensationTNodeSort(TNodeSort tNodeSortTemplate, IXQENodeFactory nodeFactory, AbstractMDXSet setToSort, String ruProperty) {
        String refDataItem;
        boolean includeSelf = true;
        boolean isSortRequired = false;
        if (setToSort != null) {
            IXQEQueryNode[] groupsUnderSort;
            int[] types = new int[]{1027, 1026};
            for (IXQEQueryNode groupUnderSort : groupsUnderSort = setToSort.getDescendantsOfTypes(types, includeSelf)) {
                if (!tNodeSortTemplate.isSortRefDataItem(((AbstractMDXSet)groupUnderSort).getRefDataItemProperty())) continue;
                isSortRequired = true;
                break;
            }
        }
        if (!isSortRequired && tNodeSortTemplate.getChild(1).getType() != 1118 && tNodeSortTemplate.isSortRefDataItem(refDataItem = ((AbstractMDXSet)tNodeSortTemplate.getChild(1)).getRefDataItemProperty())) {
            isSortRequired = true;
        }
        if (!isSortRequired) {
            setToSort = this.crossjoinSetWithTNodeSortMeasure(nodeFactory, tNodeSortTemplate, setToSort);
            return setToSort;
        }
        TNodeSort newTNodeSort = (TNodeSort)nodeFactory.copyNode(tNodeSortTemplate);
        if (ruProperty.endsWith("unbalancedNestedLevel")) {
            newTNodeSort.setUnbalancedNLevelProperty(tNodeSortTemplate.getId().toString());
        } else if (ruProperty.endsWith("raggedNestedLevel")) {
            newTNodeSort.setRaggedNLevelProperty(tNodeSortTemplate.getId().toString());
        } else {
            tNodeSortTemplate.throwInternalError("ruProperty");
        }
        if (setToSort != null) {
            newTNodeSort.addChild(setToSort);
            newTNodeSort.setGroupId(setToSort.getId());
        }
        for (int j = 1; j < tNodeSortTemplate.getNumberChildren(); ++j) {
            AbstractMDXNode currChild = (AbstractMDXNode)tNodeSortTemplate.getChild(j);
            boolean onlyExcludeProj = true;
            currChild = (AbstractMDXNode)MDXBuilder.deepCopyExcludingCMDefs(nodeFactory, currChild, onlyExcludeProj);
            newTNodeSort.addChild(currChild);
        }
        return newTNodeSort;
    }

    protected AbstractMDXSet crossjoinSetWithTNodeSortMeasure(IXQENodeFactory nodeFactory, TNodeSort tNodeSortTemplate, AbstractMDXSet setToSort) {
        if (tNodeSortTemplate.getChild(1) == null) {
            tNodeSortTemplate.throwInternalError("getChild(1) == null");
        }
        if (tNodeSortTemplate.getChild(1).getType() == 1118) {
            return setToSort;
        }
        boolean onlyExcludeProj = true;
        if (setToSort == null && tNodeSortTemplate.getChild(1).getType() != 1118) {
            AbstractMDXSet measureSet = (AbstractMDXSet)tNodeSortTemplate.getChild(1);
            measureSet = (AbstractMDXSet)MDXBuilder.deepCopyExcludingCMDefs(nodeFactory, measureSet, onlyExcludeProj);
            return measureSet;
        }
        AbstractMDXSet measureSet = (AbstractMDXSet)tNodeSortTemplate.getChild(1);
        measureSet = (AbstractMDXSet)MDXBuilder.deepCopyExcludingCMDefs(nodeFactory, measureSet, onlyExcludeProj);
        AbstractMDXSet crossjoin = (AbstractMDXSet)nodeFactory.createNode(1030);
        crossjoin.addChild(setToSort);
        crossjoin.addChild(measureSet);
        setToSort = crossjoin;
        return setToSort;
    }

    protected boolean isRaggedCompensationDone(StringBuilder traceMsg, CogMDXGroup targetGroup, MDXQuery mdxQuery, IHierarchy targetHier, AbstractMDXNode pathRoot, boolean ignoreSummaries, boolean checkTargetPathForNACompensation) {
        boolean includeSelf = true;
        List<IXQEQueryNode> cogMDXGroups = pathRoot.getDescendantsOfCategoryOrdered(1027, includeSelf);
        for (IXQEQueryNode cogMDXGroup : cogMDXGroups) {
            IXQEQueryNode ancestorSummaryExpr;
            CogMDXGroup currAncestorGroup;
            CogMDXGroup currGroup = (CogMDXGroup)cogMDXGroup;
            if (currGroup.getFirstSetHierarchy() == null && currGroup.getType() == 1080 && currGroup.getDetailProperty() == null || !currGroup.getFirstSetHierarchy().equals(targetHier) || (currAncestorGroup = (CogMDXGroup)currGroup.getAncestorOfType(1027)) == null || !currAncestorGroup.getFirstSetHierarchy().equals(targetHier) || (ancestorSummaryExpr = currGroup.getAncestorOfType(1028)) != null || mdxQuery.getCogMDXGroupsNotRequiringRaggedCompensation().contains(currGroup) || !this.allFollowingSiblingsAreProcessed(currGroup, null)) continue;
            if (this.getRaggedNLevelProperty(currGroup).equals("unprocessedRaggedNested")) {
                if (currGroup.getType() == 1027) {
                    if (traceMsg != null) {
                        traceMsg.append("Found an unprocessed ragged CogMDXGroup of the same hierarchy within de edge.");
                    }
                    return false;
                }
                if (!ignoreSummaries && currGroup.getType() == 1080) {
                    if (traceMsg != null) {
                        traceMsg.append("Found an unprocessed ragged CogMDXReportSummary of the same hierarchy within de edge.");
                    }
                    return false;
                }
            }
            if (!this.getRaggedNLevelProperty(currGroup).equals("compensationNAForRaggedNested")) continue;
            String raggedCompNA = "Ragged compensation is not applicable to it.";
            if (!checkTargetPathForNACompensation) continue;
            if (currGroup.getType() == 1027) {
                if (traceMsg != null) {
                    traceMsg.append("Found a ragged CogMDXGroup of the same hierarchy within de edge.");
                    traceMsg.append("Ragged compensation is not applicable to it.");
                    return !currGroup.isAncestor(targetGroup) && !targetGroup.isAncestor(currGroup);
                }
                return currGroup.isAncestor(targetGroup) || targetGroup.isAncestor(currGroup);
            }
            if (ignoreSummaries || currGroup.getType() != 1080) continue;
            if (traceMsg != null) {
                traceMsg.append("Found a ragged CogMDXReportSummary of the same hierarchy within de edge.");
                traceMsg.append("Ragged compensation is not applicable to it.");
                return !currGroup.isAncestor(targetGroup) && !targetGroup.isAncestor(currGroup);
            }
            return currGroup.isAncestor(targetGroup) || targetGroup.isAncestor(currGroup);
        }
        return true;
    }
}

