/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.application;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXBooleanExpression;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXDimensionLine;
import com.cognos.xqe.ast.olap.MDXOr;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXTuple;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import java.util.HashSet;
import java.util.Set;

public final class AddAggrForORdMDFsOnDiffHiersToSlicerUsingFilterHier
extends Transformation {
    public AddAggrForORdMDFsOnDiffHiersToSlicerUsingFilterHier() {
        this.mName = "Add Aggregation For ORd Member Detail Filters On Different Hierarchies To Slicer Using Filtered Hierarchy";
        this.mPassNumbers = new int[]{18};
        this.mTypes = new int[]{1107};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue("AggregationRequired") == null) {
            this.traceNodeCondition(false, "The target TNodeORdMDFsOnDiffHiers node has not yet been flagged as necessitating aggregation in the query.", trace);
            return false;
        }
        if (node.getPropertyValue("AggregationRequired") == Boolean.FALSE) {
            this.traceNodeCondition(false, "The query does not require aggregation for the target TNodeORdMDFsOnDiffHiers node.", trace);
            return false;
        }
        if (node.getPropertyValue("AggregationApplied") == Boolean.TRUE) {
            this.traceNodeCondition(false, "Aggregation has already been applied for the target TNodeORdMDFsOnDiffHiers node.", trace);
            return false;
        }
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The child categories of the target TNodeORdMDFsOnDiffHiers node are invalid.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            node.throwInternalError("Internal Error.");
        }
        if (mdxQuery.getDescendantsOfTypes(new int[]{1097, 1185, 1098, 1193}, false).length > 0) {
            this.traceNodeCondition(false, "There are TNodeSlicer nodes in the query that must be processed before this transformation can be applied.", trace);
            return false;
        }
        int[] nodeTypes = new int[]{1093, 1094};
        IXQEQueryNode[] mdfNodes = mdxQuery.getDescendantsOfTypes(nodeTypes, false);
        for (int i = 0; i < mdfNodes.length; ++i) {
            if (mdfNodes[i].getPropertyValue("AggregationRequired") == Boolean.FALSE || node.getPropertyValue("AggregationRequired") == Boolean.TRUE && node.getPropertyValue("AggregationApplied") == Boolean.TRUE) continue;
            this.traceNodeCondition(false, "There is a TNodeMDFOnSingle(Unref)Hierarchy node in this query for which aggregation has not yet been applied.", trace);
            return false;
        }
        HashSet<IHierarchy> hierarchyCandidates = new HashSet<IHierarchy>();
        Set<IHierarchy> hierarchiesReferencedOnEdges = mdxQuery.getReferencedHierarchiesOnEdges();
        MDXOr dfORCondition = (MDXOr)node.getChild(0);
        AbstractMDXBooleanExpression[] orConditionOperands = dfORCondition.getAssociativeOperands(false);
        for (int i = 0; i < orConditionOperands.length; ++i) {
            if (orConditionOperands[i].getType() != 1029 || !orConditionOperands[i].validateChildCategories()) {
                throw new XQERuntimeException();
            }
            AbstractMDXSet filterSet = (AbstractMDXSet)orConditionOperands[i].getChild(1);
            IHierarchy hierarchy = filterSet.getHierarchyInfo().getProjectedHierarchy(0);
            if (hierarchiesReferencedOnEdges.contains(hierarchy)) continue;
            hierarchyCandidates.add(hierarchy);
        }
        MDXDimensionLine dimLine = mdxQuery.getDimensionLine();
        if (!(dimLine == null || dimLine.getNumberChildren() <= 0 || dimLine.getNumberChildren() == 1 && dimLine.getChild(0).isOfCategory(1068) && dimLine.getChild(0).getNumberChildren() == 0)) {
            MDXHierInfo dimLineHierInfo = ((MDXTuple)dimLine.getChild(0)).getHierarchyInfo();
            for (int i = 0; i < dimLineHierInfo.getNumProjectedHierarchies(); ++i) {
                hierarchyCandidates.remove(dimLineHierInfo.getProjectedHierarchy(i));
            }
        }
        if (hierarchyCandidates.size() > 0) {
            this.traceNodeCondition(false, "The TNodeORdMDFsOnDiffHiers contains a filter condition on a hierarchy that is not referenced in the edges of the MDXQuery and that is not projected by the MDXDimensionLine.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The TNodeORdMDFsOnDiffHiers does not contain a filter condition on a hierarchy that is not referenced in the edges of the MDXQuery and that is not projected by the MDXDimensionLine.", trace);
        return false;
    }
}

