/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.application;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXNumericValueExpression;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXComparisonOperator;
import com.cognos.xqe.ast.olap.MDXCount;
import com.cognos.xqe.ast.olap.MDXDimensionLine;
import com.cognos.xqe.ast.olap.MDXNumericIIF;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.MDXSetAliasReference;
import com.cognos.xqe.ast.olap.MDXSummaryFunctionTypeEnum;
import com.cognos.xqe.ast.olap.MDXTuple;
import com.cognos.xqe.ast.olap.TNodeAbstractMDXNode;
import com.cognos.xqe.ast.olap.TNodeAbstractSlicer;
import com.cognos.xqe.ast.olap.TNodeSlicerOnProjectedHierarchy;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.olap.optimization.ReplaceTNodeTrueFalse;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.application.AddAggrForSLOnProjHierToNoMember;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.application.DFSLAggrUtil;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.transformation.olap.util.SolveOrderUtil;
import com.cognos.xqe.util.pool.XQEIntegerPool;

public final class AddAggrForSLOnProjHierToSlicer
extends Transformation {
    public static final String PROP_UNRERENCED_SLICER_HIERARCHY = "unrefSicerHierarchy";
    protected static final String PROP_TRANSFORMATION_NAME = "Add Aggregation for V5 Slicer On Referenced Hierarchy To MDX Slicer.";

    public AddAggrForSLOnProjHierToSlicer() {
        this.mName = PROP_TRANSFORMATION_NAME;
        this.mPassNumbers = new int[]{18};
        this.mTypes = new int[]{1098};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        AbstractMDXSet slicerSet;
        TNodeAbstractSlicer tNodeSlicer = (TNodeAbstractSlicer)node;
        XQENodeFactory factory = environment.getNodeFactory();
        if (!node.getChild(0).isOfCategory(1021)) {
            node.getChild(0).insertParent(factory.createNode(1039));
        }
        if ((slicerSet = (AbstractMDXSet)tNodeSlicer.getChild(0)).getType() == 1145) {
            MDXQuery query = (MDXQuery)tNodeSlicer.getAncestorOfCategory(1002);
            ReplaceTNodeTrueFalse.clearQuery(factory, query);
            AddAggrForSLOnProjHierToSlicer.emptySetInFilteringExpressionWarning(environment, tNodeSlicer.getOriginalExpression());
            return;
        }
        if (!slicerSet.isOfCategory(1021)) {
            MDXSet set = (MDXSet)factory.createNode(1039);
            slicerSet.insertParent(set);
            slicerSet = set;
        }
        MDXQuery mdxQuery = (MDXQuery)tNodeSlicer.getAncestorOfType(1002);
        IHierarchy slicerHierarchy = tNodeSlicer.getHierarchy();
        MDXLevelInfo levelInfo = mdxQuery.getSlicerContextLevelInfo(slicerHierarchy);
        ILevel lowestReferencedLevel = mdxQuery.getLowestReferencedLevel(slicerHierarchy);
        MDXTuple dimLineTuple = AddAggrForSLOnProjHierToSlicer.getDimensionLineTuple(factory, mdxQuery);
        MDXCalculatedMemberReference cm = AddAggrForSLOnProjHierToSlicer.buildCalculation((AbstractMDXSet)factory.deepCopyNode(slicerSet = MDXBuilder.generateLeafMembersToLevel(factory, mdxQuery, slicerSet, lowestReferencedLevel)), levelInfo, lowestReferencedLevel, mdxQuery, tNodeSlicer, factory);
        if (mdxQuery.hasProjectedCalcsWithHigherSolveOrder(cm)) {
            cm.setSlicerCalcIntersectingWithSeveralProjCalc(true);
        }
        if (dimLineTuple == null) {
            dimLineTuple = this.createDimensionLineTuple(factory, mdxQuery);
        } else {
            dimLineTuple.detachChild(0);
        }
        dimLineTuple.addChild(cm, 0);
        tNodeSlicer.detach();
    }

    public static MDXCalculatedMemberReference buildCalculation(AbstractMDXSet slicerSet, MDXLevelInfo levelInfo, ILevel lowestReferencedLevel, MDXQuery mdxQuery, TNodeAbstractMDXNode tNodeSlicer, IXQENodeFactory factory) {
        MDXTuple dimLineTuple = AddAggrForSLOnProjHierToSlicer.getDimensionLineTuple(factory, mdxQuery);
        IHierarchy cmHierarchy = null;
        AbstractMDXMember hierarchyMember = null;
        if (dimLineTuple != null && dimLineTuple.getNumberChildren() > 0) {
            hierarchyMember = (AbstractMDXMember)dimLineTuple.getChild(0);
            cmHierarchy = hierarchyMember.getHierarchyInfo().getProjectedHierarchy(0);
        } else {
            cmHierarchy = (IHierarchy)mdxQuery.getPropertyValue(PROP_UNRERENCED_SLICER_HIERARCHY);
            if (cmHierarchy == null) {
                cmHierarchy = mdxQuery.getUnreferencedHierarchy();
            }
            hierarchyMember = MDXBuilder.buildMDXDefaultMemberExpr(factory, cmHierarchy);
            DFSLAggrUtil.addMemberToContextIndependentSets(factory, mdxQuery, tNodeSlicer, hierarchyMember);
            mdxQuery.setPropertyValue(PROP_UNRERENCED_SLICER_HIERARCHY, cmHierarchy);
        }
        IHierarchy slicerHierarchy = slicerSet.getHierarchyInfo().getProjectedHierarchy(0);
        slicerSet.addMemberToContext(factory, hierarchyMember, true);
        slicerSet.setPropertyValue("DFSLAggrSet", Boolean.TRUE);
        boolean slOrMDFOnhigherOrSameLevel = slicerSet.slicerOrMDFOnHigherlevelOnly();
        if (slicerSet.getType() != 1014) {
            slicerSet = MDXBuilder.buildMDXNamedSet(factory, mdxQuery, "", slicerSet);
        }
        AbstractMDXSet aggrSet = null;
        if (slOrMDFOnhigherOrSameLevel) {
            aggrSet = MDXBuilder.intersectSetWithAncestorsOfCurrentMember(factory, slicerSet);
        } else {
            ILevel highestProjectedLevel = levelInfo.getHighestProjectedLevel(slicerHierarchy);
            if (null != highestProjectedLevel && highestProjectedLevel.equals(lowestReferencedLevel)) {
                MDXSet currentMemberSetExpr = MDXBuilder.buildMDXSetExpr(factory, MDXBuilder.buildMDXCurrentMemberExpr(factory, slicerHierarchy));
                aggrSet = MDXBuilder.buildMDXIntersectExpr(factory, currentMemberSetExpr, slicerSet, false);
                slOrMDFOnhigherOrSameLevel = true;
            } else {
                DFSLAggrUtil.checkHierarchyRollup(slicerHierarchy);
                aggrSet = MDXBuilder.intersectSetWithDescendantsOfCurrentMember(factory, (AbstractMDXSet)factory.deepCopyNode(slicerSet));
            }
        }
        MDXCount mdxCount = MDXBuilder.buildMDXCountExpr(factory, aggrSet, true);
        MDXComparisonOperator gtExpr = MDXBuilder.buildMDXComparisonExpr(factory, 3, mdxCount, MDXBuilder.buildMDXNumericConstant(factory, 0));
        AbstractMDXNumericValueExpression aggrExpr = null;
        if (slOrMDFOnhigherOrSameLevel) {
            aggrExpr = MDXBuilder.coerceToNumericValueExpression(MDXBuilder.buildMDXCurrentMemberExpr(factory, slicerHierarchy), factory);
            aggrExpr.addMemberToContext(factory, hierarchyMember, true);
        } else {
            MDXSetAliasReference aliasRef = MDXBuilder.buildMDXSetAlias(factory, mdxQuery, aggrSet);
            aggrExpr = MDXBuilder.buildMDXSummaryFunctionExpr(factory, MDXSummaryFunctionTypeEnum.AGGREGATE, aliasRef, null);
            aggrExpr.addChild(MDXBuilder.coerceToValueExpression(factory.deepCopyNode(hierarchyMember), factory));
        }
        MDXNumericIIF iifExpr = MDXBuilder.buildMDXNumericIIFExprWithNull(factory, gtExpr, aggrExpr);
        iifExpr.setPropertyValue("DFSLAggrIIF", Boolean.TRUE);
        return MDXBuilder.buildMDXCalculatedMemberReference(factory, mdxQuery, hierarchyMember.getHierarchy(), "_SL", iifExpr, SolveOrderUtil.getCubeCalcSolveOrder());
    }

    protected static MDXTuple getDimensionLineTuple(IXQENodeFactory factory, MDXQuery mdxQuery) {
        MDXDimensionLine dimLine = mdxQuery.getDimensionLine();
        if (dimLine != null) {
            return (MDXTuple)dimLine.getChild(0);
        }
        return null;
    }

    private MDXTuple createDimensionLineTuple(IXQENodeFactory factory, MDXQuery mdxQuery) {
        IXQEQueryNode dimLine = factory.createNode(1008);
        dimLine.addChild(factory.createNode(1069));
        mdxQuery.addChild(dimLine);
        return (MDXTuple)dimLine.getChild(0);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] projSlicers;
        XQETrace trace = environment.getTrace();
        StringBuilder sb = new StringBuilder();
        if (!AddAggrForSLOnProjHierToSlicer.nodeCondition(node, sb)) {
            this.traceNodeCondition(false, sb.toString(), trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        for (IXQEQueryNode slicer : projSlicers = mdxQuery.getDescendantsOfType(1098, false)) {
            IHierarchy slicerHierarchy = ((TNodeAbstractSlicer)slicer).getHierarchy();
            if (AddAggrForSLOnProjHierToNoMember.findNoMembers(mdxQuery, slicerHierarchy).isEmpty()) continue;
            this.traceNodeCondition(false, "There are NOMEMBER nodes that must be updated first.", trace);
            return false;
        }
        this.traceNodeCondition(true, "There is an available hierarchy that can be used to create a calculated member on the DimensionLine, and some or all of the projected details in the slicer hierarchy are from levels that are higher than the lowest referencelevel from that hierarchy in the query.", trace);
        return true;
    }

    protected static boolean nodeCondition(IXQEQueryNode node, StringBuilder sb) {
        String reaggregationHostName = DFSLAggrUtil.getReaggregationHostName((TNodeSlicerOnProjectedHierarchy)node);
        if (reaggregationHostName == null || reaggregationHostName.compareTo("reaggregationHostDimensionLine") != 0) {
            sb.append("The slicer is not set to be applied to dimension line.");
            return false;
        }
        node.throwOnInvalidChildCategories();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            node.throwInternalError("Internal Error.");
        }
        if (mdxQuery.getDescendantsOfType(1097, false).length > 0) {
            sb.append("There are slicers on unreferenced hierarchies that have not been applied.");
            return false;
        }
        MDXDimensionLine dimLine = mdxQuery.getDimensionLine();
        MDXTuple dimLineTuple = null;
        if (dimLine != null) {
            if (dimLine.getNumberChildren() != 1 || !dimLine.getChild(0).isOfCategory(1068)) {
                sb.append("The DimensionLine node does not contain a single MDXTuple child node.");
                return false;
            }
            dimLineTuple = (MDXTuple)dimLine.getChild(0);
        }
        MDXHierInfo targetHierInfo = ((AbstractMDXNode)node.getChild(0)).getHierarchyInfo();
        IHierarchy slicerHierarchy = targetHierInfo.getProjectedHierarchy(0);
        MDXHierInfo dimLineHierInfo = null;
        if (dimLineTuple != null && (dimLineHierInfo = dimLineTuple.getHierarchyInfo()).projectsHierarchy(slicerHierarchy)) {
            sb.append("The first child of the target TNodeSlicerOnReferencedHierarchy node projects a hierarchy that is already projected on the dimension line.");
            return false;
        }
        if ((dimLineTuple == null || dimLineHierInfo.getNumProjectedHierarchies() == 0) && mdxQuery.getUnreferencedHierarchy() == null) {
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_TransformationFailNoUnrefHier, PROP_TRANSFORMATION_NAME, XQEIntegerPool.getInteger(node.getId()).toString());
        }
        return true;
    }

    protected static void emptySetInFilteringExpressionWarning(PlanningEnvironment environment, String expression) {
        if (expression != null) {
            int aSeverity = 1;
            environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_EmptySetInFilteringExpression, expression));
        }
    }
}

