/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.application;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXBooleanExpression;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXIn;
import com.cognos.xqe.ast.olap.MDXCount;
import com.cognos.xqe.ast.olap.MDXOr;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeApplyORdMDFsOnDiffHiersToSet;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.application.ApplyValueDetailFiltersToSet;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.application.DFSLAggrUtil;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import java.util.ArrayList;
import java.util.List;

public final class ApplyORdMDFsOnDiffHiersToSet
extends Transformation {
    public ApplyORdMDFsOnDiffHiersToSet() {
        this.mName = "Apply ORd Member Detail Filters On Different Hierarchies To Set.";
        this.mPassNumbers = new int[]{18};
        this.mTypes = new int[]{1112};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        AbstractMDXSet targetSet = (AbstractMDXSet)node.getChild(0);
        MDXHierInfo targetSetHierInfo = targetSet.getHierarchyInfo();
        MDXLevelInfo targetSetLevelInfo = targetSet.getLevelInfo();
        Integer filterId = ((TNodeApplyORdMDFsOnDiffHiersToSet)node).getDetailFilterIds().remove(0);
        IXQEQueryNode tNodeORdMDFsOnDiffHiers = (IXQEQueryNode)factory.getNodeIndex().getNodeByID(filterId);
        MDXOr dfORCondition = (MDXOr)tNodeORdMDFsOnDiffHiers.getChild(0);
        IXQEQueryNode dfORExpr = this.createChildLogicExpressions(dfORCondition, targetSetHierInfo, targetSetLevelInfo, factory);
        IXQEQueryNode mdxFilter = factory.createNode(1053);
        targetSet.insertParent(mdxFilter);
        mdxFilter.addChild(dfORExpr);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        XQETrace trace = environment.getTrace();
        List<Integer> detailFilterIds = ((TNodeApplyORdMDFsOnDiffHiersToSet)node).getDetailFilterIds();
        if (detailFilterIds.size() == 0) {
            this.traceNodeCondition(false, "The TNodeApplyORdMDFsOnDiffHiersToSet node has no remaining detail filter ids.", trace);
            return false;
        }
        IXQEQueryNode tNodeORdMDFsOnDiffHiers = (IXQEQueryNode)factory.getNodeIndex().getNodeByID(detailFilterIds.get(0));
        IXQEQueryNode mdxQuery = node.getAncestorOfType(1002);
        if (tNodeORdMDFsOnDiffHiers == null || !tNodeORdMDFsOnDiffHiers.isAncestor(mdxQuery)) {
            node.throwInternalError("Invalid TNode.");
        }
        if (!tNodeORdMDFsOnDiffHiers.validateChildCategories()) {
            this.traceNodeCondition(false, "The child categories of the next applicable TNodeORdMDFsOnDiffHiers node are invalid.", trace);
            return false;
        }
        IXQEQueryNode targetSet = node.getChild(0);
        if (!targetSet.isOfCategory(1021)) {
            this.traceNodeCondition(false, "The target node is not an AbstractMDXSet instance.", trace);
            return false;
        }
        IXQEQueryNode[] tNodeVDFs = mdxQuery.getDescendantsOfType(1095, false);
        for (int i = 0; i < tNodeVDFs.length; ++i) {
            if (tNodeVDFs[i].getPropertyValue("DistributeVDFToPreMDXFilteringSets") == Boolean.TRUE) continue;
            this.traceNodeCondition(false, "The query contains TNodeValueDetailFilter nodes that have not yet been distributed to all parts of the query.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The next detail filter is applicable.", trace);
        return true;
    }

    private IXQEQueryNode createChildLogicExpressions(AbstractMDXBooleanExpression dfCondition, MDXHierInfo targetSetHierInfo, MDXLevelInfo targetSetLevelInfo, IXQENodeFactory factory) {
        if (dfCondition.getType() == 1029) {
            if (!dfCondition.validateChildCategories()) {
                throw new XQERuntimeException();
            }
            return this.buildLogicalExprForCogMDXIn((CogMDXIn)dfCondition, targetSetHierInfo, targetSetLevelInfo, factory);
        }
        AbstractMDXBooleanExpression[] operands = dfCondition.getAssociativeOperands(false);
        ArrayList<IXQEQueryNode> childrenExprList = new ArrayList<IXQEQueryNode>();
        for (int i = 0; i < operands.length; ++i) {
            IXQEQueryNode childExpr = this.createChildLogicExpressions(operands[i], targetSetHierInfo, targetSetLevelInfo, factory);
            childrenExprList.add(childExpr);
        }
        return DFSLAggrUtil.buildFilterExpression(dfCondition, childrenExprList, factory);
    }

    private IXQEQueryNode buildLogicalExprForCogMDXIn(CogMDXIn cogMDXIn, MDXHierInfo targetSetHierInfo, MDXLevelInfo targetSetLevelInfo, IXQENodeFactory factory) {
        MDXQuery mdxQuery = (MDXQuery)cogMDXIn.getAncestorOfType(1002);
        AbstractMDXSet filterSet = (AbstractMDXSet)factory.deepCopyNode(cogMDXIn.getChild(1));
        MDXHierInfo hierInfo = filterSet.getHierarchyInfo();
        if (hierInfo.compareProjectedHierarchies(targetSetHierInfo)) {
            filterSet = MDXBuilder.correlateSetToLevels(factory, filterSet, targetSetLevelInfo);
            filterSet = MDXBuilder.buildMDXNamedSet(factory, mdxQuery, "", filterSet);
            filterSet = MDXBuilder.buildMDXIntersectCurrentMemberExpr(factory, targetSetHierInfo.getProjectedHierarchy(0), filterSet);
        } else {
            filterSet = ApplyValueDetailFiltersToSet.applyApplicableMDFs(factory, mdxQuery, filterSet);
            filterSet = MDXBuilder.buildMDXHeadExpr(factory, filterSet);
            filterSet = MDXBuilder.buildMDXCrossjoinCurrentMemberExpr(factory, targetSetHierInfo.getProjectedHierarchy(0), filterSet);
        }
        MDXCount mdxCount = MDXBuilder.buildMDXCountExpr(factory, filterSet, true);
        return MDXBuilder.buildMDXComparisonExpr(factory, 3, mdxCount, MDXBuilder.buildMDXNumericConstant(factory, 0));
    }
}

