/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.application;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXBooleanExpression;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXNumericValueExpression;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXComparisonOperator;
import com.cognos.xqe.ast.olap.MDXCount;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXNumericIIF;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.MDXSetAliasReference;
import com.cognos.xqe.ast.olap.MDXSummaryFunction;
import com.cognos.xqe.ast.olap.MDXSummaryFunctionTypeEnum;
import com.cognos.xqe.ast.olap.TNodeAbstractMDXNode;
import com.cognos.xqe.ast.olap.TNodeApplyReaggregationToMeasure;
import com.cognos.xqe.ast.olap.TNodeValueDetailFilter;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.application.DFSLAggrUtil;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.transformation.olap.util.SolveOrderUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ApplyReaggregationForDetailFiltersAndSlicersToMeasure
extends Transformation {
    public ApplyReaggregationForDetailFiltersAndSlicersToMeasure() {
        this.mName = "Apply Re-aggregation for Detail Filters and Slicers to Measures On Edge.";
        this.mPassNumbers = new int[]{18};
        this.mTypes = new int[]{1172};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        List<BaseMember> measures = mdxQuery.collectBaseMeasures();
        for (TNodeAbstractMDXNode filterTNode : ((TNodeApplyReaggregationToMeasure)node).getRegisteredDetailFilters()) {
            IXQEQueryNode[] baseMembers = null;
            for (int i = 1; i < filterTNode.getNumberChildren(); ++i) {
                baseMembers = filterTNode.getChild(i).getDescendantsOfType(1067, false);
                measures.removeAll(Arrays.asList(baseMembers));
            }
        }
        ArrayList<TNodeAbstractMDXNode> slList = new ArrayList<TNodeAbstractMDXNode>();
        slList.addAll(this.getRegisteredTNodeByType((TNodeApplyReaggregationToMeasure)node, 1098));
        slList.addAll(this.getRegisteredTNodeByType((TNodeApplyReaggregationToMeasure)node, 1097));
        slList.addAll(this.getRegisteredTNodeByType((TNodeApplyReaggregationToMeasure)node, 1097));
        ArrayList<TNodeAbstractMDXNode> singleHierarchyMDFList = new ArrayList<TNodeAbstractMDXNode>();
        singleHierarchyMDFList.addAll(this.getRegisteredTNodeByType((TNodeApplyReaggregationToMeasure)node, 1093));
        singleHierarchyMDFList.addAll(this.getRegisteredTNodeByType((TNodeApplyReaggregationToMeasure)node, 1193));
        singleHierarchyMDFList.addAll(this.getRegisteredTNodeByType((TNodeApplyReaggregationToMeasure)node, 1094));
        Map<IHierarchy, AbstractMDXSet> reaggregationSetMap = this.buildHierarchyToReaggregationSetMapForMDFAndSL(singleHierarchyMDFList, slList, mdxQuery, factory);
        List<TNodeAbstractMDXNode> vdfList = this.getRegisteredTNodeByType((TNodeApplyReaggregationToMeasure)node, 1095);
        if (vdfList.size() > 1) {
            node.throwInternalError("Value detail filters were not consolidated before being applied.");
        }
        TNodeValueDetailFilter vdfNode = null;
        if (vdfList.size() == 1) {
            vdfNode = (TNodeValueDetailFilter)vdfList.get(0);
            if (!reaggregationSetMap.isEmpty()) {
                ArrayList<IXQEQueryNode> measuresInVDF = new ArrayList<IXQEQueryNode>();
                measuresInVDF.addAll(Arrays.asList(vdfNode.getAggregationExpression().getDescendantsOfType(1067, false)));
                measuresInVDF.addAll(Arrays.asList(vdfNode.getSingleVDFCondition().getDescendantsOfType(1067, false)));
                HashMap<BaseMember, AbstractMDXMember> measureToCalc = new HashMap<BaseMember, AbstractMDXMember>();
                for (IXQEQueryNode iXQEQueryNode : measuresInVDF) {
                    if (!((BaseMember)iXQEQueryNode).isMeasure() || this.replaceMeasureWithPreviousDefinition((BaseMember)iXQEQueryNode, measureToCalc, factory, mdxQuery)) continue;
                    AbstractMDXMember postMDFCalculatedMeasure = this.applyReaggregationForMDFAndSLToMeasure(reaggregationSetMap, (AbstractMDXMember)factory.deepCopyNode(iXQEQueryNode), mdxQuery, factory);
                    measureToCalc.put((BaseMember)iXQEQueryNode, postMDFCalculatedMeasure);
                    ((MDXCalculatedMemberReference)postMDFCalculatedMeasure).setCopyDefinition(false);
                    iXQEQueryNode.exchange(postMDFCalculatedMeasure, true);
                }
            }
        }
        HashMap<BaseMember, AbstractMDXMember> measureToCalc = new HashMap<BaseMember, AbstractMDXMember>();
        HashMap<BaseMember, AbstractMDXMember> measureToCalcForVDFMeasure = new HashMap<BaseMember, AbstractMDXMember>();
        for (BaseMember baseMember : measures) {
            if (baseMember.getParent().getType() == 1099) continue;
            boolean applyVDFToTargetMeasure = false;
            if (vdfNode != null) {
                applyVDFToTargetMeasure = true;
                AbstractMDXBooleanExpression vdfCond = vdfNode.getSingleVDFCondition();
                List<Integer> tnIds = vdfNode.getTNodeApplyVDFSetIds();
                Iterator<Integer> it = tnIds.iterator();
                boolean includeSelf = false;
                while (it.hasNext() && applyVDFToTargetMeasure) {
                    Integer tnId = it.next();
                    IXQEQueryNode tNodeApplyVDFToSet = (IXQEQueryNode)factory.getNodeIndex().getNodeByID(tnId);
                    List<IXQEQueryNode> conditions = tNodeApplyVDFToSet.getDescendantsOfCategory(1071, includeSelf);
                    Iterator<IXQEQueryNode> itCond = conditions.iterator();
                    block5: while (itCond.hasNext() && applyVDFToTargetMeasure) {
                        AbstractMDXBooleanExpression cond = (AbstractMDXBooleanExpression)itCond.next();
                        if (!cond.isSameExpression(vdfCond, false)) continue;
                        IXQEQueryNode[] baseMembers = cond.getDescendantsOfType(1067, false);
                        for (int i = 0; i < baseMembers.length; ++i) {
                            if (baseMember != baseMembers[i]) continue;
                            applyVDFToTargetMeasure = false;
                            continue block5;
                        }
                    }
                }
            }
            AbstractMDXMember postFilterCalculatedMeasure = null;
            if (applyVDFToTargetMeasure) {
                if (this.replaceMeasureWithPreviousDefinition(baseMember, measureToCalc, factory, mdxQuery)) continue;
                postFilterCalculatedMeasure = this.applyReaggregationForVDFToMeasure(vdfNode, (AbstractMDXMember)factory.deepCopyNode(baseMember), reaggregationSetMap, mdxQuery, factory);
                measureToCalc.put(baseMember, postFilterCalculatedMeasure);
            } else if (!reaggregationSetMap.isEmpty()) {
                if (this.replaceMeasureWithPreviousDefinition(baseMember, measureToCalcForVDFMeasure, factory, mdxQuery)) continue;
                postFilterCalculatedMeasure = this.applyReaggregationForMDFAndSLToMeasure(reaggregationSetMap, (AbstractMDXMember)factory.deepCopyNode(baseMember), mdxQuery, factory);
                measureToCalcForVDFMeasure.put(baseMember, postFilterCalculatedMeasure);
            }
            if (postFilterCalculatedMeasure == null) continue;
            ((MDXCalculatedMemberReference)postFilterCalculatedMeasure).setIsV5CalculatedMember();
            ((MDXCalculatedMemberReference)postFilterCalculatedMeasure).setCopyDefinition(false);
            DFSLAggrUtil.replaceBaseMeasureWithReaggregationCalculatedMeasure(baseMember, (MDXCalculatedMemberReference)postFilterCalculatedMeasure, factory);
        }
        for (TNodeAbstractMDXNode tNodeAbstractMDXNode : slList) {
            tNodeAbstractMDXNode.detach();
        }
        List<TNodeAbstractMDXNode> tNodes = null;
        for (TNodeAbstractMDXNode mdf : singleHierarchyMDFList) {
            MDXHierInfo dfHierInfo = ((AbstractMDXSet)mdf.getChild(0).getChild(0)).getHierarchyInfo();
            IHierarchy dfHierarchy = dfHierInfo.getProjectedHierarchy(0);
            tNodes = DFSLAggrUtil.getUnprocessedMDFsOnHierarchy(mdxQuery, dfHierarchy);
            DFSLAggrUtil.flagNodesWithAggregationApplied(tNodes);
        }
        tNodes = DFSLAggrUtil.getUnprocessedVDFs(mdxQuery);
        DFSLAggrUtil.flagNodesWithAggregationApplied(tNodes);
        node.extract();
    }

    private boolean replaceMeasureWithPreviousDefinition(BaseMember measure, Map<BaseMember, AbstractMDXMember> measureToCalc, IXQENodeFactory factory, MDXQuery mdxQuery) {
        boolean isProjectedMeasure = false;
        MDXEdge edge = (MDXEdge)measure.getAncestorOfType(1006);
        if (edge != null && edge.isProjectedDescendant(measure)) {
            isProjectedMeasure = true;
        }
        for (BaseMember previousMeasure : measureToCalc.keySet()) {
            MDXCalculatedMemberReference newCalcMeasure = null;
            if (!previousMeasure.isSameExpression(measure, false)) continue;
            MDXCalculatedMemberReference calcMeasure = (MDXCalculatedMemberReference)measureToCalc.get(previousMeasure);
            if (isProjectedMeasure) {
                AbstractMDXNode definition = (AbstractMDXNode)calcMeasure.getDefinition().getChild(0);
                definition = (AbstractMDXNode)factory.deepCopyNode(definition);
                newCalcMeasure = MDXBuilder.buildMDXCalculatedMemberReference(factory, mdxQuery, mdxQuery.getMeasuresHierarchy(), calcMeasure.getDefinition().getPrefix(), definition, SolveOrderUtil.getCubeCalcSolveOrder());
                if (calcMeasure.isSlicerCalcIntersectingWithSeveralProjCalc()) {
                    newCalcMeasure.setSlicerCalcIntersectingWithSeveralProjCalc(true);
                }
            } else {
                newCalcMeasure = (MDXCalculatedMemberReference)factory.createNode(1013);
                newCalcMeasure.bind(calcMeasure.getDefinition());
            }
            newCalcMeasure.setIsV5CalculatedMember();
            DFSLAggrUtil.replaceBaseMeasureWithReaggregationCalculatedMeasure(measure, newCalcMeasure, factory);
            newCalcMeasure.setCopyDefinition(false);
            return true;
        }
        return false;
    }

    private List<TNodeAbstractMDXNode> getRegisteredTNodeByType(TNodeApplyReaggregationToMeasure applyReaggregationNode, int nodeType) {
        ArrayList<TNodeAbstractMDXNode> result = new ArrayList<TNodeAbstractMDXNode>();
        List<TNodeAbstractMDXNode> detailFilterList = applyReaggregationNode.getRegisteredDetailFilters();
        for (TNodeAbstractMDXNode tnode : detailFilterList) {
            if (tnode.getType() != nodeType) continue;
            result.add(tnode);
        }
        return result;
    }

    private AbstractMDXSet buildSingleAggregationSetForAllMDFAndSL(Map<IHierarchy, AbstractMDXSet> setMap, IXQENodeFactory factory) {
        AbstractMDXSet aggrSet = null;
        if (setMap.isEmpty()) {
            return null;
        }
        for (Map.Entry<IHierarchy, AbstractMDXSet> reaggregationSetEntry : setMap.entrySet()) {
            AbstractMDXSet reaggregationSet = (AbstractMDXSet)factory.deepCopyNode(reaggregationSetEntry.getValue());
            if (aggrSet == null) {
                aggrSet = reaggregationSet;
                continue;
            }
            aggrSet = MDXBuilder.buildMDXCrossjoinExpr(factory, aggrSet, reaggregationSet);
        }
        return aggrSet;
    }

    private Map<IHierarchy, AbstractMDXSet> buildHierarchyToReaggregationSetMapForMDFAndSL(List<TNodeAbstractMDXNode> mdfList, List<TNodeAbstractMDXNode> slList, MDXQuery mdxQuery, IXQENodeFactory factory) {
        HashMap<IHierarchy, AbstractMDXSet> resultMap = new HashMap<IHierarchy, AbstractMDXSet>();
        HashSet<IHierarchy> unrefHierSet = new HashSet<IHierarchy>();
        boolean slOrMDFOnhigherLevel = false;
        int[] typeUnrefHierTNode = new int[]{1097, 1094};
        for (TNodeAbstractMDXNode tNodeAbstractMDXNode : slList) {
            if (!tNodeAbstractMDXNode.getChild(0).isOfCategory(1021)) {
                tNodeAbstractMDXNode.getChild(0).insertParent(factory.createNode(1039));
            }
            AbstractMDXSet slicerSet = (AbstractMDXSet)tNodeAbstractMDXNode.getChild(0);
            MDXHierInfo slicerSetHierInfo = slicerSet.getHierarchyInfo();
            IHierarchy slicerHierarchy = slicerSetHierInfo.getProjectedHierarchy(0);
            if (tNodeAbstractMDXNode.isOfTypes(typeUnrefHierTNode)) {
                unrefHierSet.add(slicerHierarchy);
            }
            ILevel lowestReferencedLevel = mdxQuery.getLowestReferencedLevel(slicerHierarchy);
            slicerSet = MDXBuilder.generateLeafMembersToLevel(factory, mdxQuery, slicerSet, lowestReferencedLevel);
            slOrMDFOnhigherLevel = slicerSet.slicerOrMDFOnHigherlevelOnly();
            slicerSet.setPropertyValue("DFSLAggrSet", Boolean.TRUE);
            if (slicerSet.getType() != 1014) {
                slicerSet = MDXBuilder.buildMDXNamedSet(factory, mdxQuery, "", slicerSet);
            }
            resultMap.put(slicerHierarchy, slicerSet);
        }
        for (TNodeAbstractMDXNode tNodeAbstractMDXNode : mdfList) {
            AbstractMDXSet existingSetForTheHierarchy;
            AbstractMDXSet mdfAggregationSet = (AbstractMDXSet)factory.deepCopyNode(DFSLAggrUtil.getSingleMDFAggregationSet(tNodeAbstractMDXNode));
            IHierarchy mdfHier = mdfAggregationSet.getHierarchyInfo().getProjectedHierarchy(0);
            if (tNodeAbstractMDXNode.isOfTypes(typeUnrefHierTNode)) {
                unrefHierSet.add(mdfHier);
            }
            if ((existingSetForTheHierarchy = resultMap.get(mdfHier)) != null) {
                mdfAggregationSet = MDXBuilder.buildMDXIntersectExpr(factory, mdfAggregationSet, existingSetForTheHierarchy, false);
            }
            resultMap.put(mdfHier, mdfAggregationSet);
        }
        for (Map.Entry entry : resultMap.entrySet()) {
            if (unrefHierSet.contains(entry.getKey())) continue;
            AbstractMDXSet reaggregationSet = (AbstractMDXSet)entry.getValue();
            if (slOrMDFOnhigherLevel) {
                reaggregationSet = MDXBuilder.intersectSetWithAncestorsOfCurrentMember(factory, reaggregationSet);
                reaggregationSet.setSLOrMDFOnHigherlevelProperty(slOrMDFOnhigherLevel);
            } else {
                IHierarchy hierarchy = reaggregationSet.getHierarchyInfo().getProjectedHierarchy(0);
                ILevel lowestReferencedLevel = mdxQuery.getLowestReferencedLevel(hierarchy);
                MDXLevelInfo levelInfo = mdxQuery.getSlicerContextLevelInfo(hierarchy);
                ILevel highestProjectedLevel = levelInfo.getHighestProjectedLevel(hierarchy);
                if (null != highestProjectedLevel && highestProjectedLevel.equals(lowestReferencedLevel)) {
                    MDXSet currentMemberSetExpr = MDXBuilder.buildMDXSetExpr(factory, MDXBuilder.buildMDXCurrentMemberExpr(factory, hierarchy));
                    reaggregationSet = MDXBuilder.buildMDXIntersectExpr(factory, currentMemberSetExpr, reaggregationSet, false);
                    reaggregationSet.setSLOrMDFOnHigherlevelProperty(Boolean.TRUE);
                } else {
                    DFSLAggrUtil.checkHierarchyRollup(hierarchy);
                    reaggregationSet = MDXBuilder.intersectSetWithDescendantsOfCurrentMember(factory, reaggregationSet);
                }
            }
            entry.setValue(reaggregationSet);
        }
        return resultMap;
    }

    public AbstractMDXMember applyReaggregationForMDFAndSLToMeasure(Map<IHierarchy, AbstractMDXSet> setMap, AbstractMDXMember measure, MDXQuery mdxQuery, IXQENodeFactory factory) {
        if (setMap.isEmpty()) {
            return measure;
        }
        int numEdgesWithCalcs = this.findHowManyEdgesHaveProjectedCalcsWithHigherSolveOrder(mdxQuery);
        AbstractMDXNumericValueExpression cmExpr = null;
        AbstractMDXSet mdfAggregationSet = this.buildSingleAggregationSetForAllMDFAndSL(setMap, factory);
        if (!mdfAggregationSet.couldResolveToEmptySet(false, false, false)) {
            cmExpr = MDXBuilder.buildMDXSummaryFunctionExpr(factory, MDXSummaryFunctionTypeEnum.AGGREGATE, (AbstractMDXSet)factory.deepCopyNode(mdfAggregationSet), null);
            cmExpr.addMemberToContext(factory, measure, true);
        } else {
            MDXCount mdxCount = MDXBuilder.buildMDXCountExpr(factory, mdfAggregationSet, true);
            MDXComparisonOperator gtExpr = MDXBuilder.buildMDXComparisonExpr(factory, 3, mdxCount, MDXBuilder.buildMDXNumericConstant(factory, 0));
            MDXSummaryFunction aggrExpr = null;
            boolean slOrMDFOnhigherLevel = mdfAggregationSet.slicerOrMDFOnHigherlevelOnly();
            if (slOrMDFOnhigherLevel) {
                MDXSet currentMemberSet = MDXBuilder.buildMDXSetExpr(factory, MDXBuilder.buildMDXCurrentMemberExpr(factory, mdfAggregationSet.getHierarchyInfo().getProjectedHierarchy(0)));
                aggrExpr = MDXBuilder.buildMDXSummaryFunctionExpr(factory, MDXSummaryFunctionTypeEnum.AGGREGATE, currentMemberSet, null);
            } else {
                aggrExpr = MDXBuilder.buildMDXSummaryFunctionExpr(factory, MDXSummaryFunctionTypeEnum.AGGREGATE, (AbstractMDXSet)factory.deepCopyNode(mdfAggregationSet), null);
            }
            if (numEdgesWithCalcs > 1) {
                aggrExpr.setSlicerCalcIntersectingWithSeveralProjCalc(true);
            }
            MDXNumericIIF iifExpr = MDXBuilder.buildMDXNumericIIFExprWithNull(factory, gtExpr, aggrExpr);
            iifExpr.setPropertyValue("DFSLAggrIIF", Boolean.TRUE);
            iifExpr.addMemberToContext(factory, measure, true);
            IXQEQueryNode[] setAliasRefs = iifExpr.getDescendantsOfType(1015, false);
            for (int i = 0; i < setAliasRefs.length; ++i) {
                MDXSetAliasReference ref = (MDXSetAliasReference)setAliasRefs[i];
                ref.exchange(factory.deepCopyNode(ref.getDefinition().getChild(0)));
            }
            cmExpr = iifExpr;
        }
        MDXCalculatedMemberReference cm = MDXBuilder.buildMDXCalculatedMemberReference(factory, mdxQuery, mdxQuery.getMeasuresHierarchy(), "_MDF_SL", cmExpr, SolveOrderUtil.getCubeCalcSolveOrder());
        if (numEdgesWithCalcs > 1) {
            cm.setSlicerCalcIntersectingWithSeveralProjCalc(true);
        }
        return cm;
    }

    private int findHowManyEdgesHaveProjectedCalcsWithHigherSolveOrder(MDXQuery mdxQuery) {
        MDXEdge[] edges;
        int numEdgesWithCalcs = 0;
        for (MDXEdge edge : edges = mdxQuery.getEdges()) {
            IXQEQueryNode[] calcs = edge.getDescendantsOfType(1013, false);
            boolean edgeHasCalc = false;
            for (IXQEQueryNode calc : calcs) {
                if (!edge.isProjectedDescendant((AbstractMDXNode)calc) || ((MDXCalculatedMemberReference)calc).getSolveOrder() <= SolveOrderUtil.getCubeCalcSolveOrder()) continue;
                edgeHasCalc = true;
                break;
            }
            if (!edgeHasCalc) continue;
            ++numEdgesWithCalcs;
        }
        return numEdgesWithCalcs;
    }

    public AbstractMDXMember applyReaggregationForVDFToMeasure(TNodeValueDetailFilter vdfNode, AbstractMDXMember postFilterMeasure, Map<IHierarchy, AbstractMDXSet> mdfslSetMap, MDXQuery mdxQuery, IXQENodeFactory factory) {
        AbstractMDXSet aggrSet = (AbstractMDXSet)factory.deepCopyNode(vdfNode.getAggregationExpression());
        AbstractMDXBooleanExpression copyCond = (AbstractMDXBooleanExpression)factory.deepCopyNode(vdfNode.getSingleVDFCondition());
        MDXNumericIIF iifExpr = null;
        if (aggrSet.getType() == 1039 && aggrSet.getNumberChildren() == 1 && aggrSet.getChild(0).getType() == 1076) {
            iifExpr = MDXBuilder.buildMDXNumericIIFExprWithNull(factory, copyCond, (AbstractMDXNumericValueExpression)MDXBuilder.coerceToValueExpression(postFilterMeasure, factory));
        } else {
            AbstractMDXSet mdfAggregationSet = this.buildSingleAggregationSetForAllMDFAndSL(mdfslSetMap, factory);
            iifExpr = DFSLAggrUtil.buildVDFReaggregationExpression(factory, mdxQuery, aggrSet, copyCond, mdfAggregationSet, false);
            iifExpr.addMemberToContext(factory, postFilterMeasure, true);
        }
        IXQEQueryNode[] setAliasRefs = iifExpr.getDescendantsOfType(1015, false);
        for (int i = 0; i < setAliasRefs.length; ++i) {
            MDXSetAliasReference ref = (MDXSetAliasReference)setAliasRefs[i];
            ref.exchange(factory.deepCopyNode(ref.getDefinition().getChild(0)));
        }
        MDXCalculatedMemberReference cm = MDXBuilder.buildMDXCalculatedMemberReference(factory, mdxQuery, mdxQuery.getMeasuresHierarchy(), "_VDF", iifExpr, SolveOrderUtil.getCubeCalcSolveOrder());
        return cm;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        int[] dfTnodeTypes = new int[]{1095, 1093, 1193, 1094, 1098, 1097, 1185};
        IXQEQueryNode[] df = mdxQuery.getDescendantsOfTypes(dfTnodeTypes, false);
        for (int i = 0; i < df.length; ++i) {
            if (DFSLAggrUtil.getReaggregationHostName((TNodeAbstractMDXNode)df[i]) != null) continue;
            this.traceNodeCondition(false, "Reaggregation host property has not been set for value detail filter.", trace);
            return false;
        }
        List<TNodeAbstractMDXNode> vdfList = this.getRegisteredTNodeByType((TNodeApplyReaggregationToMeasure)node, 1095);
        for (TNodeAbstractMDXNode tnode : vdfList) {
            if (this.isVDFReadyToBeApplied((TNodeValueDetailFilter)tnode, trace)) continue;
            return false;
        }
        ArrayList<TNodeAbstractMDXNode> singleHierarchyMDFList = new ArrayList<TNodeAbstractMDXNode>();
        singleHierarchyMDFList.addAll(this.getRegisteredTNodeByType((TNodeApplyReaggregationToMeasure)node, 1093));
        singleHierarchyMDFList.addAll(this.getRegisteredTNodeByType((TNodeApplyReaggregationToMeasure)node, 1193));
        singleHierarchyMDFList.addAll(this.getRegisteredTNodeByType((TNodeApplyReaggregationToMeasure)node, 1094));
        for (TNodeAbstractMDXNode tnode : singleHierarchyMDFList) {
            if (this.isMDFReadyToBeApplied(tnode, trace)) continue;
            return false;
        }
        this.traceNodeCondition(true, "Reaggregation triggered by  detail filters can be applied to measures in query.", trace);
        return true;
    }

    private boolean isVDFReadyToBeApplied(TNodeValueDetailFilter vdfTNode, XQETrace trace) {
        if (vdfTNode.getPropertyValue("AggregationApplied") == Boolean.TRUE) {
            this.traceNodeCondition(false, "Aggregation has already been applied for the target TNodeValueDetailFilter node.", trace);
            return false;
        }
        if (!vdfTNode.isReadyToBeApplied()) {
            this.traceNodeCondition(false, "The value detail filter does not have required information. BuildAggrForVDF and SetReaggregationHostProperty need to be applied first.", trace);
            return false;
        }
        if (vdfTNode.getReaggregationHostName().compareTo("reaggregationHostMeasure") != 0) {
            this.traceNodeCondition(false, "The value detail filter is not set to be applied to measures on edge.", trace);
            return false;
        }
        if (!vdfTNode.validateChildCategories()) {
            this.traceNodeCondition(false, "The child categories of the target TNodeValueDetailFilter node are invalid.", trace);
            return false;
        }
        return true;
    }

    private boolean isMDFReadyToBeApplied(TNodeAbstractMDXNode mdfTNode, XQETrace trace) {
        if (DFSLAggrUtil.getReaggregationHostName(mdfTNode) == null) {
            this.traceNodeCondition(false, "The member detail filter does not have required information. SetReaggregationHostProperty need to be applied first.", trace);
            return false;
        }
        if (DFSLAggrUtil.getReaggregationHostName(mdfTNode).compareTo("reaggregationHostMeasure") != 0) {
            this.traceNodeCondition(false, "The member detail filter is not set to be applied to measures on edge.", trace);
            return false;
        }
        if (!mdfTNode.validateChildCategories()) {
            this.traceNodeCondition(false, "The child categories of the target TNodeMDFOnSingleHierarchy node are invalid.", trace);
            return false;
        }
        return true;
    }
}

