/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.application;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXBooleanExpression;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXAnd;
import com.cognos.xqe.ast.olap.MDXComparisonOperator;
import com.cognos.xqe.ast.olap.MDXCount;
import com.cognos.xqe.ast.olap.MDXCrossjoin;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeApplyMDFOnSingleHierarchyToSet;
import com.cognos.xqe.ast.olap.TNodeApplyVDFToSet;
import com.cognos.xqe.ast.olap.TNodeMDFOnSingleHierarchy;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class ApplyValueDetailFiltersToSet
extends Transformation {
    public ApplyValueDetailFiltersToSet() {
        this.mName = "Apply Value Detail Filter To Set.";
        this.mPassNumbers = new int[]{18};
        this.mTypes = new int[]{1020};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        AbstractMDXBooleanExpression condition = this.combineVDFConditions(factory, mdxQuery, (TNodeApplyVDFToSet)node);
        AbstractMDXSet virtualCubeSet = this.constructVirtualCubeSet(factory, mdxQuery, (TNodeApplyVDFToSet)node, condition);
        IXQEQueryNode mdxFilter = factory.createNode(1053);
        node.getChild(0).insertParent(mdxFilter);
        if (virtualCubeSet == null) {
            mdxFilter.addChild(condition);
        } else {
            MDXCount mdxCount = (MDXCount)factory.createNode(1087);
            MDXComparisonOperator gtExpr = MDXBuilder.buildMDXComparisonExpr(factory, 3, mdxCount, MDXBuilder.buildMDXNumericConstant((IXQENodeFactory)factory, 0));
            mdxFilter.addChild(gtExpr);
            mdxFilter = MDXBuilder.buildMDXFilterExpr(factory, virtualCubeSet, condition);
            mdxCount.addChild(mdxFilter);
        }
    }

    private AbstractMDXBooleanExpression combineVDFConditions(IXQENodeFactory factory, MDXQuery mdxQuery, TNodeApplyVDFToSet tNode) {
        AbstractMDXBooleanExpression result = null;
        List<Integer> dFIds = tNode.getDetailFilterIds();
        for (Integer dfId : dFIds) {
            IXQEQueryNode tNodeMeasureDetailFilter = (IXQEQueryNode)factory.getNodeIndex().getNodeByID(dfId);
            IXQEQueryNode condition = tNodeMeasureDetailFilter.getChild(0);
            if (!condition.isOfCategory(1071)) {
                condition.throwInternalError("Invalid TNodeValueDetailFilter condition.");
            }
            if (result == null) {
                result = (AbstractMDXBooleanExpression)factory.deepCopyNode(condition);
                continue;
            }
            MDXAnd andExpr = (MDXAnd)factory.createNode(1110);
            andExpr.addChild(result);
            andExpr.addChild(factory.deepCopyNode(condition));
            result = andExpr;
        }
        dFIds.clear();
        return result;
    }

    private AbstractMDXSet constructVirtualCubeSet(IXQENodeFactory factory, MDXQuery mdxQuery, TNodeApplyVDFToSet tNode, AbstractMDXBooleanExpression condition) {
        AbstractMDXSet result = null;
        MDXLevelInfo queryProjLevelInfo = mdxQuery.getLevelInfo();
        List<IHierarchy> queryProjHiers = queryProjLevelInfo.getHierarchyInfo().getProjectedHierarchies();
        AbstractMDXSet targetSet = (AbstractMDXSet)tNode.getChild(0);
        MDXLevelInfo setLevelInfo = targetSet.getLevelInfo();
        HashMap<IHierarchy, AbstractMDXSet> hierSetMap = new HashMap<IHierarchy, AbstractMDXSet>();
        for (IHierarchy hierarchy : queryProjHiers) {
            if (hierarchy.getDimension().isMeasuresDimension() || !condition.isContextDependent(hierarchy)) continue;
            ILevel lowestRefLevel = queryProjLevelInfo.getLowestProjectedLevel(hierarchy);
            if (setLevelInfo.getHierarchyInfo().projectsHierarchy(hierarchy)) {
                if (tNode.getParent().getChildrenOfType(1113).length != 0) {
                    AbstractMDXSet unbalancedCompTopNode = (AbstractMDXSet)tNode.getChild(0);
                    MDXLevelInfo unbalancedCompTopLevelInfo = unbalancedCompTopNode.getLevelInfo();
                    IHierarchy unbalancedCopTopHierarchy = unbalancedCompTopNode.getHierarchyInfo().getProjectedHierarchy(0);
                    if (unbalancedCopTopHierarchy.equals(hierarchy)) {
                        lowestRefLevel = unbalancedCompTopLevelInfo.getLowestProjectedLevel(hierarchy);
                    }
                }
                if (setLevelInfo.getHighestProjectedLevel(hierarchy).getIndex() >= lowestRefLevel.getIndex()) continue;
                AbstractMDXSet mdxDescendants = MDXBuilder.createLeafDescendantsOfCurrentMemberToLevel(factory, mdxQuery, lowestRefLevel);
                mdxDescendants = ApplyValueDetailFiltersToSet.applyApplicableMDFs(factory, mdxQuery, mdxDescendants);
                hierSetMap.put(hierarchy, mdxDescendants);
                continue;
            }
            List<ILevel> currMemLevels = hierarchy.getLevels().subList(0, lowestRefLevel.getIndex() + 1);
            MDXLevelInfo levelInfo = new MDXLevelInfo();
            levelInfo.addProjectedLevels(currMemLevels);
            AbstractMDXSet memberSet = MDXBuilder.generateLeafMembersToLowestProjectedLevel(factory, mdxQuery, hierarchy, levelInfo);
            memberSet = ApplyValueDetailFiltersToSet.applyApplicableMDFs(factory, mdxQuery, memberSet);
            hierSetMap.put(hierarchy, memberSet);
        }
        Set hierSet = hierSetMap.keySet();
        Iterator<IHierarchy> it = hierSet.iterator();
        while (it.hasNext()) {
            AbstractMDXSet set = (AbstractMDXSet)hierSetMap.get(it.next());
            if (result == null) {
                result = set;
                continue;
            }
            MDXCrossjoin mdxCrossjoin = (MDXCrossjoin)factory.createNode(1030);
            mdxCrossjoin.addChild(result);
            mdxCrossjoin.addChild(set);
            result = mdxCrossjoin;
        }
        return result;
    }

    protected static AbstractMDXSet applyApplicableMDFs(IXQENodeFactory factory, MDXQuery mdxQuery, AbstractMDXSet targetSet) {
        IHierarchy hierarchy = targetSet.getHierarchyInfo().getProjectedHierarchy(0);
        IXQEQueryNode[] tNodes = mdxQuery.getDescendantsOfType(1093, false);
        ArrayList<TNodeMDFOnSingleHierarchy> applicableMDFs = new ArrayList<TNodeMDFOnSingleHierarchy>();
        for (int i = 0; i < tNodes.length; ++i) {
            MDXHierInfo mdfHierInfo = ((AbstractMDXSet)tNodes[i].getChild(0).getChild(0)).getHierarchyInfo();
            if (!mdfHierInfo.projectsHierarchy(hierarchy)) continue;
            applicableMDFs.add((TNodeMDFOnSingleHierarchy)tNodes[i]);
        }
        if (applicableMDFs.size() == 0) {
            return targetSet;
        }
        TNodeApplyMDFOnSingleHierarchyToSet result = (TNodeApplyMDFOnSingleHierarchyToSet)factory.createNode(1018);
        if (targetSet.getParent() != null) {
            targetSet.insertParent(result);
        } else {
            result.addChild(targetSet);
        }
        Iterator it = applicableMDFs.iterator();
        while (it.hasNext()) {
            result.addDetailFilterId(((TNodeMDFOnSingleHierarchy)it.next()).getId());
        }
        return result;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        XQETrace trace = environment.getTrace();
        List<Integer> detailFilterIds = ((TNodeApplyVDFToSet)node).getDetailFilterIds();
        if (detailFilterIds.size() == 0) {
            this.traceNodeCondition(false, "The TNodeApplyVDFToSet node has no remaining detail filter ids.", trace);
            return false;
        }
        IXQEQueryNode targetSet = node.getChild(0);
        if (!targetSet.isOfCategory(1021)) {
            this.traceNodeCondition(false, "The target node is not an AbstractMDXSet instance.", trace);
            return false;
        }
        IXQEQueryNode mdxQuery = node.getAncestorOfType(1002);
        IXQEQueryNode[] tNodeVDFs = mdxQuery.getDescendantsOfType(1095, false);
        for (int i = 0; i < tNodeVDFs.length; ++i) {
            if (tNodeVDFs[i].getPropertyValue("DistributeVDFToPreMDXFilteringSets") == Boolean.TRUE) continue;
            this.traceNodeCondition(false, "There are TNodeValueDetailFilter nodes that have not yet been distributed to all parts of the query.", trace);
            return false;
        }
        for (Integer dfId : detailFilterIds) {
            IXQEQueryNode tNodeValueDetailFilter = (IXQEQueryNode)factory.getNodeIndex().getNodeByID(dfId);
            if (tNodeValueDetailFilter != null && tNodeValueDetailFilter.isAncestor(mdxQuery)) continue;
            tNodeValueDetailFilter.throwInternalError("Invalid TNodeValueDetailFilter node id.");
        }
        this.traceNodeCondition(true, "The TNodeApplyVDFToSet node has the ids for the detail filters that need to be applied to the target set, and all TNodeValueDetailFilter nodes have been distributed to the sets in the query.", trace);
        return true;
    }
}

