/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.application;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXBooleanExpression;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXNumericValueExpression;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.AbstractMDXSetOperator;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.CogMDXCompleteTuple;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.CogMDXIn;
import com.cognos.xqe.ast.olap.MDXAnd;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXComparisonOperator;
import com.cognos.xqe.ast.olap.MDXCount;
import com.cognos.xqe.ast.olap.MDXCrossjoin;
import com.cognos.xqe.ast.olap.MDXCurrentMember;
import com.cognos.xqe.ast.olap.MDXDefaultMember;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXFilter;
import com.cognos.xqe.ast.olap.MDXNumericConstant;
import com.cognos.xqe.ast.olap.MDXNumericIIF;
import com.cognos.xqe.ast.olap.MDXOr;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.MDXSetAliasReference;
import com.cognos.xqe.ast.olap.MDXSummaryFunction;
import com.cognos.xqe.ast.olap.MDXSummaryFunctionTypeEnum;
import com.cognos.xqe.ast.olap.MDXTuple;
import com.cognos.xqe.ast.olap.MDXTupleItem;
import com.cognos.xqe.ast.olap.TNodeAbstractDetailFilter;
import com.cognos.xqe.ast.olap.TNodeAbstractMDXNode;
import com.cognos.xqe.ast.olap.TNodeApplyMDFOnSingleHierarchyToSet;
import com.cognos.xqe.ast.olap.TNodeApplyORdMDFsOnDiffHiersToSet;
import com.cognos.xqe.ast.olap.TNodeApplyVDFToSet;
import com.cognos.xqe.ast.olap.TNodeValueDetailFilter;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeManager;
import com.cognos.xqe.transformation.olap.edgemapping.BuildXOLAPEdgeMappingUtilities;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.transformation.olap.util.SolveOrderUtil;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class DFSLAggrUtil {
    public static final String PROP_AGGREGATION_REQUIRED = "AggregationRequired";
    public static final String PROP_AGGREGATION_APPLIED = "AggregationApplied";
    public static final String PROPERTY_AGGR_PROJECTED_SET = "AggregationProjectedSet";
    public static final String PROPERTY_HIGHEST_AGGREGATION_LEVEL = "HighestAggregationLevel";
    public static final String PROPERTY_DFSL_AGGR_SET = "DFSLAggrSet";
    public static final String PROPERTY_DFSL_AGGR_IIF = "DFSLAggrIIF";
    public static final String PROPERTY_REAGGREGATION_HOST = "reaggregationHost";
    public static final String REAGGREGATION_HOST_MEASURE = "reaggregationHostMeasure";
    public static final String REAGGREGATION_HOST_DIMENSION_LINE = "reaggregationHostDimensionLine";
    public static final int SINGLE_MDF_REAGGREGATION_SET_CHILD_INDEX = 1;

    private DFSLAggrUtil() {
    }

    protected static MDXTuple getCreateDimLineTuple(IXQENodeFactory factory, MDXQuery mdxQuery) {
        IXQEQueryNode dimLine = mdxQuery.getDimensionLine();
        if (dimLine == null) {
            dimLine = factory.createNode(1008);
            dimLine.addChild(factory.createNode(1069));
            mdxQuery.addChild(dimLine);
        }
        return (MDXTuple)dimLine.getChild(0);
    }

    public static List<TNodeAbstractMDXNode> getUnprocessedMDFsOnHierarchy(MDXQuery mdxQuery, IHierarchy hierarchy) {
        ArrayList<TNodeAbstractMDXNode> mDFs = new ArrayList<TNodeAbstractMDXNode>();
        int[] types = new int[]{1093, 1193, 1094};
        IXQEQueryNode[] tNodes = mdxQuery.getDescendantsOfTypes(types, false);
        for (int j = 0; j < tNodes.length; ++j) {
            if (tNodes[j].getPropertyValue(PROP_AGGREGATION_REQUIRED) == Boolean.FALSE || tNodes[j].getPropertyValue(PROP_AGGREGATION_APPLIED) == Boolean.TRUE) continue;
            ((AbstractMDXNode)tNodes[j]).throwOnInvalidChildCategories();
            MDXHierInfo hierInfo = ((AbstractMDXSet)tNodes[j].getChild(0).getChild(0)).getHierarchyInfo();
            if (!hierInfo.projectsHierarchy(hierarchy)) continue;
            mDFs.add((TNodeAbstractMDXNode)tNodes[j]);
        }
        return mDFs;
    }

    public static List<TNodeAbstractMDXNode> getUnprocessedVDFs(MDXQuery mdxQuery) {
        ArrayList<TNodeAbstractMDXNode> vDFs = new ArrayList<TNodeAbstractMDXNode>();
        IXQEQueryNode[] tNodes = mdxQuery.getDescendantsOfType(1095, false);
        for (int j = 0; j < tNodes.length; ++j) {
            if (tNodes[j].getPropertyValue(PROP_AGGREGATION_REQUIRED) == Boolean.FALSE || tNodes[j].getPropertyValue(PROP_AGGREGATION_APPLIED) == Boolean.TRUE) continue;
            vDFs.add((TNodeValueDetailFilter)tNodes[j]);
        }
        return vDFs;
    }

    public static AbstractMDXSet generateSingleMDFAggregationSet(IXQENodeFactory factory, MDXQuery mdxQuery, IHierarchy hierarchy, List<TNodeAbstractMDXNode> tNodeMemberDetailFilterNodes) {
        AbstractMDXSet result = null;
        AbstractMDXSet dfSet = null;
        ILevel lowestReferencedLevel = mdxQuery.getLowestReferencedLevel(hierarchy);
        if (tNodeMemberDetailFilterNodes.size() > 1) {
            IXQEQueryNode parent = result = (AbstractMDXSet)factory.createNode(1038);
            Iterator<TNodeAbstractMDXNode> it = tNodeMemberDetailFilterNodes.iterator();
            while (it.hasNext()) {
                TNodeAbstractMDXNode memberDetailFilterNode = it.next();
                dfSet = (AbstractMDXSet)memberDetailFilterNode.getChild(0).getChild(1);
                dfSet = MDXBuilder.generateLeafMembersToLevel(factory, mdxQuery, dfSet, lowestReferencedLevel);
                if (parent.getNumberChildren() == 1 && it.hasNext()) {
                    parent.addChild(factory.createNode(1038));
                    parent = parent.getChild(1);
                }
                parent.addChild(dfSet);
            }
        } else if (tNodeMemberDetailFilterNodes.size() == 1) {
            AbstractMDXNode memberDetailFilterNode = tNodeMemberDetailFilterNodes.get(0);
            dfSet = (AbstractMDXSet)memberDetailFilterNode.getChild(0).getChild(1);
            result = memberDetailFilterNode.getPropertyValue(PROPERTY_AGGR_PROJECTED_SET) == Boolean.TRUE && dfSet.projectsAtMostOneTuple() && !mdxQuery.isPowerCubeProvider() ? MDXBuilder.generateSetAboveLevel(factory, mdxQuery, dfSet, lowestReferencedLevel) : MDXBuilder.generateLeafMembersToLevel(factory, mdxQuery, dfSet, lowestReferencedLevel);
        }
        return result;
    }

    public static AbstractMDXBooleanExpression generateSingleVDFCondition(IXQENodeFactory factory, List<TNodeAbstractMDXNode> tNodeValueDetailFilterNodes) {
        AbstractMDXBooleanExpression result = null;
        for (TNodeValueDetailFilter tNodeValueDetailFilter : tNodeValueDetailFilterNodes) {
            AbstractMDXBooleanExpression cond = (AbstractMDXBooleanExpression)tNodeValueDetailFilter.getChild(0);
            if (result == null) {
                result = (AbstractMDXBooleanExpression)factory.deepCopyNode(cond);
                continue;
            }
            MDXAnd andExpr = (MDXAnd)factory.createNode(1110);
            andExpr.addChild(result);
            andExpr.addChild(factory.deepCopyNode(cond));
            result = andExpr;
        }
        return result;
    }

    public static void flagNodesWithAggregationApplied(List<TNodeAbstractMDXNode> nodes) {
        Iterator<TNodeAbstractMDXNode> it = nodes.iterator();
        while (it.hasNext()) {
            it.next().setPropertyValue(PROP_AGGREGATION_APPLIED, Boolean.TRUE);
        }
    }

    public static boolean isAggrRequiredForMDF(MDXQuery mdxQuery, MDXLevelInfo mdfLevelInfo, boolean referencedHierarchy) {
        MDXHierInfo mdxQueryHierInfo = mdxQuery.getHierarchyInfo();
        if (DFSLAggrUtil.projectedDetailsRequireAggregationForMDF(mdxQuery, mdxQueryHierInfo, mdfLevelInfo)) {
            return true;
        }
        if (DFSLAggrUtil.queryContainsValueExpressionsThatRequireAggregation(mdxQuery, mdfLevelInfo, false)) {
            return true;
        }
        return !referencedHierarchy && mdxQuery.getDescendantsOfType(1095, false).length > 0;
    }

    public static boolean isAggrRequiredForMDFOnlyProjDetails(MDXQuery mdxQuery, MDXLevelInfo mdfLevelInfo, boolean referencedHierarchy) {
        IHierarchy hierarchy;
        MDXHierInfo mdxQueryHierInfo = mdxQuery.getHierarchyInfo();
        if (!mdxQueryHierInfo.projectsHierarchy(hierarchy = mdfLevelInfo.getHierarchyInfo().getProjectedHierarchy(0))) {
            return false;
        }
        if (DFSLAggrUtil.queryContainsValueExpressionsThatTriggeredReaggregation(mdxQuery, mdfLevelInfo, false)) {
            return false;
        }
        return referencedHierarchy || mdxQuery.getDescendantsOfType(1095, false).length <= 0;
    }

    public static boolean isAggrRequiredForVDF(MDXQuery mdxQuery, MDXLevelInfo mdfLevelInfo) {
        MDXHierInfo mdxQueryHierInfo = mdxQuery.getHierarchyInfo();
        if (DFSLAggrUtil.projectedDetailsRequireAggregationForVDF(mdxQuery, mdxQueryHierInfo, mdfLevelInfo)) {
            DFSLAggrUtil.validateReAggregationSupport(mdxQuery);
            return true;
        }
        if (DFSLAggrUtil.queryContainsValueExpressionsThatRequireAggregation(mdxQuery, mdfLevelInfo, true)) {
            DFSLAggrUtil.validateReAggregationSupport(mdxQuery);
            return true;
        }
        return false;
    }

    public static boolean isAggrRequiredForORdMDFsOnDiffHiers(MDXQuery mdxQuery, MDXLevelInfo[] filteredSetsLevelInfo) {
        boolean isSAPSemantic;
        MDXHierInfo mdxQueryHierInfo = mdxQuery.getHierarchyInfo();
        boolean bl = isSAPSemantic = mdxQuery.getDataSourceType().equals("BW") && mdxQuery.isSuppressNulls();
        if ((mdxQueryHierInfo.projectsMeasures() || isSAPSemantic) && mdxQueryHierInfo.getNumberOfNonMeasureHierarchiesProjected() > 1) {
            DFSLAggrUtil.validateReAggregationSupport(mdxQuery);
            return true;
        }
        for (int i = 0; i < filteredSetsLevelInfo.length; ++i) {
            if (DFSLAggrUtil.projectedDetailsRequireAggregationForMDF(mdxQuery, mdxQueryHierInfo, filteredSetsLevelInfo[i])) {
                DFSLAggrUtil.validateReAggregationSupport(mdxQuery);
                return true;
            }
            if (!DFSLAggrUtil.queryContainsValueExpressionsThatRequireAggregation(mdxQuery, filteredSetsLevelInfo[i], true)) continue;
            DFSLAggrUtil.validateReAggregationSupport(mdxQuery);
            return true;
        }
        return false;
    }

    public static boolean projectedDetailsRequireAggregationForMDF(MDXQuery mdxQuery, MDXHierInfo mdxQueryHierInfo, MDXLevelInfo mdfLevelInfo) {
        if (!mdxQueryHierInfo.projectsMeasures()) {
            return false;
        }
        IHierarchy hierarchy = mdfLevelInfo.getHierarchyInfo().getProjectedHierarchy(0);
        if (!mdxQueryHierInfo.projectsHierarchy(hierarchy)) {
            return true;
        }
        if (mdfLevelInfo.getNumProjectedLevels(hierarchy) == 0) {
            return false;
        }
        AbstractMDXSet[] detailSets = DFSLAggrUtil.getGroupNestDetailSets(mdxQuery, hierarchy);
        if (detailSets == null) {
            throw new XQERuntimeException();
        }
        int mdfSetLowestLevelIndex = mdfLevelInfo.getLowestProjectedLevel(hierarchy).getIndex();
        for (int i = 0; i < detailSets.length; ++i) {
            ILevel hierHighestProjLevel = detailSets[i].getLevelInfo().getHighestProjectedLevel(hierarchy);
            if (hierHighestProjLevel == null || mdfSetLowestLevelIndex <= hierHighestProjLevel.getIndex()) continue;
            return true;
        }
        return false;
    }

    public static boolean projectedDetailsRequireAggregationForVDF(MDXQuery mdxQuery, MDXHierInfo mdxQueryHierInfo, MDXLevelInfo mdfLevelInfo) {
        if (!mdxQueryHierInfo.projectsMeasures()) {
            return false;
        }
        if (mdxQueryHierInfo.getNumberOfNonMeasureHierarchiesProjected() > 1) {
            return true;
        }
        IHierarchy hierarchy = mdfLevelInfo.getHierarchyInfo().getProjectedHierarchy(0);
        if (!mdxQueryHierInfo.projectsHierarchy(hierarchy)) {
            return true;
        }
        AbstractMDXSet[] detailSets = DFSLAggrUtil.getGroupNestDetailSets(mdxQuery, hierarchy);
        if (detailSets == null) {
            throw new XQERuntimeException();
        }
        mdfLevelInfo.removeCalculationLevels(hierarchy);
        if (mdfLevelInfo.getNumProjectedLevels(hierarchy) == 0) {
            return false;
        }
        int mdfSetLowestLevelIndex = mdfLevelInfo.getLowestProjectedLevel(hierarchy).getIndex();
        for (int i = 0; i < detailSets.length; ++i) {
            MDXLevelInfo detailSetLevelInfo = detailSets[i].getLevelInfo();
            detailSetLevelInfo.removeCalculationLevels(hierarchy);
            if (detailSetLevelInfo.getNumProjectedLevels(hierarchy) == 0 || mdfSetLowestLevelIndex <= detailSetLevelInfo.getHighestProjectedLevel(hierarchy).getIndex()) continue;
            return true;
        }
        return false;
    }

    public static AbstractMDXSet[] getGroupNestDetailSets(MDXQuery mdxQuery, IHierarchy hierarchy) {
        MDXEdge edge = null;
        MDXEdge[] edges = mdxQuery.getEdges();
        for (int i = 0; i < edges.length; ++i) {
            MDXHierInfo edgeHierInfo = edges[i].getHierarchyInfo();
            if (!edgeHierInfo.projectsHierarchy(hierarchy)) continue;
            edge = edges[i];
            break;
        }
        return DFSLAggrUtil.getGroupNestDetailSets(edge, hierarchy);
    }

    public static AbstractMDXSet[] getGroupNestDetailSets(MDXEdge edge, IHierarchy hierarchy) {
        ArrayList<AbstractMDXSet> innermostProjectedSetsInHierarchy = new ArrayList<AbstractMDXSet>();
        if (edge != null) {
            int[] types = new int[]{1027, 1026};
            IXQEQueryNode[] cogMDXGroupNestNodes = edge.getDescendantsOfTypes(types, false);
            for (int j = 0; j < cogMDXGroupNestNodes.length; ++j) {
                MDXSet set;
                CogMDXGroup childGroup;
                AbstractMDXSet childSet;
                AbstractMDXSet aSet;
                CogMDXGroup cogMDXGroup;
                AbstractMDXSet group = (AbstractMDXSet)cogMDXGroupNestNodes[j];
                if (group.getType() == 1027 && ((CogMDXGroup)group).getRefDataItemProperty() == null && "false".equals(((CogMDXGroup)group).getDetailProperty()) || group.getType() == 1027 && (BuildXOLAPEdgeMappingUtilities.isCurrentMemberHierNormalizationGroup(cogMDXGroup = (CogMDXGroup)group) || BuildXOLAPEdgeMappingUtilities.isDefaultMemberHierNormalizationGroup(cogMDXGroup) && cogMDXGroup.getRSAPIDataItemList() != null) || !(aSet = (AbstractMDXSet)group.getChild(0)).getHierarchyInfo().projectsHierarchy(hierarchy) || group.getNumberChildren() > 1 && ((AbstractMDXSet)group.getChild(1)).getHierarchyInfo().projectsHierarchy(hierarchy) && ((childSet = (AbstractMDXSet)group.getChild(1)).getType() != 1027 || (childGroup = (CogMDXGroup)childSet).getRefDataItemProperty() != null || !"false".equals(childGroup.getDetailProperty()) || !BuildXOLAPEdgeMappingUtilities.isCurrentMemberHierNormalizationGroup(childGroup) && !BuildXOLAPEdgeMappingUtilities.isDefaultMemberHierNormalizationGroup(childGroup) || childGroup.getRSAPIDataItemList() == null) || (aSet.isOfCategory(1039) && aSet.getAncestorsOfCategory(1080).length != 0 ? (set = (MDXSet)aSet).getNumberChildren() == 1 && set.getChild(0).isOfCategory(1077) && ((MDXDefaultMember)set.getChild(0)).getPropertyIsNoMember() : aSet.isOfCategory(1039) && (set = (MDXSet)aSet).getNumberChildren() == 1 && set.getChild(0).isOfCategory(1013) && "false".equals(((CogMDXGroup)group).getDetailProperty()))) continue;
                innermostProjectedSetsInHierarchy.add(aSet);
            }
        }
        return innermostProjectedSetsInHierarchy.toArray(new AbstractMDXSet[innermostProjectedSetsInHierarchy.size()]);
    }

    public static AbstractMDXSet[] getGroupNestDetailSetsFromV5Edges(MDXQuery mdxQuery, IHierarchy hierarchy) {
        ArrayList<AbstractMDXSet> innermostProjectedSetsInHierarchy = new ArrayList<AbstractMDXSet>();
        V5Edge[] edges = mdxQuery.getV5Edges();
        for (int i = 0; i < edges.length; ++i) {
            V5Edge edge = edges[i];
            if (edge == null) continue;
            int[] types = new int[]{1027, 1026};
            IXQEQueryNode[] cogMDXGroupNestNodes = edge.getDescendantsOfTypes(types, false);
            for (int j = 0; j < cogMDXGroupNestNodes.length; ++j) {
                MDXHierInfo set1HierInfo = ((AbstractMDXSet)cogMDXGroupNestNodes[j].getChild(0)).getHierarchyInfo();
                if (!set1HierInfo.projectsHierarchy(hierarchy) || cogMDXGroupNestNodes[j].getNumberChildren() > 1 && ((AbstractMDXSet)cogMDXGroupNestNodes[j].getChild(1)).getHierarchyInfo().projectsHierarchy(hierarchy)) continue;
                innermostProjectedSetsInHierarchy.add((AbstractMDXSet)cogMDXGroupNestNodes[j].getChild(0));
            }
        }
        return innermostProjectedSetsInHierarchy.toArray(new AbstractMDXSet[innermostProjectedSetsInHierarchy.size()]);
    }

    public static boolean queryContainsValueExpressionsThatRequireAggregation(MDXQuery mdxQuery, MDXLevelInfo mdfLevelInfo, boolean measureFilter) {
        int i;
        IHierarchy hierarchy = mdfLevelInfo.getHierarchyInfo().getProjectedHierarchy(0);
        if (mdfLevelInfo.getNumProjectedLevels(hierarchy) == 0) {
            return true;
        }
        int dfLowestProjLevelInx = mdfLevelInfo.getLowestProjectedLevel(hierarchy).getIndex();
        MDXEdge[] edges = mdxQuery.getEdges();
        for (int i2 = 0; i2 < edges.length; ++i2) {
            MDXEdge edge = edges[i2];
            Set<MDXLevelInfo> veLevelInfoSet = edge.getContextDependentValueExpressionLevelInfo(edge);
            for (MDXLevelInfo mDXLevelInfo : veLevelInfoSet) {
                int veHighestProjLevelInx;
                mDXLevelInfo.removeCalculationLevels(hierarchy);
                if (!mDXLevelInfo.getHierarchyInfo().projectsHierarchy(hierarchy)) {
                    return true;
                }
                if (mDXLevelInfo.getNumProjectedLevels(hierarchy) == 0 || (veHighestProjLevelInx = mDXLevelInfo.getHighestProjectedLevel(hierarchy).getIndex()) >= dfLowestProjLevelInx) continue;
                return true;
            }
        }
        MDXCalculatedMemberDefinition[] calcDefs = mdxQuery.getCalcMemberDefinitions();
        for (i = 0; i < calcDefs.length; ++i) {
            MDXCalculatedMemberDefinition calcDef = calcDefs[i];
            if (calcDef.getSolveOrder() == SolveOrderUtil.getSlicerCalcSolveOrder() || calcDef.getSolveOrder() == SolveOrderUtil.getCubeCalcSolveOrder()) continue;
            Set<MDXLevelInfo> veLevelInfoSet = calcDef.getContextDependentValueExpressionLevelInfo(mdxQuery);
            for (MDXLevelInfo veLevelInfo : veLevelInfoSet) {
                int veHighestProjLevelInx;
                if (!veLevelInfo.getHierarchyInfo().projectsHierarchy(hierarchy)) {
                    return true;
                }
                veLevelInfo.removeCalculationLevels(hierarchy);
                if (veLevelInfo.getNumProjectedLevels(hierarchy) == 0 || (veHighestProjLevelInx = veLevelInfo.getHighestProjectedLevel(hierarchy).getIndex()) >= dfLowestProjLevelInx) continue;
                return true;
            }
        }
        for (i = 0; i < edges.length; ++i) {
            List<AbstractMDXNode> memberExprs = edges[i].getDescendantsOfCategory(1022, true, true, true, true, false);
            for (AbstractMDXMember abstractMDXMember : memberExprs) {
                int memberHighestProjLevelInx;
                MDXLevelInfo memberLevelInfo;
                if (abstractMDXMember.getType() == 1013 || abstractMDXMember.getType() == 1076 || abstractMDXMember.getParent().getType() != 1069 || !((MDXTuple)abstractMDXMember.getParent()).isValueExpressionOperand() || !(memberLevelInfo = abstractMDXMember.getLevelInfo()).getHierarchyInfo().projectsHierarchy(hierarchy) || (memberHighestProjLevelInx = memberLevelInfo.getHighestProjectedLevel(hierarchy).getIndex()) > dfLowestProjLevelInx) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean queryContainsValueExpressionsThatTriggeredReaggregation(MDXQuery mdxQuery, MDXLevelInfo mdfLevelInfo, boolean measureFilter) {
        int i;
        IHierarchy hierarchy = mdfLevelInfo.getHierarchyInfo().getProjectedHierarchy(0);
        if (mdfLevelInfo.getNumProjectedLevels(hierarchy) == 0) {
            return true;
        }
        int dfLowestProjLevelInx = mdfLevelInfo.getLowestProjectedLevel(hierarchy).getIndex();
        MDXEdge[] edges = mdxQuery.getEdges();
        for (int i2 = 0; i2 < edges.length; ++i2) {
            MDXEdge edge = edges[i2];
            Set<MDXLevelInfo> veLevelInfoSet = edge.getContextDependentValueExpressionLevelInfo(edge);
            for (MDXLevelInfo mDXLevelInfo : veLevelInfoSet) {
                int veHighestProjLevelInx;
                mDXLevelInfo.removeCalculationLevels(hierarchy);
                if (!mDXLevelInfo.getHierarchyInfo().projectsHierarchy(hierarchy)) {
                    return true;
                }
                if (mDXLevelInfo.getNumProjectedLevels(hierarchy) == 0 || (veHighestProjLevelInx = mDXLevelInfo.getHighestProjectedLevel(hierarchy).getIndex()) >= dfLowestProjLevelInx) continue;
                return true;
            }
        }
        MDXCalculatedMemberDefinition[] calcDefs = mdxQuery.getCalcMemberDefinitions();
        for (i = 0; i < calcDefs.length; ++i) {
            MDXCalculatedMemberDefinition calcDef = calcDefs[i];
            if (calcDef.getSolveOrder() == SolveOrderUtil.getSlicerCalcSolveOrder() || calcDef.getSolveOrder() == SolveOrderUtil.getCubeCalcSolveOrder() || calcDef.getHighestReferencedLevel(hierarchy) == null) continue;
            return true;
        }
        for (i = 0; i < edges.length; ++i) {
            List<AbstractMDXNode> memberExprs = edges[i].getDescendantsOfCategory(1022, true, true, true, true, false);
            for (AbstractMDXMember abstractMDXMember : memberExprs) {
                MDXLevelInfo memberLevelInfo;
                if (abstractMDXMember.getType() == 1013 || abstractMDXMember.getType() == 1076 || abstractMDXMember.getParent().getType() != 1069 || !((MDXTuple)abstractMDXMember.getParent()).isValueExpressionOperand() || !(memberLevelInfo = abstractMDXMember.getLevelInfo()).getHierarchyInfo().projectsHierarchy(hierarchy)) continue;
                return true;
            }
        }
        return false;
    }

    public static AbstractMDXSet constructVDFAggregationSet(IXQENodeFactory factory, MDXQuery mdxQuery, MDXLevelInfo levelInfo) {
        List<IHierarchy> hierarchies = levelInfo.getHierarchyInfo().getProjectedHierarchies();
        Iterator<IHierarchy> it = hierarchies.iterator();
        AbstractMDXSet result = null;
        while (it.hasNext()) {
            IHierarchy hierarchy = it.next();
            if (hierarchy.getDimension().isMeasuresDimension()) continue;
            levelInfo.removeCalculationLevels(hierarchy);
            ILevel hierLowestProjLevel = levelInfo.getLowestProjectedLevel(hierarchy);
            if (hierLowestProjLevel == null) continue;
            MDXLevelInfo hierLevelInfo = new MDXLevelInfo();
            hierLevelInfo.addProjectedHierarchy(hierLowestProjLevel);
            boolean hierSetRequired = false;
            AbstractMDXSet[] detailSets = DFSLAggrUtil.getGroupNestDetailSets(mdxQuery, hierarchy);
            if (detailSets != null) {
                for (int i = 0; i < detailSets.length; ++i) {
                    MDXLevelInfo detailSetLevelInfo = detailSets[i].getLevelInfo();
                    detailSetLevelInfo.removeCalculationLevels(hierarchy);
                    if (detailSetLevelInfo.getNumProjectedLevels(hierarchy) == 0) continue;
                    int detailSetHighestProjectedLevelIndex = detailSetLevelInfo.getHighestProjectedLevel(hierarchy).getIndex();
                    if (hierLowestProjLevel.getIndex() <= detailSetHighestProjectedLevelIndex) continue;
                    hierSetRequired = true;
                    break;
                }
            }
            if (!hierSetRequired && DFSLAggrUtil.queryContainsValueExpressionsThatRequireAggregation(mdxQuery, hierLevelInfo, false)) {
                hierSetRequired = true;
            }
            if (!hierSetRequired) continue;
            DFSLAggrUtil.checkHierarchyRollup(hierarchy);
            AbstractMDXSet hierSet = MDXBuilder.createLeafDescendantsOfCurrentMemberToLevel(factory, mdxQuery, hierLowestProjLevel);
            if (result == null) {
                result = hierSet;
                continue;
            }
            MDXCrossjoin mdxCrossjoin = (MDXCrossjoin)factory.createNode(1030);
            mdxCrossjoin.addChild(result);
            mdxCrossjoin.addChild(hierSet);
            result = mdxCrossjoin;
        }
        return result;
    }

    public static MDXSummaryFunction constructMDFAggregationCalc(IXQENodeFactory factory, MDXQuery mdxQuery, MDXOr dfORCondition) {
        MDXLevelInfo levelInfo = mdxQuery.getSlicerContextLevelInfo(null);
        levelInfo.removeCalculationLevels();
        List<IHierarchy> hierarchies = levelInfo.getHierarchyInfo().getProjectedHierarchies();
        if (hierarchies.size() == 0) {
            throw new XQERuntimeException();
        }
        ArrayList<AbstractMDXSet> aggregationSets = new ArrayList<AbstractMDXSet>();
        AbstractMDXBooleanExpression aggrCondExpr = DFSLAggrUtil.createAggrCondExpression(dfORCondition, levelInfo, hierarchies, aggregationSets, mdxQuery, factory);
        AbstractMDXSet aggregationSet = null;
        if (aggregationSets.size() == 0) {
            ArrayList<IHierarchy> firstHierarchy = new ArrayList<IHierarchy>();
            firstHierarchy.add(hierarchies.get(0));
            aggregationSet = MDXBuilder.buildMDXSetExpr(factory, MDXBuilder.buildCurrentMemberTuple(factory, mdxQuery, firstHierarchy));
        } else {
            aggregationSet = (AbstractMDXSet)aggregationSets.get(0);
        }
        MDXFilter mdxFilter = MDXBuilder.buildMDXFilterExpr(factory, aggregationSet, aggrCondExpr);
        MDXSummaryFunction aggrExpr = MDXBuilder.buildMDXSummaryFunctionExpr(factory, MDXSummaryFunctionTypeEnum.AGGREGATE, mdxFilter, null);
        return aggrExpr;
    }

    private static AbstractMDXBooleanExpression createAggrCondExpressionForCogMDXIn(CogMDXIn cogMDXIn, MDXLevelInfo levelInfo, List<IHierarchy> hierarchies, List<AbstractMDXSet> aggregationSets, MDXQuery mdxQuery, IXQENodeFactory factory) {
        boolean singleLevelFilter;
        AbstractMDXSet dfSet = (AbstractMDXSet)cogMDXIn.getChild(1);
        Set<IHierarchy> referencedHierarchies = dfSet.getReferencedHierarchies();
        if (referencedHierarchies.size() > 1) {
            throw new XQERuntimeException();
        }
        IHierarchy referencedHierarchy = referencedHierarchies.iterator().next();
        MDXLevelInfo dfLevelInfo = dfSet.getLevelInfo();
        ILevel lowestProjectedLevel = null;
        ILevel highestProjectedLevel = null;
        if (levelInfo.getHierarchyInfo().projectsHierarchy(referencedHierarchy)) {
            lowestProjectedLevel = levelInfo.getLowestProjectedLevel(referencedHierarchy);
            highestProjectedLevel = levelInfo.getHighestProjectedLevel(referencedHierarchy);
        } else {
            highestProjectedLevel = lowestProjectedLevel = referencedHierarchy.getLevel(0);
        }
        AbstractMDXSet adjustedDfSet = null;
        ILevel lowestFilterLevel = dfLevelInfo.getLowestProjectedLevel(referencedHierarchy);
        ILevel highestFilterLevel = dfLevelInfo.getHighestProjectedLevel(referencedHierarchy);
        boolean needToReAggregateReferencedHierarchy = lowestFilterLevel.getIndex() > highestProjectedLevel.getIndex();
        boolean bl = singleLevelFilter = lowestFilterLevel.getIndex() == highestFilterLevel.getIndex();
        if (needToReAggregateReferencedHierarchy) {
            AbstractMDXSet hierSet = null;
            ILevel reAggregationLevel = lowestFilterLevel;
            if (lowestFilterLevel.getIndex() < lowestProjectedLevel.getIndex()) {
                reAggregationLevel = lowestProjectedLevel;
            }
            hierSet = MDXBuilder.createLeafDescendantsOfCurrentMemberToLevel(factory, mdxQuery, reAggregationLevel);
            DFSLAggrUtil.addHierSetToAggregationSet(factory, hierSet, aggregationSets);
        }
        AbstractMDXSet dfSetCopy = (AbstractMDXSet)factory.deepCopyNode(dfSet);
        AbstractMDXSet countDfSet = null;
        if (singleLevelFilter) {
            countDfSet = highestFilterLevel.getIndex() < lowestProjectedLevel.getIndex() ? MDXBuilder.intersectSetWithAncestorsOfCurrentMember(factory, dfSetCopy) : MDXBuilder.buildMDXIntersectCurrentMemberExpr(factory, referencedHierarchy, dfSetCopy);
        } else {
            if (highestFilterLevel.getIndex() >= lowestProjectedLevel.getIndex()) {
                adjustedDfSet = dfSetCopy;
            } else {
                MDXLevelInfo lowestLevelInfo = new MDXLevelInfo();
                lowestLevelInfo.addProjectedHierarchy(lowestProjectedLevel);
                adjustedDfSet = MDXBuilder.correlateSetToLevels(factory, dfSetCopy, lowestLevelInfo);
            }
            countDfSet = MDXBuilder.intersectSetWithDescendantsOfCurrentMember(factory, adjustedDfSet);
        }
        MDXComparisonOperator compExpr = DFSLAggrUtil.buildCountCompareToZeroExpr(factory, cogMDXIn, countDfSet);
        return compExpr;
    }

    private static MDXComparisonOperator buildCountCompareToZeroExpr(IXQENodeFactory factory, CogMDXIn cogMDXIn, AbstractMDXSet countDfSet) {
        MDXCount mdxCount = MDXBuilder.buildMDXCountExpr(factory, countDfSet, true);
        MDXComparisonOperator compExpr = MDXBuilder.buildMDXComparisonExpr(factory, 3, mdxCount, MDXBuilder.buildMDXNumericConstant(factory, 0));
        return compExpr;
    }

    private static void addHierSetToAggregationSet(IXQENodeFactory factory, AbstractMDXSet hierSet, List<AbstractMDXSet> aggregationSets) {
        if (aggregationSets.size() == 0) {
            aggregationSets.add((AbstractMDXSet)factory.deepCopyNode(hierSet));
        } else {
            AbstractMDXSet aggregationSet = aggregationSets.get(0);
            if (hierSet.getHierarchyInfo().equals(aggregationSet.getHierarchyInfo())) {
                return;
            }
            MDXCrossjoin mdxCrossjoin = (MDXCrossjoin)factory.createNode(1030);
            mdxCrossjoin.addChild(aggregationSet);
            mdxCrossjoin.addChild(hierSet);
            aggregationSets.set(0, mdxCrossjoin);
        }
    }

    private static AbstractMDXBooleanExpression createAggrCondExpression(AbstractMDXBooleanExpression dfCondition, MDXLevelInfo levelInfo, List<IHierarchy> hierarchies, List<AbstractMDXSet> aggregationSets, MDXQuery mdxQuery, IXQENodeFactory factory) {
        if (dfCondition.getType() == 1029) {
            if (!dfCondition.validateChildCategories()) {
                throw new XQERuntimeException();
            }
            return DFSLAggrUtil.createAggrCondExpressionForCogMDXIn((CogMDXIn)dfCondition, levelInfo, hierarchies, aggregationSets, mdxQuery, factory);
        }
        AbstractMDXBooleanExpression[] operands = dfCondition.getAssociativeOperands(false);
        ArrayList<IXQEQueryNode> childrenExprList = new ArrayList<IXQEQueryNode>();
        for (int i = 0; i < operands.length; ++i) {
            AbstractMDXBooleanExpression childExpr = DFSLAggrUtil.createAggrCondExpression(operands[i], levelInfo, hierarchies, aggregationSets, mdxQuery, factory);
            childrenExprList.add(childExpr);
        }
        return DFSLAggrUtil.buildFilterExpression(dfCondition, childrenExprList, factory);
    }

    public static AbstractMDXBooleanExpression buildFilterExpression(AbstractMDXBooleanExpression dfCondition, List<IXQEQueryNode> childrenExprList, IXQENodeFactory factory) {
        Iterator<IXQEQueryNode> it = childrenExprList.iterator();
        AbstractMDXBooleanExpression filterCondition = null;
        while (it.hasNext()) {
            IXQEQueryNode condition = it.next();
            if (filterCondition == null) {
                filterCondition = (AbstractMDXBooleanExpression)condition;
                continue;
            }
            AbstractMDXBooleanExpression mdxExpr = (AbstractMDXBooleanExpression)factory.createNode(dfCondition.getType());
            mdxExpr.addChild(filterCondition);
            filterCondition = mdxExpr;
            filterCondition.addChild(condition);
        }
        return filterCondition;
    }

    protected static void addMemberToContextIndependentSets(IXQENodeFactory factory, MDXQuery mdxQuery, IXQEQueryNode node, AbstractMDXMember hierarchyMember) {
        List<IXQEQueryNode> allMDXSets = mdxQuery.getDescendantsOfCategory(1021, true);
        for (AbstractMDXSet abstractMDXSet : allMDXSets) {
            if (!abstractMDXSet.isFlaggedContextIndependent() || abstractMDXSet.isAncestor(node)) continue;
            abstractMDXSet.addMemberToContext(factory, hierarchyMember, false);
        }
    }

    protected static void addMemberToContextDependentCompleteTuples(IXQENodeFactory factory, MDXQuery mdxQuery, IXQEQueryNode node, AbstractMDXMember hierarchyMember) {
        IXQEQueryNode[] completeTuples;
        for (IXQEQueryNode completeTuple : completeTuples = mdxQuery.getDescendantsOfType(1099, true)) {
            CogMDXCompleteTuple tuple = (CogMDXCompleteTuple)completeTuple;
            tuple.addMemberToContext(factory, hierarchyMember, true);
        }
    }

    protected static boolean isAllDFEdgeFiltertingApplied(IXQEQueryNode mdxQuery) {
        int[] types = new int[]{1018, 1112, 1020};
        IXQEQueryNode[] tNodes = mdxQuery.getDescendantsOfTypes(types, false);
        for (int idx = 0; idx < tNodes.length; ++idx) {
            boolean unproceesed = false;
            IXQEQueryNode tNode = tNodes[idx];
            switch (tNode.getType()) {
                case 1018: {
                    if (((TNodeApplyMDFOnSingleHierarchyToSet)tNode).getDetailFilterIds().size() <= 0) break;
                    unproceesed = true;
                    break;
                }
                case 1020: {
                    if (((TNodeApplyVDFToSet)tNode).getDetailFilterIds().size() <= 0) break;
                    unproceesed = true;
                    break;
                }
                case 1112: {
                    if (((TNodeApplyORdMDFsOnDiffHiersToSet)tNode).getDetailFilterIds().size() <= 0) break;
                    unproceesed = true;
                    break;
                }
            }
            if (!unproceesed) continue;
            return false;
        }
        return true;
    }

    public static MDXNumericIIF buildVDFReaggregationExpression(IXQENodeFactory factory, MDXQuery mdxQuery, AbstractMDXSet aggregationSet, AbstractMDXBooleanExpression dfCond, AbstractMDXSet generateAggregationSet, boolean usingSetAlias) {
        MDXNumericIIF iifExpr = null;
        AbstractMDXSetOperator mdxFilter = MDXBuilder.buildMDXFilterExpr(factory, aggregationSet, dfCond);
        MDXCount mdxCount = MDXBuilder.buildMDXCountExpr(factory, mdxFilter, true);
        MDXComparisonOperator gtExpr = MDXBuilder.buildMDXComparisonExpr(factory, 3, mdxCount, MDXBuilder.buildMDXNumericConstant(factory, 0));
        MDXSummaryFunction aggrExpr = null;
        if (generateAggregationSet != null) {
            AbstractMDXSet generateSet = null;
            for (IHierarchy hier : ((AbstractMDXNode)mdxFilter).getHierarchyInfo().getProjectedHierarchies()) {
                if (generateAggregationSet.getHierarchyInfo().projectsHierarchy(hier)) continue;
                if (generateSet == null) {
                    generateSet = MDXBuilder.buildMDXSetExpr(factory, MDXBuilder.buildMDXCurrentMemberExpr(factory, hier));
                    continue;
                }
                generateSet = MDXBuilder.buildMDXCrossjoinCurrentMemberExpr(factory, hier, generateSet);
            }
            generateSet = generateSet == null ? generateAggregationSet : MDXBuilder.buildMDXCrossjoinExpr(factory, generateSet, generateAggregationSet);
            mdxFilter = MDXBuilder.buildMDXGenerateExpr(factory, (AbstractMDXSet)factory.deepCopyNode(mdxFilter), generateSet);
            aggrExpr = MDXBuilder.buildMDXSummaryFunctionExpr(factory, MDXSummaryFunctionTypeEnum.AGGREGATE, mdxFilter, null);
        } else if (usingSetAlias) {
            MDXSetAliasReference aliasRef = MDXBuilder.buildMDXSetAlias(factory, mdxQuery, mdxFilter);
            aggrExpr = MDXBuilder.buildMDXSummaryFunctionExpr(factory, MDXSummaryFunctionTypeEnum.AGGREGATE, aliasRef, null);
        } else {
            aggrExpr = MDXBuilder.buildMDXSummaryFunctionExpr(factory, MDXSummaryFunctionTypeEnum.AGGREGATE, (AbstractMDXSet)factory.deepCopyNode(mdxFilter), null);
        }
        iifExpr = MDXBuilder.buildMDXNumericIIFExprWithNull(factory, gtExpr, aggrExpr);
        iifExpr.setPropertyValue(PROPERTY_DFSL_AGGR_IIF, Boolean.TRUE);
        return iifExpr;
    }

    public static MDXNumericIIF buildMDFReaggregationExpression(IXQENodeFactory factory, MDXQuery mdxQuery, TNodeAbstractDetailFilter tNodeMDF, boolean usingSetAlias) {
        AbstractMDXSet aggregationSet = (AbstractMDXSet)DFSLAggrUtil.getSingleMDFAggregationSet(tNodeMDF).detach();
        IHierarchy hierarchy = aggregationSet.getHierarchyInfo().getProjectedHierarchy(0);
        DFSLAggrUtil.checkHierarchyRollup(hierarchy);
        if (tNodeMDF.getPropertyValue(PROPERTY_AGGR_PROJECTED_SET) == Boolean.TRUE) {
            if (aggregationSet.getType() == 1125) {
                AbstractMDXSet dfSet = (AbstractMDXSet)aggregationSet.detachChild(1);
                MDXTupleItem dfTupleItem = MDXBuilder.buildMDXTupleItem(factory, MDXBuilder.buildMDXSetItem(factory, dfSet, 0), 0);
                AbstractMDXNumericValueExpression dfSetItemValue = MDXBuilder.coerceToNumericValueExpression(dfTupleItem, factory);
                IXQEQueryNode lessThan = aggregationSet.detachChild(0);
                AbstractMDXNumericValueExpression currentMemberValue = MDXBuilder.coerceToNumericValueExpression(MDXBuilder.buildMDXCurrentMemberExpr(factory, hierarchy), factory);
                MDXNumericIIF numericIIF = (MDXNumericIIF)factory.createNode(1085);
                numericIIF.addChild(lessThan);
                numericIIF.addChild(dfSetItemValue);
                numericIIF.addChild(currentMemberValue);
                return numericIIF;
            }
            if (tNodeMDF.getPropertyValue(PROPERTY_HIGHEST_AGGREGATION_LEVEL) != null) {
                int highestLevelIndex = (Integer)tNodeMDF.getPropertyValue(PROPERTY_HIGHEST_AGGREGATION_LEVEL);
                return DFSLAggrUtil.buildMDFReaggregationExpressionProjectedSet(factory, mdxQuery, aggregationSet, highestLevelIndex);
            }
        }
        boolean slicerOrMemberDetailFilterOnHigherLevel = aggregationSet.slicerOrMDFOnHigherlevelOnly();
        if (aggregationSet.getType() != 1014) {
            aggregationSet = MDXBuilder.buildMDXNamedSet(factory, mdxQuery, "", aggregationSet);
        }
        AbstractMDXSet aggrSet = null;
        if (slicerOrMemberDetailFilterOnHigherLevel) {
            aggrSet = MDXBuilder.intersectSetWithAncestorsOfCurrentMember(factory, aggregationSet);
        } else {
            DFSLAggrUtil.checkHierarchyRollup(hierarchy);
            aggrSet = MDXBuilder.intersectSetWithDescendantsOfCurrentMember(factory, aggregationSet);
        }
        MDXCount mdxCount = MDXBuilder.buildMDXCountExpr(factory, aggrSet, true);
        MDXComparisonOperator gtExpr = MDXBuilder.buildMDXComparisonExpr(factory, 3, mdxCount, MDXBuilder.buildMDXNumericConstant(factory, 0));
        MDXSummaryFunction aggrExpr = null;
        if (slicerOrMemberDetailFilterOnHigherLevel) {
            MDXSet currentMemberSet = MDXBuilder.buildMDXSetExpr(factory, MDXBuilder.buildMDXCurrentMemberExpr(factory, hierarchy));
            aggrExpr = MDXBuilder.buildMDXSummaryFunctionExpr(factory, MDXSummaryFunctionTypeEnum.AGGREGATE, currentMemberSet, null);
        } else if (usingSetAlias) {
            MDXSetAliasReference aliasRef = MDXBuilder.buildMDXSetAlias(factory, mdxQuery, aggrSet);
            aggrExpr = MDXBuilder.buildMDXSummaryFunctionExpr(factory, MDXSummaryFunctionTypeEnum.AGGREGATE, aliasRef, null);
        } else {
            aggrExpr = MDXBuilder.buildMDXSummaryFunctionExpr(factory, MDXSummaryFunctionTypeEnum.AGGREGATE, (AbstractMDXSet)factory.deepCopyNode(aggrSet), null);
        }
        MDXNumericIIF iifExpr = MDXBuilder.buildMDXNumericIIFExprWithNull(factory, gtExpr, aggrExpr);
        iifExpr.setPropertyValue(PROPERTY_DFSL_AGGR_IIF, Boolean.TRUE);
        return iifExpr;
    }

    public static MDXNumericIIF buildMDFReaggregationExpressionProjectedSet(IXQENodeFactory factory, MDXQuery mdxQuery, AbstractMDXSet aggregationSet, int highestLevelIndex) {
        IHierarchy hierarchy = aggregationSet.getHierarchyInfo().getProjectedHierarchy(0);
        AbstractMDXSet aggrSet = null;
        DFSLAggrUtil.checkHierarchyRollup(hierarchy);
        aggrSet = MDXBuilder.intersectSetWithDescendantsOfCurrentMember(factory, aggregationSet);
        MDXSummaryFunction aggrExpr = null;
        aggrExpr = MDXBuilder.buildMDXSummaryFunctionExpr(factory, MDXSummaryFunctionTypeEnum.AGGREGATE, (AbstractMDXSet)factory.deepCopyNode(aggrSet), null);
        MDXNumericConstant levelIndex = (MDXNumericConstant)factory.createNode(1064);
        levelIndex.setConstantValue(highestLevelIndex);
        MDXComparisonOperator lessThan = MDXBuilder.buildMDXCurrentMemberLevelOrdinalLTExpr(factory, hierarchy, levelIndex);
        MDXCurrentMember currentMember = MDXBuilder.buildMDXCurrentMemberExpr(factory, hierarchy);
        AbstractMDXNumericValueExpression currentMemberValue = MDXBuilder.coerceToNumericValueExpression(currentMember, factory);
        MDXNumericIIF mdxIIF = (MDXNumericIIF)factory.createNode(1085);
        mdxIIF.addChild(lessThan);
        mdxIIF.addChild(aggrExpr);
        mdxIIF.addChild(currentMemberValue);
        return mdxIIF;
    }

    public static void replaceBaseMeasureWithReaggregationCalculatedMeasure(BaseMember baseMeasure, MDXCalculatedMemberReference calculatedMeasure, IXQENodeFactory factory) {
        if (calculatedMeasure.getType() != 1013) {
            calculatedMeasure.throwInternalError("Applying reaggregation to measure does not create a calculated measure");
        }
        calculatedMeasure.getDefinition().setPropertyValue("v5Caption", baseMeasure.getMember().getCaptionValue().getString());
        calculatedMeasure.getDefinition().setPropertyValue("v5Name", baseMeasure.getMember().getV5UniqueName());
        calculatedMeasure.setRollupAggregate(baseMeasure.getRollupAggregate());
        baseMeasure.exchange(calculatedMeasure, true);
    }

    public static void setReaggregationHostName(TNodeAbstractMDXNode tnode, String locationName) {
        tnode.setPropertyValue(PROPERTY_REAGGREGATION_HOST, locationName);
    }

    public static String getReaggregationHostName(TNodeAbstractMDXNode tnode) {
        Object result = tnode.getPropertyValue(PROPERTY_REAGGREGATION_HOST);
        if (result == null) {
            return null;
        }
        return (String)result;
    }

    public static AbstractMDXSet getSingleMDFAggregationSet(TNodeAbstractMDXNode tnode) {
        if (tnode.getNumberChildren() < 2) {
            return null;
        }
        return (AbstractMDXSet)tnode.getChild(1);
    }

    public static boolean isMDFReadyToBeApplied(TNodeAbstractMDXNode mdf) {
        boolean bResult = DFSLAggrUtil.getSingleMDFAggregationSet(mdf) != null && DFSLAggrUtil.getReaggregationHostName(mdf) != null;
        return bResult;
    }

    public static void validateReAggregationSupport(MDXQuery mdxQuery) {
        if (mdxQuery.getCapabilities().isSupported("mdx.support.reaggregationNonAdditive")) {
            return;
        }
        boolean foundAggregate = false;
        List<IXQEQueryNode> summaryFns = mdxQuery.getDescendantsOfCategory(1060, false);
        for (IXQEQueryNode summaryFn : summaryFns) {
            if (((MDXSummaryFunction)summaryFn).getSummaryType() != MDXSummaryFunctionTypeEnum.AGGREGATE) continue;
            foundAggregate = true;
            break;
        }
        if (!foundAggregate) {
            return;
        }
        List<IXQEQueryNode> baseMembers = mdxQuery.getDescendantsOfCategory(1067, false);
        for (IXQEQueryNode member : baseMembers) {
            AggregateTypeEnum regularAggregate;
            BaseMember measure = (BaseMember)member;
            if (!measure.isMeasure() || (regularAggregate = measure.getMember().getRegularAggregate()).isAdditive()) continue;
            throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedReAggregation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkHierarchyRollup(IHierarchy hierarchy) {
        block6: {
            IDimension dim = hierarchy.getDimension();
            ICube cube = dim.getCube();
            if (cube.getType() == ICube.CubeTypeEnum.ROLAP) {
                ROLAPCube rolapCube = ROLAPCubeManager.getInstance().getCube(cube.getUniqueName());
                ROLAPContext.queryEnter(ExecutionEnvironmentContext.getExecutionEnvironment(), rolapCube);
                try {
                    IROLAPDimension rolapDim = (IROLAPDimension)rolapCube.getDimension(dim.getName());
                    if (rolapDim != null && !rolapDim.getMembersRollup(rolapCube, true)) {
                        throw new XQERuntimeException(XQEMessageKeys.PLN_HierarchyDoesNotRollup, hierarchy.toString());
                    }
                    break block6;
                }
                finally {
                    ROLAPContext.queryExit(ExecutionEnvironmentContext.getExecutionEnvironment());
                }
            }
            if (!dim.getMembersRollup()) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_HierarchyDoesNotRollup, hierarchy.toString());
            }
        }
    }
}

