/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.application;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.AbstractMDXTuple;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXHeadTailFunction;
import com.cognos.xqe.ast.olap.MDXNamedSetDefinition;
import com.cognos.xqe.ast.olap.MDXNamedSetReference;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.TNodeApplyMDFOnSingleHierarchyToSet;
import com.cognos.xqe.ast.olap.TNodeMDFOnSingleHierarchy;
import com.cognos.xqe.ast.olap.TNodeUnbCompensation;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.optimization.ReplaceTNodeTrueFalse;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.application.DFSLApplicationUtil;
import java.util.ArrayList;
import java.util.List;

public final class DistributeMDFToPreMDXFilteringSets
extends Transformation {
    public static final String PROPERTY_TRANSFORMATION_APPLIED = "DistributeMemberDFToPreMDXFilteringSetsApplied";
    private int[] targetSetTypes = new int[]{1039, 1040, 1048, 1052, 1044, 1045, 1075, 1051, 1074, 1014, 1148};

    public DistributeMDFToPreMDXFilteringSets() {
        this.mName = "Distribute Member Detail Filters To Pre-MDX Filtering Sets.";
        this.mPassNumbers = new int[]{18};
        this.mTypes = new int[]{1093};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        TNodeMDFOnSingleHierarchy tNodeMDFOnSingleHierarchy = (TNodeMDFOnSingleHierarchy)node;
        MDXLevelInfo detailFilterLevelInfo = ((AbstractMDXSet)tNodeMDFOnSingleHierarchy.getChild(0).getChild(1)).getLevelInfo();
        MDXHierInfo detailFilterHierInfo = detailFilterLevelInfo.getHierarchyInfo();
        XQENodeFactory factory = environment.getNodeFactory();
        if (detailFilterHierInfo.getNumProjectedHierarchies() == 1 && detailFilterLevelInfo.getNumProjectedLevels(detailFilterHierInfo.getProjectedHierarchy(0)) == 0) {
            MDXQuery query = (MDXQuery)tNodeMDFOnSingleHierarchy.getAncestorOfCategory(1002);
            ReplaceTNodeTrueFalse.clearQuery(factory, query);
            ReplaceTNodeTrueFalse.constantFilteringExpressionWarning(environment, tNodeMDFOnSingleHierarchy.getOriginalExpression(), false);
            return;
        }
        MDXQuery mdxQuery = (MDXQuery)tNodeMDFOnSingleHierarchy.getAncestorOfType(1002);
        DistributeMDFToPreMDXFilteringSets.removeUselessMDXSetNodes(mdxQuery);
        ArrayList<AbstractMDXNode> targetSets = new ArrayList<AbstractMDXNode>();
        MDXEdge[] edges = mdxQuery.getEdges();
        for (int i = 0; i < edges.length; ++i) {
            targetSets.addAll(edges[i].getDescendantsOfTypes(this.targetSetTypes, true, true, true, true, false));
            IXQEQueryNode[] iXQEQueryNodeArray = edges[i].getDescendantsOfType(1113, false);
            for (int j = 0; j < iXQEQueryNodeArray.length; ++j) {
                TNodeUnbCompensation tNodeUnbCompensation = (TNodeUnbCompensation)iXQEQueryNodeArray[j];
                if (tNodeUnbCompensation.getChild(1).getType() != 1030) continue;
                List<AbstractMDXNode> diffHierNestedUnderUnbalanced = ((AbstractMDXSet)tNodeUnbCompensation.getChild(1).getChild(1)).getDescendantsOfTypes(this.targetSetTypes, true, true, true, true, false);
                targetSets.addAll(diffHierNestedUnderUnbalanced);
            }
        }
        for (AbstractMDXSet abstractMDXSet : targetSets) {
            MDXHierInfo targetSetHierInfo;
            MDXNamedSetDefinition ancestorNamedSetDefinition;
            if (abstractMDXSet.isOfCategory(1014) && !((MDXNamedSetReference)abstractMDXSet).getDefinition().getDBNamedSet() || (ancestorNamedSetDefinition = (MDXNamedSetDefinition)abstractMDXSet.getAncestorOfType(1003)) != null && ancestorNamedSetDefinition.getDBNamedSet() || !DistributeMDFToPreMDXFilteringSets.isValidTargetSetNode(abstractMDXSet) || !(targetSetHierInfo = abstractMDXSet.getHierarchyInfo()).compareProjectedHierarchies(detailFilterHierInfo)) continue;
            AbstractMDXSet ancestorGroup = (AbstractMDXSet)abstractMDXSet.getParentWhereDescendantOfChildAtIndexForNodeOfType(1027, 1, true);
            if (ancestorGroup != null && ancestorGroup.isProjectedDescendant(abstractMDXSet) && DistributeMDFToPreMDXFilteringSets.isValidTargetSetNode((AbstractMDXSet)ancestorGroup.getChild(0))) {
                IHierarchy hierarchy = detailFilterHierInfo.getProjectedHierarchy(0);
                MDXLevelInfo contextLevelInfo = abstractMDXSet.getContextLevelInfo(ancestorGroup);
                MDXLevelInfo targetLevelInfo = abstractMDXSet.getLevelInfo();
                ILevel contextHighestLevel = contextLevelInfo.getHighestProjectedLevel(hierarchy);
                ILevel dfLowestLevel = detailFilterLevelInfo.getLowestProjectedLevel(hierarchy);
                ILevel targetHighestLevel = targetLevelInfo.getHighestProjectedLevel(hierarchy);
                if (contextLevelInfo != null && contextHighestLevel != null && dfLowestLevel != null && targetHighestLevel != null && contextLevelInfo.getHierarchyInfo().compareProjectedHierarchies(detailFilterHierInfo) && contextHighestLevel.getIndex() >= dfLowestLevel.getIndex() && targetHighestLevel.getIndex() >= contextHighestLevel.getIndex()) continue;
            }
            if (abstractMDXSet.isEmpty()) continue;
            if (abstractMDXSet.getParent().getType() == 1018) {
                ((TNodeApplyMDFOnSingleHierarchyToSet)abstractMDXSet.getParent()).addDetailFilterId(tNodeMDFOnSingleHierarchy.getId());
                continue;
            }
            if (abstractMDXSet.getType() != 1039) {
                TNodeApplyMDFOnSingleHierarchyToSet tNode = (TNodeApplyMDFOnSingleHierarchyToSet)factory.createNode(1018);
                tNode.addDetailFilterId(tNodeMDFOnSingleHierarchy.getId());
                abstractMDXSet.insertParent(tNode);
                continue;
            }
            DistributeMDFToPreMDXFilteringSets.addTNodeToMDXSet(factory, (MDXSet)abstractMDXSet, tNodeMDFOnSingleHierarchy.getId());
        }
        tNodeMDFOnSingleHierarchy.setPropertyValue(PROPERTY_TRANSFORMATION_APPLIED, Boolean.TRUE);
    }

    protected static boolean isValidTargetSetNode(AbstractMDXSet targetSet) {
        int[] types = new int[]{1010, 1093, 1193, 1108, 1107, 1095, 1009, 1098, 1097, 1185};
        IXQEQueryNode invalidAncestor = targetSet.getAncestorOfTypes(types);
        if (!(invalidAncestor == null || targetSet.isOfCategory(1042) && ((MDXHeadTailFunction)targetSet).getOperatorType() == 1 && targetSet.isUnbalancedCompensation())) {
            return false;
        }
        if (!(targetSet.isDescendantOfChildAtIndexForNodeOfCategory(1113, 1, true) || !targetSet.isDescendantOfChildAtIndexForNodeOfCategory(1078, 1, true) || targetSet.isOfCategory(1042) && ((MDXHeadTailFunction)targetSet).getOperatorType() == 1 && targetSet.isUnbalancedCompensation())) {
            return false;
        }
        if (!(targetSet.getType() != 1039 || ((MDXSet)targetSet).projectsNonCalculatedMember() && ((MDXSet)targetSet).containsMemberOrTupleExpression())) {
            return false;
        }
        if (DFSLApplicationUtil.isSetANoMemberOnly(targetSet)) {
            return false;
        }
        int childPos = -1;
        if (targetSet.isDescendantOfChildAtIndexForNodeOfType(1032, 1, true)) {
            IXQEQueryNode parent = targetSet.getParent();
            childPos = parent.getPositionOfChild(targetSet);
            while (parent.getType() != 1032 || childPos != 1) {
                if (parent.isOfCategory(1021) && ((AbstractMDXSet)parent).isFilteringOperator(true)) {
                    return true;
                }
                childPos = parent.getParent().getPositionOfChild(parent);
                parent = parent.getParent();
            }
            return false;
        }
        if (targetSet.isDescendantOfChildAtIndexForNodeOfType(1038, 1, true)) {
            IXQEQueryNode parent = targetSet.getParent();
            childPos = parent.getPositionOfChild(targetSet);
            while (parent.getType() != 1038 || childPos != 1) {
                if (parent.isOfCategory(1021) && ((AbstractMDXSet)parent).isFilteringOperator(true)) {
                    return true;
                }
                childPos = parent.getParent().getPositionOfChild(parent);
                parent = parent.getParent();
            }
            return false;
        }
        if (targetSet.isDescendantOfChildAtIndexForNodeOfType(1057, 0, true)) {
            IXQEQueryNode parent = targetSet.getParent();
            childPos = parent.getPositionOfChild(targetSet);
            while (parent.getType() != 1057 || childPos != 0) {
                if (parent.isOfCategory(1021) && ((AbstractMDXSet)parent).isFilteringOperator(true)) {
                    return true;
                }
                childPos = parent.getParent().getPositionOfChild(parent);
                parent = parent.getParent();
            }
            return false;
        }
        return true;
    }

    protected static void removeUselessMDXSetNodes(IXQEQueryNode mdxQuery) {
        IXQEQueryNode[] mdxSets = mdxQuery.getDescendantsOfType(1039, false);
        for (int i = 0; i < mdxSets.length; ++i) {
            if (mdxSets[i].getProperties().size() > 0 || mdxSets[i].getParent().getType() != 1039 && (mdxSets[i].getNumberChildren() != 1 || !mdxSets[i].getChild(0).isOfCategory(1021))) continue;
            mdxSets[i].extract();
        }
    }

    public static void addTNodeToMDXSet(IXQENodeFactory factory, MDXSet mdxSet, Integer dfNodeId) {
        TNodeApplyMDFOnSingleHierarchyToSet tNode = null;
        if (!mdxSet.containsSetExpression() && !mdxSet.projectsCalculatedMember()) {
            tNode = (TNodeApplyMDFOnSingleHierarchyToSet)factory.createNode(1018);
            tNode.addDetailFilterId(dfNodeId);
            mdxSet.insertParent(tNode);
            return;
        }
        IXQEQueryNode newSet = null;
        IXQEQueryNode[] children = mdxSet.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (children[i].isOfCategory(1021) || children[i].getType() == 1013 || children[i].isOfCategory(1068) && ((AbstractMDXTuple)children[i]).containsCalculatedMember()) {
                if (newSet == null) continue;
                tNode = (TNodeApplyMDFOnSingleHierarchyToSet)factory.createNode(1018);
                tNode.addDetailFilterId(dfNodeId);
                newSet.insertParent(tNode);
                newSet = null;
                continue;
            }
            if (newSet != null) {
                children[i].move(newSet);
                continue;
            }
            newSet = factory.createNode(1039);
            children[i].insertParent(newSet);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue(PROPERTY_TRANSFORMATION_APPLIED) == Boolean.TRUE) {
            this.traceNodeCondition(false, "The transformation was already applied to this node.", trace);
            return false;
        }
        IXQEQueryNode mdxQuery = node.getAncestorOfType(1002);
        IXQEQueryNode[] cogMDXDetailFilterNodes = mdxQuery.getDescendantsOfType(1010, false);
        if (cogMDXDetailFilterNodes.length > 0) {
            this.traceNodeCondition(false, "The query contains CogMDXDetailFilter nodes that have not yet been categorized.", trace);
            return false;
        }
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The child categories of the target TNodeMDFOnSingleHierarchy node are invalid.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The transformation has not yet been applied to this node.", trace);
        return true;
    }
}

