/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.application;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.AbstractMDXTuple;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.CogMDXNest;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXNamedSetDefinition;
import com.cognos.xqe.ast.olap.MDXNamedSetReference;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.TNodeApplyVDFToSet;
import com.cognos.xqe.ast.olap.TNodeValueDetailFilter;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.application.DFSLApplicationUtil;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.application.DistributeMDFToPreMDXFilteringSets;
import java.util.ArrayList;

public final class DistributeVDFToPreMDXFilteringSets
extends Transformation {
    public static final String PROPERTY_TRANSFORMATION_APPLIED = "DistributeVDFToPreMDXFilteringSets";
    private int[] targetSetTypes = new int[]{1039, 1040, 1048, 1052, 1044, 1045, 1075, 1051, 1074, 1014, 1148, 1113};

    public DistributeVDFToPreMDXFilteringSets() {
        this.mName = "Distribute Value Detail Filters To Pre-MDX Filtering Sets.";
        this.mPassNumbers = new int[]{18};
        this.mTypes = new int[]{1095};
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        DistributeMDFToPreMDXFilteringSets.removeUselessMDXSetNodes(mdxQuery);
        MDXHierInfo queryProjHierInfo = null;
        ArrayList<AbstractMDXNode> targetSets = new ArrayList<AbstractMDXNode>();
        MDXEdge[] edges = mdxQuery.getEdges();
        for (int i = 0; i < edges.length; ++i) {
            targetSets.addAll(edges[i].getDescendantsOfTypes(this.targetSetTypes, true, true, true, true, false));
        }
        for (AbstractMDXSet abstractMDXSet : targetSets) {
            MDXEdge edge;
            void var9_10;
            IXQEQueryNode cogMdxGroup;
            void var9_15;
            void var9_13;
            MDXHierInfo targetSetHierInfo;
            MDXNamedSetDefinition ancestorNamedSetDefinition;
            if (abstractMDXSet.isOfCategory(1014) && !((MDXNamedSetReference)abstractMDXSet).getDefinition().getDBNamedSet() || (ancestorNamedSetDefinition = (MDXNamedSetDefinition)abstractMDXSet.getAncestorOfType(1003)) != null && ancestorNamedSetDefinition.getDBNamedSet()) continue;
            if (abstractMDXSet.getType() == 1113) {
                AbstractMDXSet abstractMDXSet2 = (AbstractMDXSet)abstractMDXSet.getChild(1);
            } else if (!DistributeMDFToPreMDXFilteringSets.isValidTargetSetNode(abstractMDXSet) || this.isOuterProjectedNonFilteredSet(abstractMDXSet)) continue;
            if ((targetSetHierInfo = var9_13.getHierarchyInfo()).getNumProjectedHierarchies() == 0) continue;
            if (targetSetHierInfo.getProjectedHierarchy(0).getDimension().isMeasuresDimension()) {
                if (queryProjHierInfo == null) {
                    queryProjHierInfo = mdxQuery.getHierarchyInfo();
                }
                if (queryProjHierInfo.getNumProjectedHierarchies() > 1 || !queryProjHierInfo.getProjectedHierarchy(0).getDimension().isMeasuresDimension()) continue;
            }
            if (var9_13.getParent().getType() == 1018) {
                AbstractMDXSet abstractMDXSet3 = (AbstractMDXSet)var9_13.getParent();
            }
            if (var9_15.getParent().getType() == 1112) {
                AbstractMDXSet abstractMDXSet4 = (AbstractMDXSet)var9_15.getParent();
            }
            if (null != (cogMdxGroup = var9_10.getParent()) && cogMdxGroup.getType() == 1027 && null != (edge = (MDXEdge)cogMdxGroup.getAncestorOfType(1006)) && edge.isProjectedDescendant((CogMDXGroup)cogMdxGroup) && mdxQuery.isSuppressNulls() && var9_10.onlyProjectsLevelsFromDifferentHierarchies() && node.getPropertyValue("AggregationRequired") == Boolean.TRUE) continue;
            if (var9_10.getParent().getType() == 1020) {
                ((TNodeApplyVDFToSet)var9_10.getParent()).addDetailFilterId(node.getId());
                ((TNodeValueDetailFilter)node).addTNodeApplyVDFSetId(((TNodeApplyVDFToSet)var9_10.getParent()).getId());
                continue;
            }
            if (var9_10.isEmpty()) continue;
            if (var9_10.getType() != 1039) {
                TNodeApplyVDFToSet tNode = (TNodeApplyVDFToSet)factory.createNode(1020);
                tNode.addDetailFilterId(node.getId());
                ((TNodeValueDetailFilter)node).addTNodeApplyVDFSetId(tNode.getId());
                var9_10.insertParent(tNode);
                continue;
            }
            this.addTNodeToMDXSet(factory, (MDXSet)var9_10, (TNodeValueDetailFilter)node);
        }
        node.setPropertyValue(PROPERTY_TRANSFORMATION_APPLIED, Boolean.TRUE);
    }

    private boolean isOuterProjectedNonFilteredSet(AbstractMDXSet set) {
        IXQEQueryNode parent = set.getParent();
        if (parent != null && parent.getChildrenOfType(1113).length > 0) {
            return false;
        }
        MDXHierInfo setHierInfo = set.getHierarchyInfo();
        if (setHierInfo.getNumProjectedHierarchies() != 1 || setHierInfo.getProjectedHierarchy(0).getDimension().isMeasuresDimension()) {
            return false;
        }
        AbstractMDXSet outerGroupNest = (AbstractMDXSet)set.getAncestorOfType(1026);
        if (outerGroupNest == null) {
            outerGroupNest = (AbstractMDXSet)set.getAncestorOfType(1027);
        }
        if (outerGroupNest != null) {
            MDXHierInfo innerHierInfo;
            int i;
            if (!outerGroupNest.isProjectedDescendant(set)) {
                return false;
            }
            while (parent != outerGroupNest) {
                if (!parent.isOfCategory(1021)) {
                    parent.throwInternalError("Node is not of category AbstractMDXSet.");
                }
                if (((AbstractMDXSet)parent).isFilteringOperator(false)) {
                    return false;
                }
                parent = parent.getParent();
            }
            IXQEQueryNode[] innerCogMDXNestNodes = outerGroupNest.getDescendantsOfType(1026, false);
            IXQEQueryNode[] innerCogMDXGroupNodes = outerGroupNest.getDescendantsOfType(1027, false);
            if (innerCogMDXNestNodes.length == 0 && innerCogMDXGroupNodes.length == 0) {
                return false;
            }
            for (i = 0; i < innerCogMDXNestNodes.length; ++i) {
                innerHierInfo = ((CogMDXNest)innerCogMDXNestNodes[i]).getHierarchyInfo();
                if (!innerHierInfo.projectedHierarchiesOverlap(setHierInfo)) continue;
                return true;
            }
            for (i = 0; i < innerCogMDXGroupNodes.length; ++i) {
                innerHierInfo = ((CogMDXGroup)innerCogMDXGroupNodes[i]).getHierarchyInfo();
                if (!innerHierInfo.projectedHierarchiesOverlap(setHierInfo)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private void addTNodeToMDXSet(IXQENodeFactory factory, MDXSet mdxSet, TNodeValueDetailFilter vdfNode) {
        Integer dfNodeId = vdfNode.getId();
        TNodeApplyVDFToSet tNode = null;
        if (!mdxSet.containsSetExpression() && !mdxSet.projectsCalculatedMember()) {
            tNode = (TNodeApplyVDFToSet)factory.createNode(1020);
            tNode.addDetailFilterId(dfNodeId);
            vdfNode.addTNodeApplyVDFSetId(tNode.getId());
            mdxSet.insertParent(tNode);
            return;
        }
        if (DFSLApplicationUtil.isSetANoMemberOnly(mdxSet)) {
            return;
        }
        IXQEQueryNode newSet = null;
        IXQEQueryNode[] children = mdxSet.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (children[i].isOfCategory(1021) || children[i].getType() == 1013 || children[i].isOfCategory(1068) && ((AbstractMDXTuple)children[i]).containsCalculatedMember()) {
                if (newSet == null) continue;
                tNode = (TNodeApplyVDFToSet)factory.createNode(1020);
                tNode.addDetailFilterId(dfNodeId);
                vdfNode.addTNodeApplyVDFSetId(tNode.getId());
                newSet.insertParent(tNode);
                newSet = null;
                continue;
            }
            if (newSet != null) {
                children[i].move(newSet);
                continue;
            }
            newSet = factory.createNode(1039);
            children[i].insertParent(newSet);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue("AggregationRequired") == null) {
            this.traceNodeCondition(false, "The target TNodeValueDetailFilter node has not yet been flagged as necessitating aggregation in the query.", trace);
            return false;
        }
        if (node.getPropertyValue(PROPERTY_TRANSFORMATION_APPLIED) == Boolean.TRUE) {
            this.traceNodeCondition(false, "The transformation was already applied to this node.", trace);
            return false;
        }
        IXQEQueryNode mdxQuery = node.getAncestorOfType(1002);
        IXQEQueryNode[] cogMDXDetailFilterNodes = mdxQuery.getDescendantsOfType(1010, false);
        if (cogMDXDetailFilterNodes.length > 0) {
            this.traceNodeCondition(false, "The query contains CogMDXDetailFilter nodes that have not yet been categorized.", trace);
            return false;
        }
        IXQEQueryNode[] tNodeMDFs = mdxQuery.getDescendantsOfType(1093, false);
        for (int i = 0; i < tNodeMDFs.length; ++i) {
            if (tNodeMDFs[i].getPropertyValue("DistributeMemberDFToPreMDXFilteringSetsApplied") == Boolean.TRUE) continue;
            this.traceNodeCondition(false, "The query contains TNodeMDFOnSingleHierarchy nodes that have not yet been distributed to all parts of the query.", trace);
            return false;
        }
        IXQEQueryNode[] tNodeORdMDFsOnDiffHiers = mdxQuery.getDescendantsOfType(1107, false);
        for (int i = 0; i < tNodeORdMDFsOnDiffHiers.length; ++i) {
            if (tNodeORdMDFsOnDiffHiers[i].getPropertyValue("DistributeORdMDFsOnDiffHiersToPreMDXFilteringSetsApplied") == Boolean.TRUE) continue;
            this.traceNodeCondition(false, "The query contains TNodeORdMDFsOnDiffHiers nodes that have not yet been distributed to all parts of the query.", trace);
            return false;
        }
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The child categories of the target TNodeValueDetailFilter node are invalid.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The transformation has not yet been applied to this node.", trace);
        return true;
    }
}

