/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.classification;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.CogMDXIn;
import com.cognos.xqe.ast.olap.MDXMembers;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeMDFOnSingleHierarchy;
import com.cognos.xqe.ast.olap.TNodeMDFOnSingleUnrefHierarchy;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.classification.DFSLClassificationUtil;
import java.util.Set;

public final class CastToMDFOnSingleUnrefHierarchy
extends Transformation {
    public CastToMDFOnSingleUnrefHierarchy() {
        this.mName = "Cast To Member Detail Filter On Single Unreferenced Hierarchy.";
        this.mPassNumbers = new int[]{8};
        this.mTypes = new int[]{1093};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        TNodeMDFOnSingleHierarchy tNodeMDFOnSingleHierarchy = (TNodeMDFOnSingleHierarchy)node;
        XQENodeFactory factory = environment.getNodeFactory();
        TNodeMDFOnSingleUnrefHierarchy tNode = (TNodeMDFOnSingleUnrefHierarchy)factory.createNode(1094);
        DFSLClassificationUtil.copyProperties(tNodeMDFOnSingleHierarchy, tNode);
        CogMDXIn cogMDXIn = (CogMDXIn)tNodeMDFOnSingleHierarchy.getChild(0);
        tNode.addCorrelatedHierarchies(cogMDXIn.getCorrelatedHierarchies());
        tNodeMDFOnSingleHierarchy.exchange(tNode, true);
        MDXQuery mdxQuery = (MDXQuery)tNode.getAncestorOfType(1002);
        AbstractMDXNode expression = (AbstractMDXNode)tNode.getChild(0).getChild(1);
        mdxQuery.updateCountOfMDFandSlicerByHierarchy(expression.getHierarchyInfo().getProjectedHierarchy(0));
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            node.throwInternalError("Internal Error.");
        }
        if (mdxQuery.getDescendantsOfType(1009, false).length > 0) {
            this.traceNodeCondition(false, "There are CogMDXSlicer nodes in the query that must be classified before this transformation can be applied.", trace);
            return false;
        }
        CogMDXIn cogMDXIn = (CogMDXIn)node.getChild(0);
        MDXHierInfo hierInfo = ((MDXMembers)cogMDXIn.getChild(0)).getHierarchyInfo();
        IHierarchy hierarchy = hierInfo.getProjectedHierarchy(0);
        Set<IHierarchy> referencedHierarchies = mdxQuery.getReferencedHierarchiesOnEdgesAndDimLine();
        if (referencedHierarchies == null || !referencedHierarchies.contains(hierarchy)) {
            IXQEQueryNode[] slicersOnUnrefHierarchies = mdxQuery.getDescendantsOfType(1097, false);
            for (int i = 0; i < slicersOnUnrefHierarchies.length; ++i) {
                MDXHierInfo slicerHierInfo = ((AbstractMDXNode)slicersOnUnrefHierarchies[i].getChild(0)).getHierarchyInfo();
                if (!hierInfo.projectedHierarchiesOverlap(slicerHierInfo)) continue;
                this.traceNodeCondition(false, "The TNodeMDFOnSingleHierarchy is applied to a hierarchy that is projected by a TNodeSlicerOnUnreferencedHierarchy node.", trace);
                return false;
            }
            if (!DFSLClassificationUtil.queryContainsVDFThatReferencesHierarchy(mdxQuery, hierarchy)) {
                this.traceNodeCondition(true, "The TNodeMDFOnSingleHierarchy is applied to a hierarchy that is not referenced in the MDXEdge expressions or value comparison detail filter conditions in the MDXQuery.", trace);
                return true;
            }
        }
        this.traceNodeCondition(false, "The TNodeMDFOnSingleHierarchy is applied to a hierarchy that is referenced in at leastone of the MDXEdge expressions or value comparison detail filter conditions in the MDXQuery.", trace);
        return false;
    }
}

