/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.classification;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXBooleanExpression;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.olap.CogMDXIn;
import com.cognos.xqe.ast.olap.MDXComparisonOperator;
import com.cognos.xqe.ast.olap.MDXCount;
import com.cognos.xqe.ast.olap.MDXOr;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeAbstractDetailFilter;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class DFSLClassificationUtil {
    private DFSLClassificationUtil() {
    }

    public static boolean queryContainsVDFThatReferencesHierarchy(MDXQuery mdxQuery, IHierarchy hierarchy) {
        int[] vdfNodeTypes = new int[]{1010, 1108, 1095};
        IXQEQueryNode[] vdfNodes = mdxQuery.getDescendantsOfTypes(vdfNodeTypes, false);
        ArrayList<AbstractMDXBooleanExpression> vdfConditions = new ArrayList<AbstractMDXBooleanExpression>();
        for (int i = 0; i < vdfNodes.length; ++i) {
            AbstractMDXBooleanExpression condition;
            if (vdfNodes[i].getType() == 1010 && ((CogMDXDetailFilter)vdfNodes[i]).pushDetailFilterToRelationalProvider()) continue;
            if (!((AbstractMDXNode)vdfNodes[i]).validateChildCategories()) {
                vdfNodes[i].throwInternalError("Encountered a detail filter node with invalid child categories.");
            }
            if ((condition = (AbstractMDXBooleanExpression)vdfNodes[i].getChild(0)).isConditionsOnValueExpressions()) {
                vdfConditions.add(condition);
                continue;
            }
            if (condition.getType() != 1111) continue;
            List<AbstractMDXBooleanExpression> orOperands = ((MDXOr)condition).getAssociativeOperandsInSubtree(false);
            for (AbstractMDXBooleanExpression opOperand : orOperands) {
                if (!opOperand.isConditionsOnValueExpressions()) continue;
                vdfConditions.add(opOperand);
            }
        }
        for (AbstractMDXBooleanExpression vdfCondition : vdfConditions) {
            Set<IHierarchy> hierarchies = vdfCondition.getReferencedHierarchies();
            if (!hierarchies.contains(hierarchy)) continue;
            return true;
        }
        return false;
    }

    public static void copyProperties(AbstractMDXNode originalDetailFilter, TNodeAbstractDetailFilter tNodeDetailFilter) {
        Boolean isDMRDuplicateFilter;
        Boolean aggregationRequired;
        String timing = (String)originalDetailFilter.getPropertyValue("timing");
        if (timing != null) {
            tNodeDetailFilter.setPropertyValue("timing", timing);
        }
        if ((aggregationRequired = (Boolean)originalDetailFilter.getPropertyValue("AggregationRequired")) != null) {
            tNodeDetailFilter.setPropertyValue("AggregationRequired", aggregationRequired);
        }
        if ((isDMRDuplicateFilter = (Boolean)originalDetailFilter.getPropertyValue("isDMRDuplicateFilterOnHierarchy")) != null) {
            tNodeDetailFilter.setPropertyValue("isDMRDuplicateFilterOnHierarchy", isDMRDuplicateFilter);
        }
        if (originalDetailFilter.isOfCategory(1179)) {
            tNodeDetailFilter.setPostAutoAggregation(((TNodeAbstractDetailFilter)originalDetailFilter).getPostAutoAggregation());
            tNodeDetailFilter.setOriginalExpression(((TNodeAbstractDetailFilter)originalDetailFilter).getOriginalExpression());
        } else if (originalDetailFilter.getType() == 1010) {
            tNodeDetailFilter.setPostAutoAggregation(((CogMDXDetailFilter)originalDetailFilter).getPostAutoAggregation());
            tNodeDetailFilter.setOriginalExpression(((CogMDXDetailFilter)originalDetailFilter).getOriginalExpression());
        } else {
            originalDetailFilter.throwInternalError("originalDetailFilter !CogMDXDetailFilter && !TNodeAbstractDetailFilter");
        }
        if (originalDetailFilter.isOfCategory(1179)) {
            tNodeDetailFilter.setMasterDetailFilter(((TNodeAbstractDetailFilter)originalDetailFilter).isMasterDetailFilter());
            tNodeDetailFilter.setMasterDetailLinkDescription(((TNodeAbstractDetailFilter)originalDetailFilter).getMasterDetailLinkDescription());
        } else if (originalDetailFilter.getType() == 1010) {
            tNodeDetailFilter.setMasterDetailFilter(((CogMDXDetailFilter)originalDetailFilter).isMasterDetailFilter());
            tNodeDetailFilter.setMasterDetailLinkDescription(((CogMDXDetailFilter)originalDetailFilter).getMasterDetailLinkDescription());
        }
    }

    public static MDXComparisonOperator castCogMDXInToValue(IXQENodeFactory factory, CogMDXIn condition, MDXLevelInfo levelInfo) {
        AbstractMDXSet dfSet = (AbstractMDXSet)condition.detachChild(1);
        MDXHierInfo hierInfo = dfSet.getHierarchyInfo();
        if (hierInfo.getNumProjectedHierarchies() != 1) {
            throw new XQERuntimeException();
        }
        IHierarchy projectedHierarchy = hierInfo.getProjectedHierarchy(0);
        boolean correlateSet = true;
        if (!condition.doCorrelate(projectedHierarchy)) {
            correlateSet = false;
        }
        MDXLevelInfo dfLevelInfo = dfSet.getLevelInfo();
        ILevel lowestProjectedLevel = null;
        if (!levelInfo.getHierarchyInfo().projectsHierarchy(projectedHierarchy)) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_MDFOrVDFWithContextFromNonProjHier, projectedHierarchy.getV5UniqueName());
        }
        lowestProjectedLevel = levelInfo.getLowestProjectedLevel(projectedHierarchy);
        AbstractMDXSet adjustedDfSet = dfSet;
        ILevel lowestFilterLevel = dfLevelInfo.getLowestProjectedLevel(projectedHierarchy);
        ILevel highestFilterLevel = dfLevelInfo.getHighestProjectedLevel(projectedHierarchy);
        if (highestFilterLevel.getIndex() < lowestProjectedLevel.getIndex()) {
            MDXLevelInfo lowestLevelInfo = new MDXLevelInfo();
            lowestLevelInfo.addProjectedHierarchy(lowestProjectedLevel);
            if (correlateSet) {
                adjustedDfSet = MDXBuilder.correlateSetToLevels(factory, dfSet, lowestLevelInfo);
            }
        } else if (lowestFilterLevel.getIndex() > lowestProjectedLevel.getIndex()) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_MDFOrVDFWithContextFromLowerLevelThanProjDetails, projectedHierarchy.getV5UniqueName());
        }
        AbstractMDXSet countDfSet = null;
        countDfSet = correlateSet ? MDXBuilder.intersectSetWithDescendantsOfCurrentMember(factory, adjustedDfSet) : MDXBuilder.intersectSetWithCurrentMember(factory, adjustedDfSet);
        MDXCount mdxCount = MDXBuilder.buildMDXCountExpr(factory, countDfSet, true);
        MDXComparisonOperator compExpr = MDXBuilder.buildMDXComparisonExpr(factory, 3, mdxCount, MDXBuilder.buildMDXNumericConstant(factory, 0));
        return compExpr;
    }
}

