/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.classification;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeIndex;
import com.cognos.xqe.ast.localprocessing.v5.V5MasterDetailWindow;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeAbstractDetailFilter;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import java.util.List;
import java.util.Set;

public final class DisableMasterDetailOptimizationWhenMDFHierMaster
extends Transformation {
    public DisableMasterDetailOptimizationWhenMDFHierMaster() {
        this.mName = "Disable master-detail optimization when a member detail filter would cause inconsistent re-aggregation.";
        this.mPassNumbers = new int[]{8};
        this.mTypes = new int[]{1093, 1094, 1108, 1107};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode mdw = node.getAncestorOfType(601026);
        V5MasterDetailWindow mdwCombined = (V5MasterDetailWindow)mdw;
        XQENodeIndex nodeIndex = environment.getNodeIndex();
        V5MasterDetailWindow mdwDetail = (V5MasterDetailWindow)nodeIndex.getNodeByID(mdwCombined.getMasterDetailWindowNodeIDDetail());
        mdwDetail.extract();
        V5MasterDetailWindow mdwMaster = (V5MasterDetailWindow)nodeIndex.getNodeByID(mdwCombined.getMasterDetailWindowNodeIDMaster());
        if (mdwMaster != null) {
            mdwMaster.extract();
        }
        mdwCombined.getAncestorOfType(401005).detach();
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        IXQEQueryNode mdw = node.getAncestorOfType(601026);
        boolean bl = status = mdw != null;
        if (!status) {
            this.traceQueryCondition(status, "The detail filter node is not in a n optimized query.", trace);
            return status;
        }
        boolean bl2 = status = ((V5MasterDetailWindow)mdw).getMasterDetailWindowNodeIDCombined() == mdw.getId().intValue();
        if (status) {
            this.traceQueryCondition(status, "The detail filter node is in the combined query.", trace);
        } else {
            this.traceQueryCondition(status, "The detail filter node is not in the combined query.", trace);
        }
        return status;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        TNodeAbstractDetailFilter tNode = (TNodeAbstractDetailFilter)node;
        status = tNode.getPostAutoAggregation();
        if (!status) {
            this.traceNodeCondition(status, "The filter is not post AutoAggregation.", trace);
            return status;
        }
        MDXQuery mdxQuery = (MDXQuery)tNode.getAncestorOfType(1002);
        MDXEdge mdxEdge = mdxQuery.getEdges()[mdxQuery.getNumberOfEdges() - 1];
        MDXLevelInfo levelInfoMaster = mdxEdge.getLevelInfo();
        levelInfoMaster.removeCalculationLevels();
        levelInfoMaster.removeNoMemberLevels();
        MDXHierInfo hierarchyInfoMaster = levelInfoMaster.getHierarchyInfo();
        List<IHierarchy> projectedHierarchiesMaster = hierarchyInfoMaster.getProjectedHierarchies();
        AbstractMDXNode filterExpression = (AbstractMDXNode)tNode.getChild(0);
        Set<IHierarchy> referencedHiers = filterExpression.getReferencedHierarchies();
        for (IHierarchy referencedHier : referencedHiers) {
            if (!projectedHierarchiesMaster.contains(referencedHier)) continue;
            ILevel lowestReferencedLevelInFilter = filterExpression.getLowestReferencedLevel(referencedHier);
            ILevel highestProjectedLevelInMaster = levelInfoMaster.getHighestProjectedLevel(referencedHier);
            if (lowestReferencedLevelInFilter.getIndex() <= highestProjectedLevelInMaster.getIndex()) continue;
            this.traceNodeCondition(true, "The optimization should be disabled.", trace);
            return true;
        }
        return false;
    }
}

