/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.classification;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeIndex;
import com.cognos.xqe.ast.localprocessing.v5.V5MasterDetailWindow;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class DisableMasterDetailOptimizationWhenVDF
extends Transformation {
    public DisableMasterDetailOptimizationWhenVDF() {
        this.mName = "Disable master-detail optimization when a value detail filter is used.";
        this.mPassNumbers = new int[]{8};
        this.mTypes = new int[]{601026};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5MasterDetailWindow mdwCombined = (V5MasterDetailWindow)node;
        XQENodeIndex nodeIndex = environment.getNodeIndex();
        V5MasterDetailWindow mdwDetail = (V5MasterDetailWindow)nodeIndex.getNodeByID(mdwCombined.getMasterDetailWindowNodeIDDetail());
        mdwDetail.extract();
        V5MasterDetailWindow mdwMaster = (V5MasterDetailWindow)nodeIndex.getNodeByID(mdwCombined.getMasterDetailWindowNodeIDMaster());
        if (mdwMaster != null) {
            mdwMaster.extract();
        }
        node.getAncestorOfType(401005).detach();
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        boolean bl = status = ((V5MasterDetailWindow)node).getMasterDetailWindowNodeIDCombined() == node.getId().intValue();
        if (status) {
            this.traceQueryCondition(status, "The node is in the combined query.", trace);
        } else {
            this.traceQueryCondition(status, "The node is not in the combined query.", trace);
        }
        return status;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        boolean bl = status = node.getDescendantsOfType(1095, false).length > 0;
        if (status) {
            this.traceNodeCondition(status, "The combined query has a value detail filter.", trace);
        } else {
            this.traceNodeCondition(status, "The combined query does not have a value detail filter.", trace);
        }
        return status;
    }
}

