/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.decomposition;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXBooleanExpression;
import com.cognos.xqe.ast.olap.MDXAnd;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class ApplyDistributiveLaw
extends Transformation {
    public ApplyDistributiveLaw() {
        this.mName = "Apply Boolean Distributive Law.";
        this.mPassNumbers = new int[]{6};
        this.mTypes = new int[]{1111};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode andOperand = null;
        IXQEQueryNode otherOperand = null;
        if (node.getChild(0).getType() == 1110) {
            andOperand = node.getChild(0);
            otherOperand = node.getChild(1);
        } else {
            andOperand = node.getChild(1);
            otherOperand = node.getChild(0);
        }
        node.detachChild(otherOperand);
        IXQEQueryNode newOROperator = nodeFactory.createNode(1111);
        andOperand.getChild(0).insertParent(newOROperator);
        newOROperator.addChild(otherOperand);
        newOROperator = nodeFactory.createNode(1111);
        andOperand.getChild(1).insertParent(newOROperator);
        newOROperator.addChild(nodeFactory.deepCopyNode(otherOperand));
        node.extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getAncestorOfType(1010) == null) {
            this.traceNodeCondition(false, "The MDXOr node is not a descendant of a CogMDXDetailFilter node.", trace);
            return false;
        }
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The child nodes of the target MDXOr node are invalid.", trace);
            return false;
        }
        IXQEQueryNode andOperand = null;
        IXQEQueryNode leftAndOperand = null;
        IXQEQueryNode rightAndOperand = null;
        if (node.getChild(0).getType() == 1110) {
            andOperand = leftAndOperand = node.getChild(0);
        }
        if (node.getChild(1).getType() == 1110) {
            andOperand = rightAndOperand = node.getChild(1);
        }
        if (leftAndOperand == null && rightAndOperand == null) {
            this.traceNodeCondition(false, "Neither of the children of the MDXOr node is an MDXAnd node.", trace);
            return false;
        }
        if (leftAndOperand != null && rightAndOperand != null) {
            this.traceNodeCondition(false, "Both of the children of the MDXOr node are MDXAnd nodes.", trace);
            return false;
        }
        if (leftAndOperand == null && node.getChild(0).getType() == 1111 || rightAndOperand == null && node.getChild(1).getType() == 1111) {
            this.traceNodeCondition(false, "One of the children of the MDXOr node is MDXOr node.", trace);
            return false;
        }
        if (!andOperand.validateChildCategories()) {
            this.traceNodeCondition(false, "The child nodes of the MDXAnd operand are invalid.", trace);
            return false;
        }
        if (leftAndOperand == null && node.getChild(0).getType() == 1029 || rightAndOperand == null && node.getChild(1).getType() == 1029) {
            AbstractMDXBooleanExpression condition;
            MDXAnd mdxAnd = (MDXAnd)andOperand;
            AbstractMDXBooleanExpression[] orConditions = mdxAnd.getAssociativeOperands(false);
            boolean foundValueExprCondition = false;
            for (int i = 0; i < orConditions.length && ((condition = orConditions[i]).getType() == 1029 || condition.isConditionsOnValueExpressions()); ++i) {
                if (foundValueExprCondition || !condition.isConditionsOnValueExpressions()) continue;
                foundValueExprCondition = true;
            }
            if (foundValueExprCondition) {
                this.traceNodeCondition(false, "The OR comparison is between a member comparisons and an AND comparison with nested value comparisons.", trace);
                return false;
            }
        }
        this.traceNodeCondition(true, "At least one of the children of the target MDXOr node is an MDXAnd node.", trace);
        return true;
    }
}

