/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.decomposition;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXBooleanExpression;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class ApplyRedundancyLaws
extends Transformation {
    public ApplyRedundancyLaws() {
        this.mName = "Apply Boolean Redundancy Laws.";
        this.mPassNumbers = new int[]{6};
        this.mTypes = new int[]{1109};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode parent = node.getParent();
        node.detach();
        parent.extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getAncestorOfType(1010) == null) {
            this.traceNodeCondition(false, "The MDXOr node is not a descendant of a CogMDXDetailFilter node.", trace);
            return false;
        }
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The child nodes of the target node are invalid.", trace);
            return false;
        }
        if (node.getParent() == null || node.getParent().getType() != 1110 && node.getParent().getType() != 1111) {
            this.traceNodeCondition(false, "The parent of the target node is not an MDXAnd or MDXOr node.", trace);
            return false;
        }
        IXQEQueryNode parent = node.getParent();
        if (parent.getParent() == null || parent.getParent().getType() != 1110 && parent.getParent().getType() != 1111) {
            this.traceNodeCondition(false, "The grandparent of the target node is not an MDXAnd or MDXOr node.", trace);
            return false;
        }
        IXQEQueryNode grandParent = parent.getParent();
        if (parent.getType() == grandParent.getType()) {
            this.traceNodeCondition(false, "The parent and grandparent nodes of the target node are the same type.", trace);
            return false;
        }
        if (!parent.validateChildCategories() || !grandParent.validateChildCategories()) {
            this.traceNodeCondition(false, "Either the parent or grandparent node of the target node has invalid child categories.", trace);
            return false;
        }
        boolean status = false;
        int pos = grandParent.getPositionOfChild(parent);
        if (pos == 0) {
            if (((AbstractMDXBooleanExpression)grandParent.getChild(1)).isLogicallyEquivalent((AbstractMDXBooleanExpression)node.getChild(0))) {
                status = true;
            }
        } else if (((AbstractMDXBooleanExpression)grandParent.getChild(0)).isLogicallyEquivalent((AbstractMDXBooleanExpression)node.getChild(0))) {
            status = true;
        }
        if (status) {
            this.traceNodeCondition(true, "The transformation is applicable to the target node.", trace);
        } else {
            this.traceNodeCondition(false, "The transformation is not applicable to the target node.", trace);
        }
        return status;
    }
}

