/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.normalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXParameterMember;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import java.util.Set;

public class ReplaceMasterDetailParameterWithParameterValue
extends Transformation {
    public ReplaceMasterDetailParameterWithParameterValue() {
        this.mName = "";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{1129};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery query = (MDXQuery)node.getAncestorOfType(1002);
        MDXParameterMember parameter = (MDXParameterMember)node;
        parameter.exchange(parameter.getReplacementMDXMember());
        ((RequestEnvironment)environment.getRequestEnvironment()).addQueryRequiresReplan(query.getRefQueryProperty());
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] filters;
        XQETrace trace = environment.getTrace();
        MDXParameterMember parameter = (MDXParameterMember)node;
        if (!parameter.isMasterDetailParameter()) {
            this.traceNodeCondition(false, "parameter is not a master-detail paramter", trace);
            return false;
        }
        CogMDXDetailFilter parentFilter = (CogMDXDetailFilter)parameter.getAncestorOfType(1010);
        if (parentFilter == null) {
            this.traceNodeCondition(false, "parameter is not part of a detail filter", trace);
            return false;
        }
        if (parameter.getReplacementMDXMember() == null) {
            this.traceNodeCondition(false, "parameter does not have a bound member attached.", trace);
            return false;
        }
        MDXQuery query = (MDXQuery)node.getAncestorOfType(1002);
        MDXEdge[] edges = query.getEdges();
        IHierarchy parameterHierarchy = parameter.getHierarchy();
        for (MDXEdge edge : edges) {
            Set<IHierarchy> refHierarchies = edge.getReferencedHierarchies();
            if (!refHierarchies.contains(parameterHierarchy)) continue;
            this.traceNodeCondition(true, "The hierarchy of the parameter is referenced elsewhere in the query.", trace);
            return true;
        }
        for (IXQEQueryNode filter : filters = query.getDescendantsOfType(1010, false)) {
            Set<IHierarchy> refHierarchies;
            if (filter == parentFilter || !(refHierarchies = ((CogMDXDetailFilter)filter).getReferencedHierarchies()).contains(parameterHierarchy)) continue;
            this.traceNodeCondition(true, "The hierarchy of the parameter is referenced in another detail filter.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The hierarchy of the parameter is not referenced outside of the detail filter.", trace);
        return false;
    }
}

