/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.validation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeAbstractDetailFilter;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.olap.normalization.OrderCogMDXNestNodesByHierarchyAndLevel;
import java.util.ArrayList;
import java.util.List;

public final class ValidateORDetailFilterHier
extends Transformation {
    public static final String PROP_TRANSFORMATION_APPLIED = "ValidateORDetailFilterHierApplied";

    public ValidateORDetailFilterHier() {
        this.mName = "Validate Hierarchy Levels Referenced Within an OR Detail Filter.";
        this.mPassNumbers = new int[]{9};
        this.mTypes = new int[]{1107, 1108};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) throws XQEOlapUnsupportedQueryException {
        TNodeAbstractDetailFilter orDetailFilter = (TNodeAbstractDetailFilter)node;
        MDXHierInfo orHierInfo = orDetailFilter.getMDFHierarchyInfo();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            node.throwInternalError("mdxQuery == null");
        }
        MDXHierInfo projHierHinfo = mdxQuery.getHierarchyInfo();
        orHierInfo.extractHierInfo(projHierHinfo);
        if (orHierInfo.getNumProjectedHierarchies() != 0) {
            List<IHierarchy> nonProjHierarchies = orHierInfo.getProjectedHierarchies();
            ArrayList<String> nonProjHierNames = new ArrayList<String>();
            for (IHierarchy nonProjHierarchy : nonProjHierarchies) {
                nonProjHierNames.add(nonProjHierarchy.getV5UniqueName());
            }
            String nonProjHierList = OrderCogMDXNestNodesByHierarchyAndLevel.generateParenthesisDelimitedList(nonProjHierNames);
            throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedORFilterReferencingNonProjHierarchy, orDetailFilter.getPropertyValue("originalExpression").toString(), nonProjHierList);
        }
        orDetailFilter.setPropertyValue(PROP_TRANSFORMATION_APPLIED, Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        TNodeAbstractDetailFilter orDetailFilter = (TNodeAbstractDetailFilter)node;
        XQETrace trace = environment.getTrace();
        if (orDetailFilter.getPropertyValue(PROP_TRANSFORMATION_APPLIED) != null) {
            this.traceNodeCondition(false, "The detail filter with OR conditons is valid.", trace);
            return false;
        }
        orDetailFilter.throwOnInvalidChildCategories();
        this.traceNodeCondition(true, "The detail filter with OR conditons requires validation.", trace);
        return true;
    }
}

