/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.sort;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXAggregate;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXCrossjoin;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeSort;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.summaryfilter.SFUtil;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.transformation.olap.util.MiscellaneousUtilities;

public class ConvertValueSortItemInNonDetailGroup
extends Transformation {
    public ConvertValueSortItemInNonDetailGroup() {
        this.mName = "Convert a value sort item in a non detail group";
        this.mPassNumbers = new int[]{19};
        this.mTypes = new int[]{1118};
    }

    private void removeTNodeSort(IXQEQueryNode node) {
        for (int idx = 0; idx < node.getNumberChildren(); ++idx) {
            this.removeTNodeSort(node.getChild(idx));
        }
        if (node.getType() == 1117) {
            node.detachChildrenExceptFirst();
            node.extract();
        }
    }

    private AbstractMDXSet crossjoinOppositeEdgeSets(CogMDXAggregate aggr, AbstractMDXSet aggrSet, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)aggr.getAncestorOfType(1002);
        MDXEdge[] edges = mdxQuery.getEdges();
        for (int i = 0; i < edges.length; ++i) {
            MDXHierInfo hierInfo;
            if (aggr.isAncestor(edges[i]) || (hierInfo = edges[i].getHierarchyInfo()).getNumberOfNonMeasureHierarchiesProjected() == 0) continue;
            IXQEQueryNode edgeSet = factory.deepCopyNode(edges[i].getChild(0));
            this.removeTNodeSort(edgeSet);
            if (edgeSet == null) continue;
            if (aggrSet == null) {
                aggrSet = (AbstractMDXSet)edgeSet;
                continue;
            }
            MDXCrossjoin mdxCrossjoin = (MDXCrossjoin)factory.createNode(1030);
            aggrSet.insertParent(mdxCrossjoin);
            mdxCrossjoin.addChild(edgeSet);
            aggrSet = mdxCrossjoin;
        }
        return aggrSet;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        TNodeSort tNode = (TNodeSort)node.getParent();
        AbstractMDXNode valueExpr = (AbstractMDXNode)node.getChild(0);
        if (!valueExpr.isOfCategory(1061)) {
            valueExpr = MDXBuilder.coerceToValueExpression(valueExpr, factory);
        }
        CogMDXAggregate cogMDXAggregate = (CogMDXAggregate)factory.createNode(1012, tNode);
        valueExpr.insertParent(cogMDXAggregate);
        IXQEQueryNode parentGroup = tNode.getAncestorOfType(1027);
        AbstractMDXSet nestedSet = null;
        if (parentGroup.getNumberChildren() == 2) {
            nestedSet = (AbstractMDXSet)factory.deepCopyNode(parentGroup.getChild(1));
            this.removeTNodeSort(nestedSet);
        }
        if ((nestedSet = this.crossjoinOppositeEdgeSets(cogMDXAggregate, nestedSet, environment)) != null) {
            cogMDXAggregate.addChild(nestedSet, 0);
        } else {
            IHierarchy hierarchy = ((CogMDXGroup)parentGroup).getFirstSetHierarchy();
            nestedSet = MDXBuilder.buildMDXSetExpr((IXQENodeFactory)factory, MDXBuilder.buildMDXCurrentMemberExpr(factory, hierarchy));
            cogMDXAggregate.addChild(nestedSet, 0);
        }
        SFUtil.setProjectDetailsOnlyOnCogMDXGroups(nestedSet);
        nestedSet.insertParent(factory.createNode(1139, tNode));
    }

    public static boolean nodeCondition(IXQEQueryNode node, StringBuilder traceMsg) {
        IXQEQueryNode sortItem = node.getChild(0);
        MDXQuery query = (MDXQuery)node.getAncestorOfType(1002);
        if (sortItem.isOfCategory(1060)) {
            if (traceMsg != null) {
                traceMsg.append("sort is on a summary value.");
            }
            return false;
        }
        MDXHierInfo itemHier = ((AbstractMDXNode)sortItem).getHierarchyInfo();
        if (!itemHier.projectsMeasures()) {
            if (traceMsg != null) {
                traceMsg.append("there is no sort item on a measure hierarchy.");
            }
            return false;
        }
        IXQEQueryNode tNodeSort = node.getParent();
        if (tNodeSort.getChild(0).getType() == 1027) {
            if (traceMsg != null) {
                traceMsg.append("sort is on a detail group.");
            }
            return false;
        }
        IXQEQueryNode parentGroup = tNodeSort.getAncestorOfType(1027);
        if (parentGroup == null || parentGroup.getNumberChildren() == 1 && query.isListReport()) {
            if (traceMsg != null) {
                traceMsg.append("can not find nested group.");
            }
            return false;
        }
        boolean foundNonMeasureDetailSetOnOppositeEdge = false;
        if (!query.isListReport()) {
            MDXEdge[] edges;
            for (MDXEdge edge : edges = query.getEdges()) {
                if (node.isAncestor(edge)) continue;
                MDXHierInfo hierInfo = edge.getHierarchyInfo();
                boolean isDetail = MiscellaneousUtilities.hasDetailSet((AbstractMDXSet)edge.getChild(0));
                if (hierInfo.getNumberOfNonMeasureHierarchiesProjected() == 0 || !isDetail) continue;
                foundNonMeasureDetailSetOnOppositeEdge = true;
                break;
            }
        }
        if (parentGroup.getNumberChildren() > 1) {
            AbstractMDXSet nestedSet = (AbstractMDXSet)parentGroup.getChild(1);
            MDXHierInfo nestedHierInfo = nestedSet.getHierarchyInfo();
            if (nestedHierInfo != null && nestedHierInfo.getNumberOfNonMeasureHierarchiesProjected() == 0 && !foundNonMeasureDetailSetOnOppositeEdge) {
                if (traceMsg != null) {
                    traceMsg.append("nested set has only measures.");
                }
                return false;
            }
        } else if (!foundNonMeasureDetailSetOnOppositeEdge) {
            if (traceMsg != null) {
                traceMsg.append("opposite edge set has only measures.");
            }
            return false;
        }
        if (traceMsg != null) {
            traceMsg.append("the sorting measure has to be converted.");
        }
        return true;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        StringBuilder traceMsg = new StringBuilder();
        boolean status = ConvertValueSortItemInNonDetailGroup.nodeCondition(node, traceMsg);
        this.traceNodeCondition(status, traceMsg.toString(), trace);
        return status;
    }
}

