/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.summary;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.CogMDXReportSummary;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSetAliasReference;
import com.cognos.xqe.ast.olap.TNodeApplyHeadSuppression;
import com.cognos.xqe.ast.olap.TNodeHeadCount;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.transformation.olap.util.MiscellaneousUtilities;

public final class ConvertReportSummary
extends Transformation {
    public ConvertReportSummary() {
        this.mName = "Convert Repost Summary to final set expression when context independent.";
        this.mPassNumbers = new int[]{37};
        this.mTypes = new int[]{1080};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        CogMDXReportSummary reportSummary = (CogMDXReportSummary)node;
        AbstractMDXSet projectedSet = (AbstractMDXSet)reportSummary.getDetailExpr();
        MDXEdge edge = (MDXEdge)node.getAncestorOfType(1006);
        boolean suppressOnNonEmpty = edge.applyExcludeEmptyHeadSuppression();
        if (projectedSet != null && (projectedSet.couldResolveToEmptySet(true, false, true) || suppressOnNonEmpty)) {
            MDXSetAliasReference aliasRef;
            TNodeApplyHeadSuppression tNodeApplyHeadSuppression = (TNodeApplyHeadSuppression)nodeFactory.createNode(1083);
            AbstractMDXSet firstChildSet = (AbstractMDXSet)node.getChild(0);
            int numberOfProjectedTuples = firstChildSet.getNumberOfProjectedTuples();
            if (node.getNumberChildren() > 1) {
                MDXHierInfo context = firstChildSet.getContextHierarchyInfo();
                if (firstChildSet.getHierarchyInfo().intersectHierInfo(context).getNumProjectedHierarchies() > 0) {
                    numberOfProjectedTuples = reportSummary.getNumberOfProjectedTuples();
                    node.insertParent(tNodeApplyHeadSuppression);
                } else {
                    firstChildSet.insertParent(tNodeApplyHeadSuppression);
                }
            } else {
                node.insertParent(tNodeApplyHeadSuppression);
            }
            if (numberOfProjectedTuples > 0) {
                numberOfProjectedTuples = numberOfProjectedTuples * 2 - 1;
            }
            TNodeHeadCount tCount = (TNodeHeadCount)nodeFactory.createNode(1182);
            tCount.setConstantValue(numberOfProjectedTuples);
            tNodeApplyHeadSuppression.setTNodeHeadCount(tCount);
            MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
            Integer order = MiscellaneousUtilities.getOrderOfNodesInSubtree(edge, node, projectedSet);
            IXQEQueryNode tNodeUnComp = node.getAncestorOfType(1113);
            boolean unCompSummaryExist = false;
            if (tNodeUnComp != null) {
                boolean bl = unCompSummaryExist = !tNodeUnComp.isAncestor(projectedSet);
            }
            if (unCompSummaryExist) {
                AbstractMDXSet unbalCompDetailSet = (AbstractMDXSet)nodeFactory.deepCopyNode(projectedSet);
                tNodeApplyHeadSuppression.addChild(unbalCompDetailSet);
            } else if (order == 0) {
                AbstractMDXSet set = MDXBuilder.buildEmptySet(nodeFactory, projectedSet);
                tNodeApplyHeadSuppression.addChild(set);
            } else if (order > 0) {
                aliasRef = MDXBuilder.buildMDXSetAlias(nodeFactory, mdxQuery, projectedSet);
                tNodeApplyHeadSuppression.addChild(aliasRef);
            } else if (order < 0) {
                aliasRef = MDXBuilder.buildMDXSetAlias(nodeFactory, mdxQuery, projectedSet);
                IXQEQueryNode aliasDef = projectedSet.getParent();
                aliasDef.getParent().exchangeChildNode(aliasDef, aliasRef);
                tNodeApplyHeadSuppression.addChild(aliasDef);
            }
            if (node.getNumberChildren() == 1) {
                node.extract();
            } else {
                CogMDXGroup group = (CogMDXGroup)nodeFactory.createNode(1027);
                this.findMDXCalcRefReplaceCogMDXSummary(node, group);
            }
        } else if (node.getNumberChildren() == 1) {
            node.extract();
        } else {
            CogMDXGroup group = (CogMDXGroup)nodeFactory.createNode(1027);
            this.findMDXCalcRefReplaceCogMDXSummary(node, group);
        }
    }

    private void findMDXCalcRefReplaceCogMDXSummary(IXQEQueryNode node, CogMDXGroup group) {
        MDXCalculatedMemberReference calcRef = null;
        IXQEQueryNode[] calcs = node.getChild(0).getDescendantsOfType(1013, true);
        if (calcs.length == 0) {
            calcs = node.getChild(1).getDescendantsOfType(1013, true);
        }
        for (IXQEQueryNode calc : calcs) {
            MDXCalculatedMemberReference currCalc = (MDXCalculatedMemberReference)calc;
            if (!currCalc.isReportSummary()) continue;
            calcRef = (MDXCalculatedMemberReference)calc;
        }
        if (calcRef != null) {
            node.exchange(group, true);
        } else {
            node.throwInternalError("calcRef == null");
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        boolean bl = status = node.getChildrenOfCategory(1068).length == 0;
        if (!status) {
            this.traceNodeCondition(status, "tuple children not wrapped in set yet.", trace);
            return status;
        }
        IXQEQueryNode[] summaryExpr = node.getDescendantsOfType(1028, false);
        boolean bl2 = status = summaryExpr.length == 0;
        if (!status) {
            this.traceNodeCondition(status, "The report summary is not ready to be added to the final edge set expression.", trace);
            return status;
        }
        this.traceNodeCondition(status, "The report summary is ready to be added to the final edge set expression...", trace);
        return status;
    }
}

