/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.summary;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.MDXDefaultMember;
import com.cognos.xqe.ast.olap.MDXSummaryFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import java.util.List;

public class ReplaceNoMemberMeasureDefaultMemberWithExplicitMeasureMember
extends Transformation {
    public ReplaceNoMemberMeasureDefaultMemberWithExplicitMeasureMember() {
        this.mName = "Replace NoMember Measure DefaultMember With ExplicitMeasureMember.";
        this.mPassNumbers = new int[]{5};
        this.mTypes = new int[]{1080};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        List<AbstractMDXNode> summaryNodes = ((AbstractMDXNode)node.getChild(0)).getDescendantsOfType(1060, true, false, false, true, true);
        BaseMember measure = ((MDXSummaryFunction)summaryNodes.get(0)).getExplicitMeasureInValueExpression();
        BaseMember newChild = (BaseMember)factory.deepCopyNode(measure);
        IXQEQueryNode defaultMember = node.getChild(1).getFirstDescendantOfTypeOrdered(1077, false);
        defaultMember.exchange(newChild);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (node.getNumberChildren() != 2) {
            this.traceQueryCondition(false, "The node doesn't have two children", trace);
            return false;
        }
        IXQEQueryNode[] dms = node.getChild(1).getDescendantsOfType(1077, false);
        if (dms.length != 1) {
            this.traceQueryCondition(false, "The node does not have one default member at right subtree.", trace);
            return false;
        }
        MDXDefaultMember mdxDefMem = (MDXDefaultMember)dms[0];
        if (!mdxDefMem.getPropertyIsNoMember()) {
            this.traceQueryCondition(false, "The node is not NoMember", trace);
            return false;
        }
        if (!mdxDefMem.getHierarchyInfo().getProjectedHierarchy(0).getDimension().isMeasuresDimension()) {
            this.traceQueryCondition(false, "The node is not a measure", trace);
            return false;
        }
        List<AbstractMDXNode> summaryNodes = ((AbstractMDXNode)node.getChild(0)).getDescendantsOfType(1060, true, false, false, true, true);
        if (summaryNodes.size() == 1 && ((MDXSummaryFunction)summaryNodes.get(0)).hasExplicitMeasureContext()) {
            this.traceNodeCondition(true, "Summary Function has explicit measure.", trace);
            return true;
        }
        return status;
    }
}

