/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.summaryfilter;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXBooleanExpression;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.CogMDXSummaryFilter;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXFilter;
import com.cognos.xqe.ast.olap.MDXMembers;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeApplySummaryFilterToSet;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.summaryfilter.SFUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ApplySummaryFilterNoScopeToSet
extends Transformation {
    public ApplySummaryFilterNoScopeToSet() {
        this.mName = "Apply Summary Filter To Detail Set.";
        this.mPassNumbers = new int[]{17};
        this.mTypes = new int[]{1141};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        TNodeApplySummaryFilterToSet tNode = (TNodeApplySummaryFilterToSet)node;
        XQENodeFactory factory = environment.getNodeFactory();
        IXQEQueryNode edge = node.getAncestorOfType(1006);
        IXQEQueryNode edgeSet = factory.deepCopyNode(edge.getChild(0));
        IXQEQueryNode[] tNodes = edgeSet.getDescendantsOfType(1141, false);
        for (int j = 0; j < tNodes.length; ++j) {
            IXQEQueryNode aTNode = tNodes[j];
            aTNode.detachChildrenExceptFirst();
            aTNode.extract();
        }
        if (((MDXEdge)edge).getHierarchyInfo().getNumberOfNonMeasureHierarchiesProjected() > 0) {
            this.flagTopLevelCogMDXGroupContextIndependent(edgeSet);
            AbstractMDXSet forReportSet = (AbstractMDXSet)edgeSet;
            if (tNode.hasOppositeEdgeSets()) {
                for (int i = 0; i < tNode.getOppositeEdgeSets().length; ++i) {
                    this.flagTopLevelCogMDXGroupContextIndependent(tNode.getOppositeEdgeSets()[i]);
                }
                forReportSet = SFUtil.applyOppositeEdgeTransformation(environment, tNode, forReportSet);
            }
            SFUtil.setProjectDetailsOnlyOnCogMDXGroups(forReportSet);
            Integer summaryFilterId = tNode.getSummaryFilterId();
            CogMDXSummaryFilter cogMDXSummaryFilter = (CogMDXSummaryFilter)factory.getNodeIndex().getNodeByID(summaryFilterId);
            MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
            MDXEdge[] edges = mdxQuery.getEdges();
            boolean copySet = false;
            for (int i = 0; i < edges.length; ++i) {
                MDXHierInfo edgeHierInfo = edges[i].getHierarchyInfo();
                if (edgeHierInfo.getNumberOfNonMeasureHierarchiesProjected() == 0) continue;
                List<CogMDXGroup> cogMDXGroupNodes = this.getTopLevelCogMDXGroupFromEdge(edges[i]);
                Iterator<CogMDXGroup> it = cogMDXGroupNodes.iterator();
                while (it.hasNext()) {
                    AbstractMDXBooleanExpression condition = (AbstractMDXBooleanExpression)factory.deepCopyNode(cogMDXSummaryFilter.getChild(0));
                    CogMDXGroup topCogMDXGroup = it.next();
                    if (copySet) {
                        forReportSet = (AbstractMDXSet)factory.deepCopyNode(forReportSet);
                    }
                    SFUtil.aggrCtxtDepValExprCondOperands(environment, forReportSet, condition, false, null, tNode);
                    copySet = true;
                    MDXFilter mdxFilter = (MDXFilter)factory.createNode(1053, tNode);
                    mdxFilter.setIsMeasureSummaryFilter(Boolean.TRUE);
                    topCogMDXGroup.getChild(0).insertParent(mdxFilter);
                    mdxFilter.addChild(condition);
                }
            }
        } else {
            Integer summaryFilterId = tNode.getSummaryFilterId();
            CogMDXSummaryFilter cogMDXSummaryFilter = (CogMDXSummaryFilter)factory.getNodeIndex().getNodeByID(summaryFilterId);
            AbstractMDXBooleanExpression condition = (AbstractMDXBooleanExpression)factory.deepCopyNode(cogMDXSummaryFilter.getChild(0));
            MDXFilter mdxFilter = (MDXFilter)factory.createNode(1053, edgeSet);
            mdxFilter.setIsMeasureSummaryFilter(Boolean.TRUE);
            edge.getChild(0).insertParent(mdxFilter);
            mdxFilter.addChild(condition);
        }
        environment.enableLockNodeQueryPlanning(1139);
        node.detachChildrenExceptFirst();
        node.extract();
    }

    private void flagTopLevelCogMDXGroupContextIndependent(IXQEQueryNode edgeSet) {
        List<CogMDXGroup> groups = this.getTopLevelCogMDXGroupFromEdge(edgeSet);
        if (groups == null || groups.isEmpty()) {
            edgeSet.throwInternalError("Can not find CogMDXGroup child.");
        }
        for (CogMDXGroup topLevelGroup : groups) {
            topLevelGroup.flagContextIndependent();
            IXQEQueryNode[] membersFunction = topLevelGroup.getDescendantsOfType(1040, true);
            for (int i = 0; i < membersFunction.length; ++i) {
                if (!topLevelGroup.isProjectedDescendant((MDXMembers)membersFunction[i])) continue;
                ((MDXMembers)membersFunction[i]).flagContextIndependent();
            }
        }
    }

    private List<CogMDXGroup> getTopLevelCogMDXGroupFromEdge(IXQEQueryNode edgeSet) {
        ArrayList<CogMDXGroup> topLevelGroups = new ArrayList<CogMDXGroup>();
        IXQEQueryNode mdxSet = null;
        if (edgeSet.getType() == 1039) {
            mdxSet = edgeSet;
        } else if (edgeSet.getChild(0).getType() == 1039) {
            mdxSet = edgeSet.getChild(0);
        }
        if (mdxSet != null) {
            IXQEQueryNode[] groupChildren = mdxSet.getChildrenOfType(1027);
            for (int i = 0; i < groupChildren.length; ++i) {
                topLevelGroups.add((CogMDXGroup)groupChildren[i]);
            }
        }
        if (topLevelGroups.isEmpty()) {
            List<IXQEQueryNode> groups = edgeSet.getDescendantsOfTypeOrdered(1027, true);
            topLevelGroups.add((CogMDXGroup)groups.get(0));
        }
        return topLevelGroups;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        CogMDXGroup parentCogMDXGroup;
        XQENodeFactory factory = environment.getNodeFactory();
        XQETrace trace = environment.getTrace();
        TNodeApplySummaryFilterToSet tNode = (TNodeApplySummaryFilterToSet)node;
        Integer summaryFilterId = tNode.getSummaryFilterId();
        CogMDXSummaryFilter cogMDXSummaryFilter = (CogMDXSummaryFilter)factory.getNodeIndex().getNodeByID(summaryFilterId);
        if (!cogMDXSummaryFilter.getScopedDataItemNames().isEmpty()) {
            this.traceNodeCondition(false, "The CogMDXSummaryFilter for the target TNodeApplySummaryFilterToSet does not have for report scope.", trace);
            return false;
        }
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The child nodes of the target TNodeApplySummaryFilterToSet node are invalid.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null || !cogMDXSummaryFilter.isAncestor(mdxQuery)) {
            cogMDXSummaryFilter.throwInternalError("The target CogMDXSummaryFilter node is not a descendant of an MDXQuery node.");
        }
        IXQEQueryNode[] cogMDXSummaryFilterNodes = mdxQuery.getDescendantsOfType(1011, false);
        for (int i = 0; i < cogMDXSummaryFilterNodes.length; ++i) {
            if (cogMDXSummaryFilterNodes[i].getPropertyValue("SummaryFilterDistributed") == Boolean.TRUE) continue;
            this.traceNodeCondition(false, "The MDXQuery still contains CogMDXSummaryFilter nodes that have not yet been distributed to the MDXQuery.", trace);
            return false;
        }
        if (mdxQuery.getNumberOfEdges() > 1 && SFUtil.getNumEdgesThatProjectDetails(mdxQuery) > 1) {
            if (!tNode.hasOppositeEdgeSets()) {
                this.traceNodeCondition(false, "The query contains multiple edges that project details and these opposite edge detail expressions have not get been copied to the target TNodeApplySummaryFilterToSet node.", trace);
                return false;
            }
            IXQEQueryNode[] tNodes = mdxQuery.getDescendantsOfType(1141, false);
            for (int i = 0; i < tNodes.length; ++i) {
                if (tNodes[i] == node || ((TNodeApplySummaryFilterToSet)tNodes[i]).hasOppositeEdgeSets()) continue;
                this.traceNodeCondition(false, "The query contains multiple edges that project details and there are TNodeApplySummaryFilterToSet nodes in the query that do not yet have copies of these opposite edge detail expressions.", trace);
                return false;
            }
        }
        if ((parentCogMDXGroup = (CogMDXGroup)node.getAncestorOfType(1027)) == null) {
            node.throwInternalError("");
        }
        if (parentCogMDXGroup.getAncestorOfType(1027) != null) {
            this.traceNodeCondition(false, "The summary filter is not at the top CogMDXGroup on the edge.", trace);
            return false;
        }
        if (cogMDXSummaryFilter.getScopedDataItemNames().isEmpty() && cogMDXSummaryFilter.getDefaultScopeName().compareTo("report") == 0) {
            this.traceNodeCondition(true, "The CogMDXSummaryFilter for the target TNodeApplySummaryFilterToSet has for report scope.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The CogMDXSummaryFilter for the target TNodeApplySummaryFilterToSet doesn't have for report scope.", trace);
        return false;
    }
}

