/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.summaryfilter;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXNumericValueFunction;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.CogMDXIn;
import com.cognos.xqe.ast.olap.CogMDXSummaryFilter;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXFilter;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeApplyMemberSummaryFilterToSet;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.application.DFSLApplicationUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class DistributeMemberSummaryFilter
extends Transformation {
    public DistributeMemberSummaryFilter() {
        this.mName = "Set Summary Filter Scope.";
        this.mPassNumbers = new int[]{17};
        this.mTypes = new int[]{1174};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IHierarchy filterHierarchy;
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        MDXEdge[] edges = mdxQuery.getEdges();
        CogMDXIn mdxIn = (CogMDXIn)node.getChild(0);
        ILevel level = null;
        MDXLevelInfo levelInfo = ((AbstractMDXSet)mdxIn.getChild(0)).getLevelInfo();
        if (levelInfo.getHierarchyInfo().getNumProjectedHierarchies() != 1) {
            node.throwInternalError("Error getting");
        }
        if (levelInfo.getNumProjectedLevels(filterHierarchy = levelInfo.getHierarchyInfo().getProjectedHierarchy(0)) == 1) {
            level = levelInfo.getProjectedLevel(filterHierarchy, 0);
        }
        for (int i = 0; i < edges.length; ++i) {
            MDXHierInfo edgeHierInfo = edges[i].getHierarchyInfo();
            if (!edgeHierInfo.projectsHierarchy(filterHierarchy)) continue;
            List<AbstractMDXSet> detailSets = DistributeMemberSummaryFilter.getGroupNestTopMostSets(mdxQuery, filterHierarchy, level);
            Iterator<AbstractMDXSet> it = detailSets.iterator();
            while (it.hasNext()) {
                IXQEQueryNode parentGroupNest = it.next().getAncestorOfTypes(new int[]{1027, 1026});
                String refDataItemName = (String)parentGroupNest.getPropertyValue("refDataItem");
                ((CogMDXSummaryFilter)node).addScopedDateItemName(refDataItemName);
            }
        }
        XQENodeFactory factory = environment.getNodeFactory();
        CogMDXSummaryFilter summaryFilter = (CogMDXSummaryFilter)node;
        List<String> scopedDataItemNames = summaryFilter.getScopedDataItemNames();
        IXQEQueryNode[] cogMDXGroupNodes = mdxQuery.getDescendantsOfType(1027, false);
        HashMap projectedDataItemNameCogMDXGroupListMap = new HashMap();
        for (int j = 0; j < cogMDXGroupNodes.length; ++j) {
            String isDetail = ((CogMDXGroup)cogMDXGroupNodes[j]).getDetailProperty();
            if (isDetail != null && isDetail.equals("false")) continue;
            CogMDXGroup group = (CogMDXGroup)cogMDXGroupNodes[j];
            AbstractMDXNode ancestor = (AbstractMDXNode)group.getAncestorOfTypes(new int[]{1006, 1060, 1087, 1012});
            if (ancestor == null || ancestor.getType() != 1006 && !((AbstractMDXNumericValueFunction)ancestor).isWithinDetailCalc() || !((AbstractMDXNode)ancestor.getChild(0)).isProjectedDescendant(group)) continue;
            String refDataItemName = (String)cogMDXGroupNodes[j].getPropertyValue("refDataItem");
            if (refDataItemName == null || refDataItemName.length() == 0) {
                node.throwInternalError("Missing refDataItem property on a CogMDXGroup node.");
            }
            if (projectedDataItemNameCogMDXGroupListMap.get(refDataItemName) == null) {
                projectedDataItemNameCogMDXGroupListMap.put(refDataItemName, new ArrayList());
            }
            ((ArrayList)projectedDataItemNameCogMDXGroupListMap.get(refDataItemName)).add(cogMDXGroupNodes[j]);
        }
        for (String dataItemName : scopedDataItemNames) {
            ArrayList cogMDXGroupList = (ArrayList)projectedDataItemNameCogMDXGroupListMap.get(dataItemName);
            if (cogMDXGroupList == null) {
                node.throwInternalError("Internal Error.");
            }
            for (CogMDXGroup cogMDXGroup : cogMDXGroupList) {
                cogMDXGroup.throwOnInvalidChildCategories();
                TNodeApplyMemberSummaryFilterToSet tNode = (TNodeApplyMemberSummaryFilterToSet)factory.createNode(1175, summaryFilter);
                tNode.setSummaryFilterId(node.getId());
                IXQEQueryNode targetSet = cogMDXGroup.getChild(0);
                if (targetSet.getType() == 1053 && ((MDXFilter)targetSet).isMeasureSummaryFilter()) {
                    targetSet = (AbstractMDXSet)targetSet.getChild(0);
                }
                targetSet.insertParent(tNode);
            }
        }
        node.setPropertyValue("SummaryFilterDistributed", Boolean.TRUE);
    }

    public static List<AbstractMDXSet> getGroupNestTopMostSets(MDXQuery mdxQuery, IHierarchy hierarchy, ILevel level) {
        ArrayList<AbstractMDXSet> outermostProjectedSetsInHierarchy = new ArrayList<AbstractMDXSet>();
        MDXEdge edge = null;
        MDXEdge[] edges = mdxQuery.getEdges();
        for (int i = 0; i < edges.length; ++i) {
            MDXHierInfo edgeHierInfo = edges[i].getHierarchyInfo();
            if (!edgeHierInfo.projectsHierarchy(hierarchy)) continue;
            edge = edges[i];
            break;
        }
        if (edge != null) {
            int[] types = new int[]{1027, 1026};
            List<IXQEQueryNode> cogMDXGroupNestNodes = edge.getDescendantsOfTypesOrdered(types, false);
            Iterator<IXQEQueryNode> it = cogMDXGroupNestNodes.iterator();
            AbstractMDXSet ancestor = null;
            while (it.hasNext()) {
                AbstractMDXSet targetSet;
                AbstractMDXSet groupNest = (AbstractMDXSet)it.next();
                if (ancestor != null && groupNest.isAncestor(ancestor) || groupNest.getType() == 1027 && "false".equals(((CogMDXGroup)groupNest).getDetailProperty()) || !(targetSet = (AbstractMDXSet)groupNest.getChild(0)).getHierarchyInfo().projectsHierarchy(hierarchy)) continue;
                MDXLevelInfo levelInfo = groupNest.getLevelInfo();
                levelInfo.removeCalculationLevels(hierarchy);
                if (levelInfo.getNumProjectedLevels(hierarchy) == 0 || DFSLApplicationUtil.isSetANoMemberOnly(targetSet)) continue;
                outermostProjectedSetsInHierarchy.add(targetSet);
                if (levelInfo.getNumProjectedLevels(hierarchy) == 1 && levelInfo.getProjectedLevel(hierarchy, 0) == level) {
                    ancestor = groupNest;
                    continue;
                }
                ancestor = null;
            }
        }
        return outermostProjectedSetsInHierarchy;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] cogMDXSummaryFilterNodes;
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue("SummaryFilterDistributed") == Boolean.TRUE) {
            this.traceNodeCondition(false, "The summary filter has already been distributed.", trace);
            return false;
        }
        CogMDXSummaryFilter summaryFilter = (CogMDXSummaryFilter)node;
        List<String> scopedDataItemNames = summaryFilter.getScopedDataItemNames();
        if (scopedDataItemNames.size() > 0) {
            node.throwInternalError("The target CogMDXSummaryFilter node has a scope defined.");
        }
        node.throwOnInvalidChildCategories();
        CogMDXIn mdxIn = (CogMDXIn)summaryFilter.getChild(0);
        mdxIn.throwOnInvalidChildCategories();
        IHierarchy filterHierarchy = ((AbstractMDXSet)mdxIn.getChild(0)).getHierarchyInfo().getProjectedHierarchy(0);
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        MDXEdge[] edges = mdxQuery.getEdges();
        boolean queryProjectsNonMeasureHierarchy = false;
        for (int i = 0; i < edges.length; ++i) {
            String refDataItemName;
            IXQEQueryNode[] edgeHierInfo = edges[i].getHierarchyInfo();
            if (edgeHierInfo.getNumberOfNonMeasureHierarchiesProjected() == 0) continue;
            queryProjectsNonMeasureHierarchy = true;
            if (!edgeHierInfo.projectsHierarchy(filterHierarchy)) continue;
            List<AbstractMDXSet> detailSets = DistributeMemberSummaryFilter.getGroupNestTopMostSets(mdxQuery, filterHierarchy, null);
            if (detailSets.isEmpty()) {
                this.traceNodeCondition(false, "The MDXQuery do not project any sets in hierarchy " + filterHierarchy.getUniqueName(), trace);
                return false;
            }
            IXQEQueryNode parentGroupNest = detailSets.get(0).getAncestorOfTypes(new int[]{1027, 1026});
            if (parentGroupNest == null) {
                node.throwInternalError("Unabled to locate CogMDXGroup/Nest parent for detail set.");
            }
            if ((refDataItemName = (String)parentGroupNest.getPropertyValue("refDataItem")) != null && refDataItemName.length() != 0) continue;
            this.traceNodeCondition(false, "The refDataItem property has not been set on the detail CogMDXGroup/Nest nodes that project hierarchy " + filterHierarchy.getUniqueName(), trace);
            return false;
        }
        if (!queryProjectsNonMeasureHierarchy) {
            this.traceNodeCondition(false, "The edges of the MDXQuery do not project any non-Measure hierarchies.", trace);
            return false;
        }
        if (summaryFilter.getDefaultScopeName().compareTo("detail") != 0) {
            this.traceNodeCondition(false, "The target CogMDXSummaryFilter node does not have for_detail scope. The default scope is for_report.", trace);
            return false;
        }
        for (IXQEQueryNode memberSF : cogMDXSummaryFilterNodes = mdxQuery.getDescendantsOfType(1011, false)) {
            if (memberSF.getPropertyValue("SummaryFilterDistributed") == Boolean.TRUE) continue;
            this.traceNodeCondition(false, "The MDXQuery still contains measure Summary Filter nodes that have not yet been distributed to the MDXQuery.", trace);
            return false;
        }
        IXQEQueryNode[] applySummaryFilterNodes = mdxQuery.getDescendantsOfType(1141, false);
        if (applySummaryFilterNodes.length > 0) {
            this.traceNodeCondition(false, "The MDXQuery still contains measure summary filter nodes that have not yet been applied to the MDXQuery.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The transformation can be applied to the target node.", trace);
        return true;
    }
}

