/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.summaryfilter;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXCount;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSummaryFunction;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.summaryfilter.SFUtil;
import com.cognos.xqe.transformation.olap.util.NodeConditions.IsProjectedDescendant;
import java.util.ArrayList;
import java.util.List;

public class HideSummaryFilterMeasureFromCalculation
extends Transformation {
    public static final String PROP_BOOLEAN_SUMMARY_FILTER_HIDDEN = "summaryFilterHidden";

    public HideSummaryFilterMeasureFromCalculation() {
        this.mName = "Hide Summary Filter Measure From Calculation";
        this.mPassNumbers = new int[]{23};
        this.mTypes = new int[]{1013};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        MDXEdge[] edges = mdxQuery.getEdges();
        ArrayList<MDXCalculatedMemberReference> measures = new ArrayList<MDXCalculatedMemberReference>();
        for (MDXEdge edge : edges) {
            ArrayList<IXQEQueryNode> calcRefs = new ArrayList<IXQEQueryNode>();
            IsProjectedDescendant isProjCalcRef = new IsProjectedDescendant(edge);
            int[] nodeTypes = new int[]{1013};
            isProjCalcRef.setNodeTypes(nodeTypes);
            edge.getDescendantsForCondition(calcRefs, isProjCalcRef, false);
            for (IXQEQueryNode calcRef : calcRefs) {
                if (!SFUtil.isPostSummaryFilterMeasure(calcRef)) continue;
                measures.add((MDXCalculatedMemberReference)calcRef);
            }
        }
        MDXCalculatedMemberReference targetRef = (MDXCalculatedMemberReference)node;
        AbstractMDXNode definition = (AbstractMDXNode)targetRef.getDefinition().getChild(0);
        for (MDXCalculatedMemberReference next : measures) {
            if (next.getSolveOrder() > ((MDXCalculatedMemberReference)node).getSolveOrder()) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedSummaryFilterAndLowerSolveOrderCalc);
            }
            Object originalSetting = next.getPropertyValue("copyDefinition");
            next.setPropertyValue("copyDefinition", false);
            IXQEQueryNode copyNext = factory.copyNode(next);
            if (originalSetting == null) {
                next.removeProperty("copyDefinition");
            } else {
                next.setPropertyValue("copyDefinition", originalSetting);
            }
            AbstractMDXMember measure = SFUtil.getPreSummaryFilterMeasureFromPostSummaryFilterMeasureExpression(next);
            AbstractMDXNode copyDefinition = (AbstractMDXNode)factory.deepCopyNode(definition);
            IXQEQueryNode tNodeIfMember = factory.createNode(1120);
            definition.insertParent(tNodeIfMember);
            tNodeIfMember.addChild(copyDefinition, 0);
            tNodeIfMember.addChild(copyNext, 0);
            List<IXQEQueryNode> summaryFunctions = copyDefinition.getDescendantsOfCategory(1060, false);
            for (IXQEQueryNode summaryFn : summaryFunctions) {
                MDXSummaryFunction mdxSummaryFn = (MDXSummaryFunction)summaryFn;
                if (!mdxSummaryFn.isWithinDetailCalc() || !mdxSummaryFn.isContextDependent(mdxQuery.getMeasuresHierarchy())) continue;
                next.setCopyDefinition(false);
                mdxSummaryFn.addMemberToContext(factory, next, true);
            }
            copyDefinition.addMemberToContext(factory, measure, true);
        }
        node.setPropertyValue(PROP_BOOLEAN_SUMMARY_FILTER_HIDDEN, Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXEdge[] edges;
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue(PROP_BOOLEAN_SUMMARY_FILTER_HIDDEN) == Boolean.TRUE) {
            this.traceNodeCondition(false, "Transformation already applied.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            this.traceNodeCondition(false, "There is no MDXQuery above the node.", trace);
            return false;
        }
        IXQEQueryNode[] tnodes = mdxQuery.getDescendantsOfType(1173, false);
        if (tnodes.length > 0) {
            this.traceNodeCondition(false, "The MDXQuery contains a descendant TNodeApplySummaryFilterToProjectedMeasure node.", trace);
            return false;
        }
        MDXCalculatedMemberReference targetRef = (MDXCalculatedMemberReference)node;
        AbstractMDXNode definition = (AbstractMDXNode)targetRef.getDefinition().getChild(0);
        if (!definition.isContextDependent(mdxQuery.getMeasuresHierarchy())) {
            this.traceNodeCondition(false, "The definition of the target node is not context dependent on the measures hierarchy.", trace);
            return false;
        }
        if (!mdxQuery.isProjectedDescendant((AbstractMDXNode)node)) {
            this.traceNodeCondition(false, "The target node is not projected on an edge.", trace);
            return false;
        }
        if (definition.isOfCategory(1060) && ((MDXSummaryFunction)definition).isWithinDetailCalc()) {
            this.traceNodeCondition(false, "The target node is a within detail calculation.", trace);
            return false;
        }
        if (definition.isOfCategory(1087) && ((MDXCount)definition).isWithinDetailCalc()) {
            this.traceNodeCondition(false, "The target node is a within detail calculation. ", trace);
            return false;
        }
        for (MDXEdge edge : edges = mdxQuery.getEdges()) {
            ArrayList<IXQEQueryNode> calcRefs = new ArrayList<IXQEQueryNode>();
            IsProjectedDescendant isProjCalcRef = new IsProjectedDescendant(edge);
            int[] nodeTypes = new int[]{1013};
            isProjCalcRef.setNodeTypes(nodeTypes);
            edge.getDescendantsForCondition(calcRefs, isProjCalcRef, false);
            for (IXQEQueryNode calcRef : calcRefs) {
                if (!SFUtil.isPostSummaryFilterMeasure(calcRef)) continue;
                this.traceNodeCondition(true, "The MDXQuery contains a post summary filter measure.", trace);
                return true;
            }
        }
        this.traceNodeCondition(false, "Summary filter can be applied to projected measures in query.", trace);
        return false;
    }
}

