/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.summaryfilter;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXBooleanExpression;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.AbstractMDXValueExpression;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.CogMDXSummaryFilter;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXComparisonOperator;
import com.cognos.xqe.ast.olap.MDXCount;
import com.cognos.xqe.ast.olap.MDXCrossjoin;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXNumericIIF;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSummaryFunction;
import com.cognos.xqe.ast.olap.MDXTuple;
import com.cognos.xqe.ast.olap.TNodeApplySummaryFilterToProjectedMeasure;
import com.cognos.xqe.ast.olap.TNodeApplySummaryFilterToSet;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.application.DFSLAggrUtil;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.transformation.olap.util.SolveOrderUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public abstract class SFUtil {
    public static final String SUMMARY_FILTER_CONDITION = "summaryFilterCondition";
    public static final String POST_SUMMARY_FILTER_MEASURE = "postSummaryFilterMeasure";
    public static final String PRE_SUMMARY_FILTER_MEASURE = "preSummaryFilterMeasure";
    private static final String INVALID_POST_SUMMARY_FILTER_MEASURE = "Invalid Post Summary Filter Measure Expression.";
    public static final String PROP_DISTRIBUTED = "SummaryFilterDistributed";

    private SFUtil() {
    }

    public static int getNumEdgesThatProjectDetails(MDXQuery mdxQuery) {
        int result = 0;
        MDXEdge[] edges = mdxQuery.getEdges();
        for (int i = 0; i < edges.length; ++i) {
            AbstractMDXSet[] detailSets = SFUtil.getProjectedDetails(edges[i]);
            if (detailSets.length <= 0) continue;
            ++result;
        }
        return result;
    }

    public static AbstractMDXSet[] getProjectedDetails(MDXEdge mdxEdge) {
        MDXHierInfo edgeHierInfo = mdxEdge.getHierarchyInfo();
        if (edgeHierInfo.getNumberOfNonMeasureHierarchiesProjected() == 0) {
            return new AbstractMDXSet[0];
        }
        AbstractMDXSet[] detailSets = null;
        IHierarchy innermostNonMeasHierOnEdge = null;
        for (int j = edgeHierInfo.getNumProjectedHierarchies() - 1; j >= 0; --j) {
            if (edgeHierInfo.getProjectedHierarchy(j).getDimension().isMeasuresDimension() || (detailSets = DFSLAggrUtil.getGroupNestDetailSets(mdxEdge, innermostNonMeasHierOnEdge = edgeHierInfo.getProjectedHierarchy(j))).length == 0) continue;
            return detailSets;
        }
        return new AbstractMDXSet[0];
    }

    public static void aggrCtxtDepValExprCondOperands(PlanningEnvironment environment, AbstractMDXSet set, AbstractMDXBooleanExpression condition, boolean applyLockOnRemoveNonDetailSets, AbstractMDXSet unbalancedSet, TNodeApplySummaryFilterToSet tNode) {
        XQENodeFactory factory = environment.getNodeFactory();
        boolean enableLockOnRemoveNonDetailSets = true;
        List<AbstractMDXValueExpression> valueExprOperands = condition.getContextDependentValueExpressionConditionOperands();
        boolean copySet = false;
        boolean copyUnbalancedSet = false;
        for (AbstractMDXValueExpression valueExpr : valueExprOperands) {
            IXQEQueryNode cogMDXAggregate = factory.createNode(1012, tNode);
            valueExpr.insertParent(cogMDXAggregate);
            if (!copySet) {
                cogMDXAggregate.addChild(set, 0);
                copySet = true;
            } else {
                cogMDXAggregate.addChild(factory.deepCopyNode(set), 0);
            }
            cogMDXAggregate.getChild(0).insertParent(factory.createNode(1139, tNode));
            if (applyLockOnRemoveNonDetailSets && enableLockOnRemoveNonDetailSets) {
                environment.enableLockNodeQueryPlanning(1139);
                enableLockOnRemoveNonDetailSets = false;
            }
            if (unbalancedSet == null) continue;
            IXQEQueryNode aggrParent = cogMDXAggregate.getParent();
            int position = aggrParent.getPositionOfChild(cogMDXAggregate);
            MDXNumericIIF mdxNumericIIF = (MDXNumericIIF)factory.createNode(1085, tNode);
            MDXCount mdxCount = (MDXCount)factory.createNode(1087);
            mdxCount.addChild(factory.deepCopyNode(set));
            MDXComparisonOperator gtExpr = MDXBuilder.buildMDXComparisonExpr(factory, 3, mdxCount, MDXBuilder.buildMDXNumericConstant((IXQENodeFactory)factory, 0));
            mdxNumericIIF.addChild(gtExpr);
            IXQEQueryNode unbalancedAggregate = factory.createNode(1012, tNode);
            if (!copyUnbalancedSet) {
                unbalancedAggregate.addChild(unbalancedSet, 0);
                copyUnbalancedSet = true;
            } else {
                unbalancedAggregate.addChild(factory.deepCopyNode(unbalancedSet), 0);
            }
            mdxNumericIIF.addChild(cogMDXAggregate.detach());
            mdxNumericIIF.addChild(unbalancedAggregate);
            aggrParent.addChild(mdxNumericIIF, position);
        }
    }

    public static void addCtxtForCtxtDepValExprCondOperands(IXQENodeFactory factory, MDXQuery mdxQuery, AbstractMDXBooleanExpression condition, List<MDXLevelInfo> contextLevels) {
        if (contextLevels.isEmpty()) {
            return;
        }
        List<AbstractMDXValueExpression> valueExprOperands = condition.getContextDependentValueExpressionConditionOperands();
        Iterator<AbstractMDXValueExpression> it = valueExprOperands.iterator();
        while (it.hasNext()) {
            MDXTuple mdxTuple = null;
            AbstractMDXValueExpression valueExpr = it.next();
            if (valueExpr.getType() == 1059 && valueExpr.getChild(0).getType() == 1069) {
                mdxTuple = (MDXTuple)valueExpr.getChild(0);
            } else {
                mdxTuple = (MDXTuple)factory.createNode(1069);
                valueExpr.exchange(mdxTuple, false);
                mdxTuple.insertParent(factory.createNode(1059));
                MDXCalculatedMemberReference cm = MDXBuilder.buildMDXCalculatedMemberReference(factory, mdxQuery, mdxQuery.getMeasuresHierarchy(), "_SF", valueExpr, SolveOrderUtil.getCubeCalcSolveOrder());
                mdxTuple.addChild(cm);
            }
            for (MDXLevelInfo contextLevel : contextLevels) {
                IHierarchy contextHierarchy = contextLevel.getHierarchyInfo().getProjectedHierarchy(0);
                mdxTuple.addChild(MDXBuilder.buildMDXCurrentMemberExpr(factory, contextHierarchy, contextLevel.getHighestProjectedLevel(contextHierarchy)));
            }
        }
    }

    public static void setProjectDetailsOnlyOnCogMDXGroups(AbstractMDXSet set) {
        IXQEQueryNode[] cogMDXGroupNodes = set.getDescendantsOfType(1027, true);
        for (int i = 0; i < cogMDXGroupNodes.length; ++i) {
            CogMDXGroup cogMDXGroup = (CogMDXGroup)cogMDXGroupNodes[i];
            if (!set.isProjectedDescendant(cogMDXGroup)) continue;
            cogMDXGroup.setProjectDetailsOnly();
        }
    }

    public static AbstractMDXSet removeSetFromAncestorLevels(AbstractMDXSet aggrSet, TNodeApplySummaryFilterToSet tNode) {
        IXQEQueryNode[] groups = aggrSet.getDescendantsOfType(1027, true);
        MDXLevelInfo scopedItemLevelInfo = ((AbstractMDXSet)tNode.getChild(0)).getLevelInfo();
        IHierarchy scopedItemHier = scopedItemLevelInfo.getHierarchyInfo().getProjectedHierarchy(0);
        scopedItemLevelInfo.removeCalculationLevels(scopedItemHier);
        for (IXQEQueryNode group : Arrays.asList(groups)) {
            CogMDXGroup aGroup = (CogMDXGroup)group;
            MDXLevelInfo groupLeveInfo = ((AbstractMDXSet)aGroup.getChild(0)).getLevelInfo();
            groupLeveInfo.removeCalculationLevels(scopedItemHier);
            if (!groupLeveInfo.getHierarchyInfo().projectsHierarchy(scopedItemHier) || groupLeveInfo.getNumProjectedLevels(scopedItemHier) <= 0 || groupLeveInfo.getHighestProjectedLevel(scopedItemHier).getIndex() >= scopedItemLevelInfo.getLowestProjectedLevel(scopedItemHier).getIndex()) continue;
            aGroup.detachChild(0);
            if (aGroup.getParent() != null) {
                aGroup.extract();
                continue;
            }
            if (aGroup.getNumberChildren() > 0) {
                aggrSet = (AbstractMDXSet)aGroup.getChild(0).detach();
                continue;
            }
            aggrSet = null;
        }
        if (aggrSet != null && aggrSet.getNumberChildren() > 0) {
            return aggrSet;
        }
        return null;
    }

    public static AbstractMDXSet applyOppositeEdgeTransformation(PlanningEnvironment environment, TNodeApplySummaryFilterToSet tNode, AbstractMDXSet aggrSet) {
        XQENodeFactory factory = environment.getNodeFactory();
        AbstractMDXSet[] oppositeEdgeSets = tNode.getOppositeEdgeSets();
        for (int i = 0; i < oppositeEdgeSets.length; ++i) {
            AbstractMDXSet oppositeEdgeSet = (AbstractMDXSet)factory.deepCopyNode(oppositeEdgeSets[i]);
            if (aggrSet == null) {
                aggrSet = oppositeEdgeSet;
                continue;
            }
            MDXCrossjoin mdxCrossjoin = (MDXCrossjoin)factory.createNode(1030);
            mdxCrossjoin.addChild(aggrSet);
            aggrSet = mdxCrossjoin;
            mdxCrossjoin.addChild(oppositeEdgeSet);
        }
        return aggrSet;
    }

    public static void replaceProjectedBaseMeasureWithPostSummaryFilterCalculatedMeasure(BaseMember baseMeasure, MDXCalculatedMemberReference calculatedMeasure, IXQENodeFactory factory) {
        calculatedMeasure.getDefinition().setPropertyValue("v5Caption", baseMeasure.getMember().getCaptionValue().getString());
        calculatedMeasure.getDefinition().setPropertyValue("v5Name", baseMeasure.getMember().getV5UniqueName());
        calculatedMeasure.setRollupAggregate(baseMeasure.getRollupAggregate());
        baseMeasure.exchange(calculatedMeasure, true);
    }

    protected static void flagApplySummaryFilterToProjectedMeasures(IXQENodeFactory factory, MDXQuery mdxQuery, Integer summaryFilterID, MDXLevelInfo scopedLevel, AbstractMDXBooleanExpression sfCondition) {
        sfCondition.setPropertyValue(SUMMARY_FILTER_CONDITION, summaryFilterID);
        List<AbstractMDXMember> measures = mdxQuery.collectMeasures();
        for (AbstractMDXMember measure : measures) {
            MDXTuple mdxTuple;
            IXQEQueryNode value;
            CogMDXSummaryFilter cogMDXSummaryFilter;
            MDXEdge edge = (MDXEdge)measure.getAncestorOfType(1006);
            if (edge == null || !edge.isProjectedDescendant(measure)) {
                boolean isWithinDetailSummary = false;
                if (((AbstractMDXNode)measure.getParent()).isValueExpressionOperand()) {
                    IXQEQueryNode summaryFn = measure.getParent().getParent().getParent();
                    if (summaryFn.isOfCategory(1060) && ((MDXSummaryFunction)summaryFn).isWithinDetailCalc()) {
                        isWithinDetailSummary = true;
                    }
                    if (summaryFn.isOfCategory(1087) && ((MDXCount)summaryFn).isWithinDetailCalc()) {
                        isWithinDetailSummary = true;
                    }
                }
                if (!isWithinDetailSummary) continue;
            }
            if ((cogMDXSummaryFilter = (CogMDXSummaryFilter)factory.getNodeIndex().getNodeByID(summaryFilterID)) == null) {
                mdxQuery.throwInternalError("Unable to find summary filter id:" + summaryFilterID);
            }
            if (cogMDXSummaryFilter.getChild(0).getType() == 1109 && cogMDXSummaryFilter.getChild(0).getChild(0).getType() == 1104 && (value = cogMDXSummaryFilter.getChild(0).getChild(0).getChild(0)).getType() == 1059 && value.getNumberChildren() == 1 && value.getChild(0).getType() == 1069 && (mdxTuple = (MDXTuple)value.getChild(0)).getNumberChildren() == 1 && measure.isSameExpression(mdxTuple.getChild(0), false)) continue;
            TNodeApplySummaryFilterToProjectedMeasure tnodeApplySFToMeasure = null;
            tnodeApplySFToMeasure = (TNodeApplySummaryFilterToProjectedMeasure)measure.getAncestorOfType(1173);
            if (tnodeApplySFToMeasure == null) {
                tnodeApplySFToMeasure = (TNodeApplySummaryFilterToProjectedMeasure)factory.createNode(1173);
                measure.insertParent(tnodeApplySFToMeasure);
            }
            tnodeApplySFToMeasure.addSummaryFilterID(summaryFilterID, scopedLevel);
        }
    }

    public static AbstractMDXBooleanExpression buildSingleSummaryFilterConditionExpression(IXQENodeFactory factory, MDXQuery mdxQuery, TNodeApplySummaryFilterToProjectedMeasure tnode) {
        List<IXQEQueryNode> conditions = mdxQuery.getDescendantsOfCategory(1071, true);
        ArrayList<AbstractMDXBooleanExpression> sfConditionList = new ArrayList<AbstractMDXBooleanExpression>();
        block0: for (Integer sfID : tnode.getSummaryFilterIDs().keySet()) {
            for (IXQEQueryNode conditionExpr : conditions) {
                if (!SFUtil.isMatchingSummaryFilterCondition((AbstractMDXBooleanExpression)conditionExpr, sfID)) continue;
                AbstractMDXBooleanExpression aCondition = (AbstractMDXBooleanExpression)factory.deepCopyNode(conditionExpr);
                SFUtil.addCtxtForCtxtDepValExprCondOperands(factory, mdxQuery, aCondition, (List<MDXLevelInfo>)tnode.getSummaryFilterIDs().get(sfID));
                sfConditionList.add(aCondition);
                continue block0;
            }
        }
        if (sfConditionList.isEmpty()) {
            tnode.throwInternalError("Can not find summary filte condition in the query.");
        }
        AbstractMDXBooleanExpression result = null;
        Iterator it = sfConditionList.iterator();
        AbstractMDXBooleanExpression aCondition = (AbstractMDXBooleanExpression)it.next();
        aCondition.removeProperty(SUMMARY_FILTER_CONDITION);
        result = aCondition;
        while (it.hasNext()) {
            aCondition = (AbstractMDXBooleanExpression)it.next();
            aCondition.removeProperty(SUMMARY_FILTER_CONDITION);
            result = MDXBuilder.buildMDXAndExpr(factory, result, aCondition);
        }
        result.setPropertyValue(SUMMARY_FILTER_CONDITION, -1);
        return result;
    }

    public static boolean isMatchingSummaryFilterCondition(AbstractMDXBooleanExpression node, Integer summaryFilterID) {
        Integer sfID = (Integer)node.getPropertyValue(SUMMARY_FILTER_CONDITION);
        return sfID != null && sfID.equals(summaryFilterID);
    }

    public static boolean isSummaryFilterCondition(AbstractMDXBooleanExpression node) {
        Integer sfID = (Integer)node.getPropertyValue(SUMMARY_FILTER_CONDITION);
        return sfID != null;
    }

    public static void setPostSummaryFilterMeasureFlag(IXQEQueryNode node) {
        if (node.getType() == 1013) {
            ((MDXCalculatedMemberReference)node).getDefinition().setPropertyValue(POST_SUMMARY_FILTER_MEASURE, Boolean.TRUE);
        } else {
            node.setPropertyValue(POST_SUMMARY_FILTER_MEASURE, Boolean.TRUE);
        }
    }

    public static boolean isPostSummaryFilterMeasure(IXQEQueryNode node) {
        Boolean result = null;
        result = node.getType() == 1013 ? (Boolean)((MDXCalculatedMemberReference)node).getDefinition().getPropertyValue(POST_SUMMARY_FILTER_MEASURE) : (Boolean)node.getPropertyValue(POST_SUMMARY_FILTER_MEASURE);
        return result != null && Boolean.TRUE == result;
    }

    public static void setPreSummaryFilterMeasureFlag(IXQEQueryNode node) {
        if (node.getType() == 1013) {
            ((MDXCalculatedMemberReference)node).getDefinition().setPropertyValue(PRE_SUMMARY_FILTER_MEASURE, Boolean.TRUE);
        } else {
            node.setPropertyValue(PRE_SUMMARY_FILTER_MEASURE, Boolean.TRUE);
        }
    }

    public static boolean isPreSummaryFilterMeasure(IXQEQueryNode node) {
        Boolean result = null;
        result = node.getType() == 1013 ? (Boolean)((MDXCalculatedMemberReference)node).getDefinition().getPropertyValue(PRE_SUMMARY_FILTER_MEASURE) : (Boolean)node.getPropertyValue(PRE_SUMMARY_FILTER_MEASURE);
        return result != null && Boolean.TRUE == result;
    }

    public static AbstractMDXBooleanExpression getSummaryFilterConditionFromPostSummaryFilterMeasure(AbstractMDXMember node) {
        List<IXQEQueryNode> conditions = null;
        conditions = node.getType() == 1013 ? ((MDXCalculatedMemberReference)node).getDefinition().getDescendantsOfCategory(1071, true) : node.getDescendantsOfCategory(1071, true);
        ArrayList<IXQEQueryNode> result = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode aCondition : conditions) {
            if (!SFUtil.isSummaryFilterCondition((AbstractMDXBooleanExpression)aCondition)) continue;
            result.add(aCondition);
        }
        if (result.size() != 1) {
            node.throwInternalError(INVALID_POST_SUMMARY_FILTER_MEASURE);
        }
        return (AbstractMDXBooleanExpression)result.get(0);
    }

    public static AbstractMDXMember getPreSummaryFilterMeasureFromPostSummaryFilterMeasureExpression(AbstractMDXMember node) {
        List<IXQEQueryNode> members = null;
        members = node.getType() == 1013 ? ((MDXCalculatedMemberReference)node).getDefinition().getDescendantsOfCategoryOrdered(1022, true) : node.getDescendantsOfCategoryOrdered(1022, true);
        ArrayList<IXQEQueryNode> result = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode aMember : members) {
            if (!SFUtil.isPreSummaryFilterMeasure(aMember) || !result.isEmpty() && ((IXQEQueryNode)result.get(0)).isSameExpression(aMember, false)) continue;
            result.add(aMember);
        }
        if (result.size() != 1) {
            node.throwInternalError(INVALID_POST_SUMMARY_FILTER_MEASURE);
        }
        return (AbstractMDXMember)result.get(0);
    }
}

