/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.summaryfilter;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.CogMDXReportSummaryExpr;
import com.cognos.xqe.ast.olap.CogMDXSummaryFilter;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import java.util.ArrayList;
import java.util.List;

public final class ValidateSummaryFilterScope
extends Transformation {
    public static final String PROP_APPLIED = "ValidateSummaryFilterScopeApplied";

    public ValidateSummaryFilterScope() {
        this.mName = "Validate Summary Filter Scope.";
        this.mPassNumbers = new int[]{17};
        this.mTypes = new int[]{1011};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        StringBuilder sb;
        CogMDXSummaryFilter summaryFilter = (CogMDXSummaryFilter)node;
        boolean validationRequired = summaryFilter.getBooleanPropertyValue("fromUpgradedVDF") != Boolean.TRUE;
        ArrayList<String> scopedDataItemNames = new ArrayList<String>();
        ArrayList<String> nonGroupedDataItemNames = new ArrayList<String>();
        scopedDataItemNames.addAll(summaryFilter.getScopedDataItemNames());
        RSAPIDataset dataset = (RSAPIDataset)summaryFilter.getAncestorOfType(401005);
        boolean scopeToDetails = summaryFilter.getDefaultScopeName().equals("detail");
        IXQEQueryNode mdxQuery = node.getAncestorOfType(1002);
        IXQEQueryNode[] mdxEdges = mdxQuery.getChildrenOfType(1006);
        int maxNumberOfScopableEdges = mdxEdges.length;
        for (IXQEQueryNode mdxEdge : mdxEdges) {
            IHierarchy hierarchy;
            MDXHierInfo mdxHierInfo = ((MDXEdge)mdxEdge).getHierarchyInfo();
            if (mdxHierInfo.getNumProjectedHierarchies() == 0) {
                --maxNumberOfScopableEdges;
                continue;
            }
            if (mdxHierInfo.getNumProjectedHierarchies() != 1 || !(hierarchy = mdxHierInfo.getProjectedHierarchy(0)).getDimension().isMeasuresDimension()) continue;
            --maxNumberOfScopableEdges;
        }
        int numberOfEdgesWithScope = 0;
        for (RSAPIEdge edge : dataset.getEdges()) {
            ArrayList<String> scopesOnEdge = new ArrayList<String>();
            block2: for (RSAPIEdgeRowset rowset : edge.getRowsets()) {
                RSAPIDataItem refDataItem = rowset.getRefDataItem();
                if (refDataItem != null) {
                    String refDataItemName = refDataItem.getName();
                    boolean foundIt = scopedDataItemNames.contains(refDataItemName);
                    if (!foundIt) {
                        for (RSAPIDataItem groupedDataItem : rowset.getDataItems()) {
                            if (!scopedDataItemNames.contains(groupedDataItem.getName())) continue;
                            if (groupedDataItem.getPropertyName() != null) {
                                summaryFilter.replaceScopedDateItemName(groupedDataItem.getName(), refDataItemName);
                                refDataItem = groupedDataItem;
                                foundIt = true;
                                break;
                            }
                            nonGroupedDataItemNames.add(groupedDataItem.getName());
                            break;
                        }
                    }
                    if (!foundIt) continue;
                    if (validationRequired) {
                        this.validateScopeDataItem(node, dataset, refDataItem);
                    }
                    scopedDataItemNames.remove(refDataItemName);
                    nonGroupedDataItemNames.remove(refDataItemName);
                    scopesOnEdge.add(refDataItemName);
                    continue;
                }
                for (RSAPIDataItem nonGroupedDataItem : rowset.getDataItems()) {
                    if (!scopedDataItemNames.contains(nonGroupedDataItem.getName())) continue;
                    nonGroupedDataItemNames.add(nonGroupedDataItem.getName());
                    continue block2;
                }
            }
            if (validationRequired && scopesOnEdge.size() > 1) {
                StringBuilder sb2 = new StringBuilder();
                XQEMessage.appendQuotedItemList(sb2, scopesOnEdge);
                XQEMessage message = new XQEMessage(XQEMessageKeys.PLN_UnsuppMultSummFilterScopesOnSingleEdge, sb2.toString(), node);
                throw new XQEOlapUnsupportedQueryException(message);
            }
            if (scopesOnEdge.size() <= 0 || numberOfEdgesWithScope >= maxNumberOfScopableEdges) continue;
            ++numberOfEdgesWithScope;
        }
        if (nonGroupedDataItemNames.size() > 0) {
            if (scopeToDetails) {
                for (String nonGroupedDataItemName : nonGroupedDataItemNames) {
                    scopedDataItemNames.remove(nonGroupedDataItemName);
                }
            } else if (validationRequired) {
                sb = new StringBuilder();
                XQEMessage.appendQuotedItemList(sb, nonGroupedDataItemNames);
                XQEMessage message = new XQEMessage(XQEMessageKeys.PLN_UnsupportedSummaryFilterScopeOnNonGroupedItem, sb.toString(), node);
                throw new XQEOlapUnsupportedQueryException(message);
            }
        }
        if (validationRequired && scopedDataItemNames.size() > 0) {
            sb = new StringBuilder();
            XQEMessage.appendQuotedItemList(sb, scopedDataItemNames);
            XQEMessage message = new XQEMessage(XQEMessageKeys.PLN_UnsuppSummFilterScopesNotProj, sb.toString(), node);
            throw new XQEOlapUnsupportedQueryException(message);
        }
        summaryFilter.setNumberOfScopedEdges(numberOfEdgesWithScope);
        node.setPropertyValue(PROP_APPLIED, Boolean.TRUE);
    }

    private void validateScopeDataItem(IXQEQueryNode filter, RSAPIDataset dataset, RSAPIDataItem dataItem) {
        for (IXQEQueryNode cogMDXGroupNode : dataset.getDescendantsOfCategory(1027, false)) {
            XQEMessage message;
            CogMDXGroup cogMDXGroup;
            String refDataItem;
            if (cogMDXGroupNode.getType() == 1080) {
                IXQEQueryNode[] cogMDXReportSummaryExprNodes;
                for (IXQEQueryNode expression : cogMDXReportSummaryExprNodes = cogMDXGroupNode.getDescendantsOfType(1028, false)) {
                    MDXCalculatedMemberReference calcMemberRef;
                    if (!((CogMDXReportSummaryExpr)expression).isACalculatedMemberReference() || !(calcMemberRef = (MDXCalculatedMemberReference)expression.getChild(0).getChild(0).getChild(0)).getDefinition().getV5Caption().equals(dataItem.getName())) continue;
                    XQEMessage message2 = new XQEMessage(XQEMessageKeys.PLN_UnsupportedSummaryFilterScopeToCalc, XQEMessage.quoteItem(dataItem.getName()), filter);
                    throw new XQEOlapUnsupportedQueryException(message2);
                }
            }
            if ((refDataItem = (cogMDXGroup = (CogMDXGroup)cogMDXGroupNode).getRefDataItemProperty()) == null || !refDataItem.equals(dataItem.getName())) continue;
            cogMDXGroup.throwOnInvalidChildCategories();
            MDXLevelInfo levelInfo = ((AbstractMDXNode)cogMDXGroup.getChild(0)).getLevelInfo();
            MDXHierInfo hierInfo = levelInfo.getHierarchyInfo();
            IHierarchy hierarchy = hierInfo.getProjectedHierarchy(0);
            if (levelInfo.getNumProjectedLevels(hierarchy) > 0 && levelInfo.getProjectedLevelsSkipCalculation(hierarchy).size() == 0) {
                message = new XQEMessage(XQEMessageKeys.PLN_UnsupportedSummaryFilterScopeToCalc, XQEMessage.quoteItem(dataItem.getName()), filter);
                throw new XQEOlapUnsupportedQueryException(message);
            }
            if (hierInfo.projectsMeasures()) {
                message = new XQEMessage(XQEMessageKeys.PLN_UnsuppSummFilterScopeOnMeas, XQEMessage.quoteItem(dataItem.getName()), filter);
                throw new XQEOlapUnsupportedQueryException(message);
            }
            return;
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue(PROP_APPLIED) == Boolean.TRUE) {
            this.traceNodeCondition(false, "The transformation has already been applied to the target node.", trace);
            return false;
        }
        CogMDXSummaryFilter summaryFilter = (CogMDXSummaryFilter)node;
        List<String> scopedDataItemNames = summaryFilter.getScopedDataItemNames();
        if (scopedDataItemNames.size() == 0) {
            this.traceNodeCondition(false, "The target CogMDXSummaryFilter node does not have any scoping defined.", trace);
            return false;
        }
        if (node.getPropertyValue("ValidateSummaryFilterScopeForSingleMasterDetailQueryApplied") != Boolean.TRUE) {
            this.traceNodeCondition(false, "ValidateSummaryFilterScopeForSingleQueryMasterDetail has not been applied yet.", trace);
            return false;
        }
        IXQEQueryNode mdxQuery = node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            this.traceNodeCondition(false, "The target CogMDXSummaryFilter node is not a descendant of an MDXQuery node.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The transformation can be applied to the target node.", trace);
        return true;
    }
}

