/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.util;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEBaseQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXCurrentMember;
import com.cognos.xqe.ast.olap.MDXExcept;
import com.cognos.xqe.ast.olap.MDXIs;
import com.cognos.xqe.ast.olap.MDXOr;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import java.util.ArrayList;
import java.util.Iterator;

public final class RemoveTagTuplesFromSet
extends Transformation {
    public RemoveTagTuplesFromSet() {
        this.mName = "Remove Tag Tuples.";
        this.mPassNumbers = new int[]{39};
        this.mTypes = new int[]{1082};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        AbstractMDXSet targetSet = (AbstractMDXSet)node.getChild(0);
        IXQEQueryNode[] cmRefs = targetSet.getDescendantsOfType(1013, false);
        ArrayList<IXQEQueryNode> tags = new ArrayList<IXQEQueryNode>();
        for (int i = 0; i < cmRefs.length; ++i) {
            if (!((MDXCalculatedMemberReference)cmRefs[i]).isTag()) continue;
            boolean duplicate = false;
            Iterator it = tags.iterator();
            while (it.hasNext()) {
                if (!((MDXCalculatedMemberReference)it.next()).isSameExpression(cmRefs[i], false)) continue;
                duplicate = true;
                break;
            }
            if (duplicate) continue;
            tags.add(cmRefs[i]);
        }
        if (tags.size() > 0) {
            XQENodeFactory factory = environment.getNodeFactory();
            MDXHierInfo hierInfo = targetSet.getHierarchyInfo();
            if (hierInfo.getNumProjectedHierarchies() == 1) {
                MDXExcept mdxExcept = (MDXExcept)factory.createNode(1032);
                targetSet.insertParent(mdxExcept);
                MDXSet mdxSet = (MDXSet)factory.createNode(1039);
                mdxExcept.addChild(mdxSet);
                Iterator iterator = tags.iterator();
                while (iterator.hasNext()) {
                    mdxSet.addChild(factory.deepCopyNode((MDXCalculatedMemberReference)iterator.next()));
                }
            } else {
                XQEBaseQueryNode filterCondition = null;
                for (MDXCalculatedMemberReference mDXCalculatedMemberReference : tags) {
                    IHierarchy hierarchy = mDXCalculatedMemberReference.getHierarchyInfo().getProjectedHierarchy(0);
                    MDXCurrentMember mdxCurrentMember = MDXBuilder.buildMDXCurrentMemberExpr(factory, hierarchy);
                    MDXIs mdxIs = MDXBuilder.buildMDXIsExpr(factory, mdxCurrentMember, (MDXCalculatedMemberReference)factory.deepCopyNode(mDXCalculatedMemberReference));
                    if (filterCondition == null) {
                        filterCondition = mdxIs;
                        continue;
                    }
                    MDXOr mdxOr = (MDXOr)factory.createNode(1111);
                    mdxOr.addChild(filterCondition);
                    mdxOr.addChild(mdxIs);
                    filterCondition = mdxOr;
                }
                MDXBuilder.buildMDXFilterExpr(factory, targetSet, filterCondition);
                filterCondition.insertParent(factory.createNode(1109));
            }
        }
        node.extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getNumberChildren() == 1 && node.getChild(0).isOfCategory(1021) && node.getChild(0).isValidPlannedQuery() == -1) {
            this.traceNodeCondition(true, "The node has a single fully planned AbstractMDXSet child node.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The node either does not have a single child node, the child node is not an AbstractMDXSet instance, or it is not fully planned.", trace);
        return false;
    }
}

