/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.validate;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;

public final class ValidateProjectedContextDefined
extends Transformation {
    public ValidateProjectedContextDefined() {
        this.mName = "Validate projected context is defined.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{1027, 1026};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        AbstractMDXSet groupSet = (AbstractMDXSet)node.getChild(0);
        groupSet.throwOnInvalidChildCategories();
        MDXEdge edge = (MDXEdge)node.getAncestorOfType(1006);
        if (edge == null || !edge.isProjectedDescendant(groupSet)) {
            this.traceNodeCondition(false, "The target node is not a projected under and MDXEdge node.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)edge.getAncestorOfType(1002);
        MDXHierInfo edgeHierInfo = groupSet.getHierarchyInfo();
        for (IHierarchy hierarchy : edgeHierInfo.getProjectedHierarchies()) {
            if (!groupSet.isContextDependent(hierarchy) || groupSet.getContextHierarchyInfo(edge).getProjectedHierarchies().contains(hierarchy)) continue;
            if (hierarchy.equals(mdxQuery.getMeasuresHierarchy())) {
                throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_ProjectedMeasureContextNotResolved, ((AbstractMDXSet)node).getRefDataItemProperty());
            }
            int severityOfMessage = 1;
            environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(severityOfMessage, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_CurrentMemberTransformedIntoDefaultMember, ((AbstractMDXSet)node).getRefDataItemProperty(), mdxQuery.getV5NameProperty(), hierarchy.getName()));
        }
        this.traceNodeCondition(false, "The transformation has not yet been applied to this node.", trace);
        return false;
    }
}

