/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLSubQuery;
import com.cognos.xqe.query.engine.BasePlanningEnvironment;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;

public final class AssignContextNumbers
extends RQETransformation {
    public AssignContextNumbers() {
        this(0);
    }

    public AssignContextNumbers(int passNumber) {
        this.mName = "Assign context numbers to subquery nodes.";
        this.mPassNumbers = new int[]{passNumber};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
        this.mTypes = new int[]{301059};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLSubQuery subQuery = (SQLSubQuery)node;
        int contextNo = ((BasePlanningEnvironment)environment).incrementAndGetContextNo();
        subQuery.setContextNo(contextNo);
        SQLSubQuery parentSubQuery = (SQLSubQuery)subQuery.getAncestorOfType(301059);
        if (parentSubQuery != null) {
            subQuery.setParentContextNo(parentSubQuery.getContextNo());
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        boolean bl = status = ((SQLSubQuery)node).getContextNo() == 0;
        if (status) {
            this.traceQueryCondition(status, "Relation has not been bound.", trace);
        } else {
            this.traceQueryCondition(status, "Relation has been bound.", trace);
        }
        return status;
    }
}

