/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEBaseQueryNode;
import com.cognos.xqe.ast.sql.SQLIdentifier;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.bibushandler.datasource.DataSource;
import com.cognos.xqe.bibushandler.datasource.DataSourceConnection;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.providers.IDataProvider;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.connection.parameters.DataSourceParameter;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.util.datasets.FlintUtils;
import com.cognos.xqemoser.MoserModuleUtil;
import com.cognos.xqeqte.QTEAbstractTransformation;
import com.cognos.xqerdp.flint.FlintApiFacade;
import com.cognos.xqerdp.flint.FlintConnection;
import com.ibm.bi.platform.datasetutils.parquet.ParquetVersionEnum;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.fs.FileSystem;

public class BindFlintSelfJoinRelations
extends RQETransformation {
    private static final int MAX_SELF_JOINS = 100;
    private static final String FLINT_SELF_JOIN_BOUND_PROP_KEY = "flintSelfJoinBound";
    private static final String PASS_CONDITION_TRACE_MSG = "SQLJoin has at least two SQLRelation child nodes bound to Flint that are involved in self-join operation.";
    private static final String FAIL_CONDITION_NOSELFJOIN_TRACE_MSG = "SQLJoin has no SQLRelation child nodes bound to Flint that are involved in self-join operation.";
    private static final String FAIL_CONDITION_ALREADY_BOUND_TRACE_MSG = "SQLJoin node already bound.";

    public BindFlintSelfJoinRelations(int passNumber) {
        this.mName = "Resolve SelfJoin Flint SQLRelations.";
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mPassNumbers = new int[]{passNumber};
        this.mTypes = new int[]{301011};
    }

    private static <T extends XQEBaseQueryNode> Collector<T, ?, ArrayList<T>> toSortedListByNodeId() {
        return Collectors.collectingAndThen(Collectors.toCollection(ArrayList::new), lst -> {
            Collections.sort(lst, Comparator.comparingInt(XQEBaseQueryNode::getId));
            return lst;
        });
    }

    private static String cloneFile(String srcFileLocation, int copyId) {
        String result;
        if (copyId <= 0 || copyId >= 100) {
            throw new IllegalArgumentException("Invalid value for 'copyId' parameter; must be in the range [1, 99].'");
        }
        int extensionIndex = srcFileLocation.lastIndexOf(46);
        String baseFilePath = srcFileLocation.substring(0, extensionIndex);
        String extension = srcFileLocation.substring(extensionIndex);
        String targetFileLocationHardLink = baseFilePath + String.format("_hl%02d", copyId) + extension;
        String targetFileLocationCopy = baseFilePath + String.format("_cp%02d", copyId) + extension;
        Path srcFilePath = Paths.get(srcFileLocation, new String[0]);
        Path targetFilePathHardLink = Paths.get(targetFileLocationHardLink, new String[0]);
        Path targetFilePathCopy = Paths.get(targetFileLocationCopy, new String[0]);
        if (targetFilePathHardLink.toFile().exists()) {
            return targetFileLocationHardLink;
        }
        if (targetFilePathCopy.toFile().exists()) {
            return targetFileLocationCopy;
        }
        try {
            Files.createLink(targetFilePathHardLink, srcFilePath);
            result = targetFileLocationHardLink;
        }
        catch (Exception e) {
            try {
                Files.copy(srcFilePath, targetFilePathCopy, new CopyOption[0]);
                result = targetFileLocationCopy;
            }
            catch (Exception ee) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_DatasetCreationFailure, ee.getCause());
            }
        }
        return result;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        SQLJoin join = (SQLJoin)node;
        join.setPropertyValue(FLINT_SELF_JOIN_BOUND_PROP_KEY, true);
        if (null != node.getAncestorOfType(301011)) {
            return;
        }
        IXQEQueryNode[] sqlRelationChildren = join.getDescendantsOfType(301016, true);
        Map nameToSQLRelationsMap = Arrays.stream(sqlRelationChildren).map(e -> (SQLRelation)e).filter(e -> null != e.getDataSource() && "FLINT" == e.getDataSource().getType()).collect(Collectors.groupingBy(SQLIdentifier::getModelDatasourceName, BindFlintSelfJoinRelations.toSortedListByNodeId()));
        HashSet<String> newFilePaths = new HashSet<String>();
        try {
            for (Map.Entry entry : nameToSQLRelationsMap.entrySet()) {
                LinkedList<Pair<SQLRelation, String>> nodeAndDatasetLocationList = new LinkedList<Pair<SQLRelation, String>>();
                ArrayList children = entry.getValue();
                IDataSource datasource = ((SQLRelation)children.get(0)).getDataSource();
                Map<String, Object> mdProperties = datasource.getMetadataProperties();
                String pqFileLocation = mdProperties.get("fallbackConnectionString").toString().substring(";LOCAL;PARQUET;URL=".length());
                String logicalName = (String)mdProperties.get("dsLogicalName");
                for (int i = 1; i < children.size(); ++i) {
                    String targetFileLocation = BindFlintSelfJoinRelations.cloneFile(pqFileLocation, i);
                    newFilePaths.add(targetFileLocation);
                    SQLRelation currentChild = (SQLRelation)children.get(i);
                    IDataSource currentDS = currentChild.getDataSource();
                    DataSource newDS = new DataSource(currentDS.getName(), currentDS.getName(), currentDS.getType(), currentDS.getMetadataProperties());
                    DataSourceConnection newDSConn = new DataSourceConnection(currentDS.getName(), currentDS.getDataSourceConnection().getConnectionString(null), newDS);
                    HashMap<String, IDataSourceConnection> newConnectionsMap = new HashMap<String, IDataSourceConnection>();
                    newConnectionsMap.put(currentDS.getName(), newDSConn);
                    newDS.setCapabilities(currentDS.getCapabilities());
                    newDS.setConnectionsMap(newConnectionsMap);
                    currentChild.setDataSource(newDS);
                    Map<String, Object> newProps = currentChild.getDataSource().getMetadataProperties();
                    newProps.put("fallbackConnectionString", ";LOCAL;PARQUET;URL=" + targetFileLocation);
                    String newLogicalName = null == logicalName ? Integer.toString(i) : logicalName + i;
                    newProps.put("dsLogicalName", newLogicalName);
                    nodeAndDatasetLocationList.add((Pair<SQLRelation, String>)Pair.of((Object)currentChild, (Object)targetFileLocation));
                }
                int lastFwdSlashIdx = pqFileLocation.lastIndexOf(47);
                int lastDotIdx = pqFileLocation.lastIndexOf(46);
                String storeID = pqFileLocation.substring(lastFwdSlashIdx + 1, lastDotIdx);
                String pqVersion = (String)mdProperties.get("version");
                if (ParquetVersionEnum.VERSION_1.getValue().equals(pqVersion) && storeID.endsWith(pqVersion)) {
                    storeID = storeID.substring(0, storeID.length() - pqVersion.length());
                }
                BindFlintSelfJoinRelations.touchAndPrepareDatasets(datasource, environment, nodeAndDatasetLocationList, storeID);
            }
        }
        catch (IllegalArgumentException iae) {
            newFilePaths.parallelStream().forEach(p -> FileUtils.deleteQuietly((File)Paths.get(p, new String[0]).toFile()));
            throw new XQERuntimeException(XQEMessageKeys.FLT_ComputeServiceTooManySelfJoins, 100);
        }
        catch (Exception e2) {
            newFilePaths.parallelStream().forEach(p -> FileUtils.deleteQuietly((File)Paths.get(p, new String[0]).toFile()));
            throw e2;
        }
    }

    private static void touchAndPrepareDatasets(IDataSource dataSource, PlanningEnvironment planningEnv, List<Pair<SQLRelation, String>> nodeAndDatasetLocationList, String storeID) {
        ConnectionParameters parameters = new ConnectionParameters();
        IDataProvider flintProvider = ProviderManager.getInstance().getProvider("FLINT");
        parameters.put(new DataSourceParameter(dataSource));
        IPooledConnection flintPooledConnection = flintProvider.borrowConnection(parameters, (IExecutionEnvironment)planningEnv.getExecutionEnvironment());
        FlintConnection flintConnection = (FlintConnection)flintPooledConnection.getConnection();
        try {
            flintConnection.connect(null);
            FlintApiFacade apiFacade = flintConnection.getApiFacade();
            for (Pair<SQLRelation, String> nodeAndDatasetLocationPair : nodeAndDatasetLocationList) {
                SQLRelation node = (SQLRelation)nodeAndDatasetLocationPair.getKey();
                String pqFileLocation = (String)nodeAndDatasetLocationPair.getValue();
                Map<String, Object> props = node.getDataSource().getMetadataProperties();
                String logicalName = (String)props.get("dsLogicalName");
                String flintDatasetName = FlintUtils.generateFlintDatasetName(node.getModelDatasourceName(), logicalName);
                if (apiFacade.touchDataset(flintDatasetName)) continue;
                String flintDSURIString = FlintUtils.getUnencryptedHadoopURIString(pqFileLocation);
                MoserModuleUtil.prepareDataset(apiFacade, flintDatasetName, flintDSURIString, logicalName, storeID, props);
                Configuration config = FlintUtils.getHadoopConfiguration();
                shaded.org.apache.hadoop.fs.Path filePath = new shaded.org.apache.hadoop.fs.Path(flintDSURIString);
                FileSystem fs = filePath.getFileSystem(config);
                long now = System.currentTimeMillis();
                fs.setTimes(filePath, now, now);
            }
        }
        catch (Exception e) {
            flintPooledConnection.setNotReusable();
            throw XQERuntimeException.wrap(e);
        }
        finally {
            flintPooledConnection.returnConnection();
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLJoin join = (SQLJoin)node;
        if (null != join.getPropertyValue(FLINT_SELF_JOIN_BOUND_PROP_KEY) && ((Boolean)join.getPropertyValue(FLINT_SELF_JOIN_BOUND_PROP_KEY)).booleanValue()) {
            this.traceQueryCondition(false, FAIL_CONDITION_ALREADY_BOUND_TRACE_MSG, trace);
            return false;
        }
        IXQEQueryNode[] sqlRelationChildren = join.getDescendantsOfType(301016, true);
        Map<String, Long> sqlRelationNameFrequency = Arrays.stream(sqlRelationChildren).map(e -> (SQLRelation)e).filter(e -> null != e.getDataSource() && "FLINT" == e.getDataSource().getType()).collect(Collectors.groupingBy(SQLIdentifier::getModelDatasourceName, Collectors.counting()));
        boolean bl = status = sqlRelationNameFrequency.values().stream().filter(v -> v > 1L).count() > 0L;
        if (status) {
            this.traceQueryCondition(status, PASS_CONDITION_TRACE_MSG, trace);
        } else {
            this.traceQueryCondition(status, FAIL_CONDITION_NOSELFJOIN_TRACE_MSG, trace);
        }
        return status;
    }
}

