/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLParameter;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class BindSQLParameter
extends RQETransformation {
    public BindSQLParameter() {
        this(3);
    }

    public BindSQLParameter(int passNumber) {
        this.mName = "Bind SQLParameter";
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mPassNumbers = new int[]{passNumber};
        this.mTypes = new int[]{301051};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        String name;
        SQLParameter sqlParam = (SQLParameter)node;
        IDataType dataType = null;
        Object requestEnv = environment.getRequestEnvironment();
        Parameters parameters = requestEnv.getRequestParameters();
        Parameter envParam = parameters.getParameter(name = sqlParam.getName());
        if (null == envParam) {
            envParam = new Parameter(name);
            parameters.addParameter(name, envParam);
        }
        if (envParam.getDataType() != null) {
            sqlParam.setDataType(envParam.getDataType());
        } else {
            IXQEQueryNode parent = node.getParent();
            switch (parent.getType()) {
                case 301047: {
                    dataType = DataTypeFactory.getCharType();
                    break;
                }
                default: {
                    int i = 0;
                    if (i >= parent.getNumberChildren()) break;
                    IXQEQueryNode child = parent.getChild(i);
                    dataType = ((SQLQueryNode)child).getDataType();
                    break;
                }
            }
            if (dataType == null) {
                dataType = DataTypeFactory.getCharType();
            }
            envParam.setDataType(dataType);
            sqlParam.setDataType(dataType);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        SQLParameter param = (SQLParameter)node;
        if (param.getParent().getType() == 301061) {
            param.setUseParameterizedSQL(true);
        }
        Object requestEnv = environment.getRequestEnvironment();
        Parameters parameters = requestEnv.getRequestParameters();
        boolean status = false;
        if (!param.isOutParameter().booleanValue() && !param.isInOutParameter().booleanValue()) {
            String name = param.getName();
            Parameter envParam = parameters.getParameter(name);
            boolean bl = status = envParam != null && envParam.getDataType() == null || param.getDataType() == null;
        }
        if (status) {
            super.traceQueryCondition(status, "Query block has not been bound.", trace);
        } else {
            super.traceQueryCondition(status, "Query block has been bound.", trace);
        }
        return status;
    }
}

