/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.SQLXid;
import com.cognos.xqe.ast.v5.query.V5SqlQuery;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLBinderUtil;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.List;

public class BindSQLProject
extends RQETransformation {
    public BindSQLProject() {
        this(3);
    }

    public BindSQLProject(int passNumber) {
        this.mName = "Bind SQLProject query block.";
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mPassNumbers = new int[]{passNumber};
        this.mTypes = new int[]{301015};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        IXQEQueryNode parent;
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getParent();
        SQLQueryNode pNode = (SQLQueryNode)node;
        SQLValueList fieldList = pNode.getOutputList();
        List<String> nameList = qBlock.getDerivedColumnList();
        SQLQueryItemList bindItems = SQLBinderUtil.getQueryItemList(pNode);
        SQLBinderUtil.bindColumns(environment, qBlock, bindItems);
        SQLBinderUtil.bindUserDefinedFunctions(environment, qBlock);
        SQLQueryItemList queryItems = new SQLQueryItemList();
        for (int i = 0; i < fieldList.getNumberChildren(); ++i) {
            SQLQueryNode child = (SQLQueryNode)fieldList.getChild(i);
            SQLQueryItem qItem = new SQLQueryItem();
            String tableName = qBlock.getName();
            String name = null;
            if (nameList != null && i < nameList.size()) {
                name = nameList.get(i);
            }
            if (child.getType() == 301028) {
                if (name == null) {
                    name = ((SQLAlias)child).getName();
                }
                child = (SQLQueryNode)child.getChild(0);
            }
            if (child.getType() == 301032) {
                SQLFid fid = (SQLFid)child;
                if (fid.isFieldRef()) {
                    if (name == null) {
                        name = fid.getName();
                        if (tableName == null) {
                            tableName = fid.getTableName();
                        }
                    }
                    qItem.setDataType(fid.getDataType());
                    qItem.setNullable(fid.isNullable());
                } else {
                    SQLQueryItem item = (SQLQueryItem)bindItems.get(((SQLFid)child).getVirtualColumnNo());
                    if (name == null) {
                        name = item.getName();
                        if (tableName == null) {
                            tableName = item.getTableName();
                        }
                    }
                    qItem.setSchemaName(item.getSchemaName());
                    qItem.setBaseTableName(item.getBaseTableName());
                    qItem.setBaseColumnName(item.getBaseColumnName());
                    qItem.setDataType(item.getDataType());
                    qItem.setModelReference(item.getModelReference());
                    qItem.setNullable(item.isNullable());
                    qItem.setAttributeList(item.getAttributeList());
                    if (qBlock.isForeign()) {
                        qItem.setAdjustDataTypeFromResultSet(item.getAdjustDataTypeFromResultSet());
                    }
                }
                qItem.setVirtualColumnNo(fid.getVirtualColumnNo());
            } else {
                qItem.setDataType(child.getDataType());
                qItem.setNullable(child.isNullable());
            }
            qItem.setSourceNo(0);
            qItem.setColumnNo(i);
            qItem.setTableName(tableName);
            qItem.setName(name);
            if (qBlock.isForeign()) {
                this.setAdjustDataTypeFromResultset(child, qItem);
            }
            queryItems.add(qItem);
        }
        qBlock.setQueryItemList(queryItems);
        if (qBlock.isLateralDerivedTable()) {
            SQLQueryBlock topQueryBlock = (SQLQueryBlock)qBlock.getAncestorOfType(301004);
            List<SQLXid> xidList = CollectionCast.downcast(qBlock.getDescendantsOfTypeOrdered(301082, false), IXQEQueryNode.class, SQLXid.class);
            topQueryBlock.addXidList(xidList);
        }
        if ((parent = qBlock.getParent()).getType() == 101016) {
            ((V5SqlQuery)parent).setQueryItemList(queryItems);
        }
    }

    void setAdjustDataTypeFromResultset(SQLQueryNode node, SQLQueryItem queryItem) {
        if (node instanceof SQLExpression && ((SQLExpression)node).needAdjustDataType()) {
            queryItem.setAdjustDataTypeFromResultSet(true);
            return;
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        boolean bl = status = ((SQLQueryBlock)node.getParent()).getQueryItemList() == null;
        if (status) {
            super.traceQueryCondition(status, "Query block has not been bound.", trace);
        } else {
            super.traceQueryCondition(status, "Query block has been bound.", trace);
        }
        return status;
    }
}

