/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.sql.SQLTableFunction;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5SqlQuery;
import com.cognos.xqe.bibushandler.content.ContentManager;
import com.cognos.xqe.bibushandler.datasource.DataSource;
import com.cognos.xqe.bibushandler.datasource.DataSourceConnection;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IPhysicalColumn;
import com.cognos.xqe.metadata.IPhysicalIndex;
import com.cognos.xqe.metadata.IPhysicalTable;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.MetadataConnectionContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLBinderUtil;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.transformation.relational.binding.exceptions.BindAmbiguousRelationException;
import com.cognos.xqe.transformation.relational.binding.exceptions.BindRelationNotFoundException;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.ConnectionUtil;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.datasets.FlintUtils;
import com.cognos.xqemoser.MoserMetadataConnection;
import com.cognos.xqemoser.MoserModuleUtil;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class BindSQLRelation
extends RQETransformation {
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    private static XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "DataQuery", LogLevel.INFO);
    private static final String CONFIG_ALWAYS_GET_METADATA_FROM_DB_WHEN_MACRO_IN_DS = "queryPlanning.alwaysGetMetadataFromDBWhenMacrosInModelDatasource[@enabled]";

    public BindSQLRelation() {
        this(3);
    }

    public BindSQLRelation(int passNumber) {
        this.mName = "Bind SQLRelation node.";
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mPassNumbers = new int[]{passNumber};
        this.mTypes = new int[]{301016};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) throws BindRelationNotFoundException {
        try {
            BindSQLRelation.queryPhysicalModel(node, environment);
        }
        catch (BindRelationNotFoundException e) {
            try (MetadataConnectionContext metadataConnContext = null;){
                RSAPIDataset rsapiDataset;
                PlanningEnvironment planEnv;
                if (environment instanceof PlanningEnvironment && (planEnv = (PlanningEnvironment)environment).isMultiModelForQueryEnabled() && (rsapiDataset = (RSAPIDataset)node.getAncestorOfType(401005)).getRefQueryName() != null && planEnv.getRoot().getType() == 101002) {
                    IXQEQueryNode[] queryList;
                    V5Query query = null;
                    for (IXQEQueryNode currQuery : queryList = planEnv.getRoot().getChildrenOfType(101006)) {
                        if (!((V5Query)currQuery).getV5QueryName().equals(rsapiDataset.getRefQueryName())) continue;
                        query = (V5Query)currQuery;
                        break;
                    }
                    if (query != null) {
                        metadataConnContext = planEnv.pushMetadataConnectionContext(query.getMetadataPath());
                    }
                }
                this.queryFMModel(node, environment);
            }
        }
        IDataSource ds = ((SQLRelation)node).getDataSource();
        if (null != ds && DataSourceTypeEnum.isFlint(ds.getType())) {
            String newDSName = FlintUtils.getLogicalDSName();
            DataSource newDS = new DataSource(newDSName, newDSName, "FLINT", ds.getMetadataProperties());
            DataSourceConnection newDSConn = new DataSourceConnection(newDSName, newDS.getDataSourceConnection().getConnectionString(null), newDS);
            HashMap<String, IDataSourceConnection> newConnectionsMap = new HashMap<String, IDataSourceConnection>();
            newConnectionsMap.put(newDSName, newDSConn);
            newDS.setCapabilities(ds.getCapabilities());
            newDS.setConnectionsMap(newConnectionsMap);
            logger.log(String.format("Flint DataSource detected. Changing the logical DataSource name from '%s' to '%s'.", ds.getName(), newDS.getName()));
            SQLRelation sqlRelationNode = (SQLRelation)node;
            sqlRelationNode.setDataSource(newDS);
            sqlRelationNode.setDatabaseName(newDSName);
            if (null == sqlRelationNode.getModelDatasourceName()) {
                sqlRelationNode.setModelDatasourceName(ds.getCMDataSourceName());
            }
            ds = newDS;
        }
        if (ds != null) {
            V5SqlQuery sqlQuery = (V5SqlQuery)node.getAncestorOfType(101016);
            if (sqlQuery != null && ds.getDataSourceConnection().getConnectionString().toLowerCase().contains("ibmcognos.typeinsqldisabled")) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_UserDefinedSQLforDataSourceDenied, ds.getDataSourceConnection().getName());
            }
            SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
            qBlock.addDataSource(ds);
        }
    }

    private boolean queryFMModel(IXQEQueryNode node, IPlanningEnvironment environment) throws BindRelationNotFoundException {
        SQLRelation relationNode = (SQLRelation)node;
        Object mdConnection = environment.getMetadataConnection();
        Object executionEnv = environment.getExecutionEnvironment();
        String database = relationNode.getDatabaseName();
        String baseName = relationNode.getName();
        if (environment.isBigSQL() && database != null) {
            throw new BindRelationNotFoundException(baseName);
        }
        IDataSource dataSource = null;
        IQuerySubject querySubject = null;
        String name = null;
        if (database != null) {
            dataSource = SQLBinderUtil.findOrCreateDataSource(environment, relationNode);
            name = UniqueNameGenerator.createUniqueName(dataSource.getName(), baseName);
            querySubject = (IQuerySubject)mdConnection.bindMetadataReference(name);
        } else {
            if (BindSQLRelation.bindCommonTableExpression(relationNode)) {
                return true;
            }
            Collection<IDataSource> dataSources = executionEnv.getDataSources();
            boolean found = false;
            for (IDataSource ds : dataSources) {
                if (!ds.isRelational()) continue;
                name = UniqueNameGenerator.createUniqueName(ds.getName(), baseName);
                try {
                    querySubject = (IQuerySubject)mdConnection.bindMetadataReference(name);
                    if (found) {
                        throw new BindAmbiguousRelationException(name);
                    }
                    found = true;
                    dataSource = ds;
                }
                catch (XQERuntimeException e) {
                    mErrorLogger.log(e);
                }
            }
            if (!found) {
                throw new BindRelationNotFoundException(name);
            }
        }
        dataSource = MoserModuleUtil.promoteSQLRelationDSForFlint(dataSource, environment.getExecutionEnvironment());
        SQLQueryItemList qItems = SQLBinderUtil.makeQueryItems(querySubject.getQueryItemsAndMeasures(), relationNode.getSchemaName(), relationNode.getName());
        relationNode.setQueryItemList(qItems);
        relationNode.setDataSource(dataSource);
        ConnectionUtil.connect(executionEnv, dataSource);
        return true;
    }

    public static Pair getDataSource(SQLRelation relationNode, IPlanningEnvironment environment, Pair ext) throws BindRelationNotFoundException {
        IPhysicalTable relation;
        IDataSource dataSource;
        String database;
        String modelDatasourceName;
        block23: {
            V5SqlQuery sqlQuery;
            Object mdConnection = environment.getMetadataConnection();
            Object executionEnv = environment.getExecutionEnvironment();
            modelDatasourceName = relationNode.getModelDatasourceName();
            database = relationNode.getDatabaseName();
            String rawCmDatabaseName = relationNode.getRawCmDatabaseName();
            String baseName = relationNode.getName();
            String schema = relationNode.getSchemaName();
            String rawSchemaName = relationNode.getRawSchemaName();
            String catalog = relationNode.getCatalogName();
            String rawCatalogName = relationNode.getRawCatalogName();
            if (environment.isBigSQL() && (database != null || catalog != null)) {
                throw new BindRelationNotFoundException(baseName);
            }
            if (database == null && (sqlQuery = (V5SqlQuery)relationNode.getAncestorOfType(101016)) != null) {
                database = (String)sqlQuery.getPropertyValue("dataSource");
            }
            dataSource = null;
            relation = null;
            try {
                List<IMetadata> relationList = null;
                XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
                if (database != null && database.length() > 0) {
                    dataSource = SQLBinderUtil.findOrCreateDataSource(environment, modelDatasourceName, database, null, null);
                    boolean alwaysGetMetadataFromDBWhenMacroInDS = config.getBooleanProperty(CONFIG_ALWAYS_GET_METADATA_FROM_DB_WHEN_MACRO_IN_DS, false);
                    if (!alwaysGetMetadataFromDBWhenMacroInDS && relationNode.containsExpandedMacros()) {
                        relationList = mdConnection.getPhysicalMetadata(rawCmDatabaseName, rawCatalogName, rawSchemaName, baseName, true, BindSQLRelation.isMetadataCallbackEnabled(relationNode));
                    }
                    if (relationList == null || relationList.isEmpty()) {
                        relationList = mdConnection.getPhysicalMetadata(database, catalog, schema, baseName, true, BindSQLRelation.isMetadataCallbackEnabled(relationNode));
                    }
                    if (!dataSource.isRelational()) {
                        dataSource.setIsRelational();
                    }
                    String reason = null;
                    if ((relationList == null || relationList.isEmpty()) && environment.getMetadataConnection() instanceof MoserMetadataConnection) {
                        MoserMetadataConnection mc = (MoserMetadataConnection)environment.getMetadataConnection();
                        try {
                            relationList = mc.getPhysicalMetadaFromCM(database, dataSource.getDataSourceConnection().getName(), catalog, schema, baseName, environment);
                        }
                        catch (XQERuntimeException msrE) {
                            reason = msrE.getLocalizedMessage();
                        }
                    }
                    if (relationList == null || relationList.isEmpty()) {
                        if (reason == null) {
                            throw new BindRelationNotFoundException(baseName);
                        }
                        throw new BindRelationNotFoundException(baseName, reason);
                    }
                    if (relationList.size() > 1) {
                        throw new BindAmbiguousRelationException(baseName);
                    }
                    relation = (IPhysicalTable)relationList.get(0);
                    break block23;
                }
                Collection<IDataSource> dataSources = executionEnv.getDataSources();
                if (!ContentManager.isEnabled() && mdConnection instanceof MetadataConnection) {
                    if (dataSources.size() == 1) {
                        MetadataConnection metadataConnection = (MetadataConnection)mdConnection;
                        dataSource = dataSources.iterator().next();
                        relation = metadataConnection.getPhysicalTable(dataSource.getName(), catalog, schema, baseName);
                    }
                } else {
                    HashSet<String> cmDsList = new HashSet<String>();
                    relation = null;
                    for (IDataSource ds : dataSources) {
                        String cmDataSourceName;
                        if (!ds.isRelational() || DataSourceTypeEnum.isColumnar(ds.getType()) || DataSourceTypeEnum.isFlint(ds.getType()) || cmDsList.contains(cmDataSourceName = ds.getCMDataSourceName())) continue;
                        relationList = mdConnection.getPhysicalMetadata(cmDataSourceName, catalog, schema, baseName, true, BindSQLRelation.isMetadataCallbackEnabled(relationNode));
                        if (relationList.size() > 1) {
                            throw new BindAmbiguousRelationException(baseName);
                        }
                        if (relationList.size() == 1 && relation != null) {
                            throw new BindAmbiguousRelationException(baseName);
                        }
                        if (relationList.size() != 1) continue;
                        relation = (IPhysicalTable)relationList.get(0);
                        database = cmDataSourceName;
                        cmDsList.add(cmDataSourceName);
                        dataSource = ds;
                    }
                }
                if (relation == null) {
                    throw new BindRelationNotFoundException(baseName);
                }
            }
            catch (XQERuntimeException e) {
                if (e.getCause() != null && e.getCause().toString().contains("MFWException:")) {
                    throw new BindRelationNotFoundException(baseName, e.getCause().getLocalizedMessage());
                }
                throw e;
            }
        }
        if (ext != null) {
            ext.setFirst(modelDatasourceName);
            ext.setSecond(database);
        }
        return new Pair(dataSource, relation);
    }

    public static boolean queryPhysicalModel(IXQEQueryNode node, IPlanningEnvironment environment) throws BindRelationNotFoundException {
        SQLRelation relationNode = (SQLRelation)node;
        if (BindSQLRelation.bindCommonTableExpression(relationNode)) {
            return true;
        }
        Pair ext = new Pair();
        Pair p = BindSQLRelation.getDataSource(relationNode, environment, ext);
        IDataSource dataSource = (IDataSource)p.getFirst();
        IPhysicalTable relation = (IPhysicalTable)p.getSecond();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Set<String> availableProperties = relation.getAvailableProperties();
        for (String property : availableProperties) {
            properties.put(property, relation.getProperty(property));
        }
        Object executionEnv = environment.getExecutionEnvironment();
        String apiType = (String)properties.get("APITYPE");
        if (apiType != null) {
            String modelDatasourceName = (String)ext.getFirst();
            String database = (String)ext.getSecond();
            dataSource = SQLBinderUtil.resolveDataSource(executionEnv, dataSource, modelDatasourceName, database, apiType);
        }
        dataSource = MoserModuleUtil.promoteSQLRelationDSForFlint(dataSource, environment.getExecutionEnvironment());
        ConnectionUtil.connect(executionEnv, dataSource);
        relationNode.setDataSource(dataSource);
        relationNode.setExternalName(relation.getExternalName());
        relationNode.setMetadataProperties(properties);
        if (relationNode.getSchemaName() == null && relation.getSchemaName() != null && relation.getSchemaName().length() > 0) {
            relationNode.setSchemaName(relation.getSchemaName());
        }
        SQLQueryItemList queryItems = BindSQLRelation.getQueryItems(relationNode.getCatalogName(), relationNode.getSchemaName(), relationNode.getName(), relation, SQLBinderUtil.determineCaseSensitivity(dataSource.getCapabilities()));
        if (relationNode.getParent().getType() == 301007) {
            String name = ((SQLRangeVar)relationNode.getParent()).getName();
            for (SQLQueryItem queryItem : queryItems) {
                queryItem.setTableName(name);
            }
        }
        relationNode.setQueryItemList(queryItems);
        relationNode.setIndexes(relation.getIndexes());
        return true;
    }

    private static SQLQueryItemList getQueryItems(String catalog, String schema, String tableName, IPhysicalTable relation, boolean isCaseSensitive) {
        SQLQueryItemList queryItems = BindSQLRelation.getQueryItems(catalog, schema, tableName, relation.getColumns(), isCaseSensitive);
        if (relation.getIndexes() != null) {
            for (IPhysicalIndex index : relation.getIndexes()) {
                List<String> columns = index.getColumns();
                if (!index.isUnique() || columns.size() > 1) continue;
                SQLQueryItem queryItem = queryItems.getQueryItem(columns.get(0));
                queryItem.setUnique(true);
            }
        }
        return queryItems;
    }

    private static SQLQueryItemList getQueryItems(String catalog, String schema, String tableName, List<IPhysicalColumn> columns, boolean isCaseSensitive) {
        SQLQueryItemList queryItems = new SQLQueryItemList(columns.size());
        for (int i = 0; i < columns.size(); ++i) {
            List<IMetadata> metadataObjects;
            SQLQueryItem itemDesc = new SQLQueryItem();
            IPhysicalColumn column = columns.get(i);
            itemDesc.setSourceNo(0);
            itemDesc.setColumnNo(i);
            itemDesc.setVirtualColumnNo(i);
            itemDesc.setCatalogName(catalog);
            itemDesc.setSchemaName(schema);
            itemDesc.setTableName(tableName);
            itemDesc.setBaseTableName(tableName);
            itemDesc.setBaseColumnName(column.getName());
            itemDesc.setName(column.getName());
            itemDesc.setDataType(column.getDataType());
            itemDesc.setNullable(column.isNullable());
            itemDesc.setHidden(column.isHidden());
            itemDesc.setCaseSensitivity(isCaseSensitive);
            if (column.hasChildMetadataObjects() && (metadataObjects = column.getChildMetadataObjects()).size() > 0) {
                List<IPhysicalColumn> attributes = CollectionCast.downcast(metadataObjects, IMetadata.class, IPhysicalColumn.class);
                itemDesc.setAttributeList(BindSQLRelation.getQueryItems(null, null, null, attributes, isCaseSensitive));
            }
            queryItems.add(itemDesc);
        }
        return queryItems;
    }

    private static boolean isMetadataCallbackEnabled(IXQEQueryNode node) {
        Governors governors = node.getGovernors();
        if (governors == null) {
            return true;
        }
        return governors.getMdCallback();
    }

    private static boolean bindCommonTableExpression(SQLRelation relationNode) {
        for (IXQEQueryNode withSpec = relationNode.getAncestorOfType(301022); withSpec != null; withSpec = withSpec.getAncestorOfType(301022)) {
            int i;
            int n = withSpec.getNumberChildren() - 1;
            for (i = 0; i < n; ++i) {
                if (!relationNode.isAncestor(withSpec.getChild(i))) continue;
                n = i + 1;
                break;
            }
            for (i = 0; i < n; ++i) {
                SQLQueryBlock qBlock = (SQLQueryBlock)withSpec.getChild(i);
                if (!qBlock.getName().equals(relationNode.getName())) continue;
                SQLQueryItemList qItems = qBlock.getQueryItemList();
                if (relationNode.isAncestor(qBlock)) {
                    IXQEQueryNode setOp = relationNode.getAncestorOfType(301018);
                    SQLQueryBlock setOpQueryBlock = (SQLQueryBlock)setOp.getParent();
                    String queueName = String.format("%s$%s", relationNode.getName(), qBlock.getReferenceCount());
                    setOpQueryBlock.setRecursive(true);
                    setOpQueryBlock.setQueueName(queueName);
                    relationNode.setRecursive(true);
                    relationNode.setQueueName(queueName);
                }
                relationNode.setQueryItemList(qItems.copy());
                relationNode.setWithClauseQueryRef(true);
                relationNode.setDataSource(qBlock.getDataSource());
                qBlock.incrementReferenceCount();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        boolean bl = status = ((SQLRelation)node).getQueryItemList() == null && (node.getParent().getType() != 301038 || ((SQLTableFunction)node.getParent()).getSubType() != SQLTableFunction.SubType.DATASET);
        if (status) {
            this.traceQueryCondition(status, "Relation has not been bound.", trace);
        } else {
            this.traceQueryCondition(status, "Relation has been bound.", trace);
        }
        return status;
    }
}

