/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLSetOperator;
import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.DataTypeComparator;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.List;

public final class BindSQLSetOperator
extends RQETransformation {
    public BindSQLSetOperator() {
        this(3);
    }

    public BindSQLSetOperator(int passNumber) {
        this.mName = "Bind SQLSetOperator node.";
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mPassNumbers = new int[]{passNumber};
        this.mTypes = new int[]{301004, 301018};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLQueryItemList queryItems;
        SQLSetOperator setOp;
        if (node.getType() == 301004) {
            setOp = (SQLSetOperator)node.getParent();
            queryItems = ((SQLQueryNode)node).getQueryItemList();
            setOp.setIsBound(false);
            IXQEQueryNode parent = setOp.getParent();
            while (parent.getType() == 301004 && parent.getParent().getType() == 301018) {
                parent = parent.getGrandParent();
            }
            SQLQueryBlock qBlock = (SQLQueryBlock)parent;
            List<String> nameList = qBlock.getDerivedColumnList();
            String tableName = qBlock.getName();
            int i = 0;
            for (SQLQueryItem qItem : queryItems) {
                if (tableName != null) {
                    qItem.setTableName(tableName);
                }
                if (nameList == null || nameList.size() != queryItems.size()) continue;
                qItem.setName(nameList.get(i++));
            }
            if (qBlock.getParent().getType() == 301022) {
                if (qBlock.getQueryItemList() == null) {
                    qBlock.setQueryItemList(queryItems);
                } else {
                    this.getCompatibleDataTypes(parent, qBlock.getQueryItemList(), queryItems);
                }
            }
        } else {
            setOp = (SQLSetOperator)node;
            queryItems = ((SQLQueryNode)node.getChild(0)).getQueryItemList();
            for (int i = 1; i < setOp.getNumberChildren(); ++i) {
                this.getCompatibleDataTypes(node.getParent(), queryItems, ((SQLQueryNode)setOp.getChild(i)).getQueryItemList());
            }
            setOp.setIsBound(true);
            setOp.setQueryItemList(queryItems);
        }
        for (SQLQueryItem queryItem : queryItems) {
            if (queryItem.getDataType().getSubType() != DataSubType.METADATATYPE) continue;
            queryItem.setDataType(DataTypeFactory.getVarcharType());
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        IXQEQueryNode parent;
        XQETrace trace = environment.getTrace();
        if (node.getType() == 301004 && node.getChild(0).getType() != 301018 && (parent = node.getParent()).getChild(0) == node) {
            node = parent;
        }
        boolean bl = status = node.getType() == 301018 && !((SQLSetOperator)node).isBound();
        if (status) {
            this.traceQueryCondition(status, "Set operator has not been bound.", trace);
        } else {
            this.traceQueryCondition(status, "Set operator has been bound.", trace);
        }
        return status;
    }

    private void getCompatibleDataTypes(IXQEQueryNode sqlQueryBlock, SQLQueryItemList qItems1, SQLQueryItemList qItems2) {
        for (int i = 0; i < qItems1.size(); ++i) {
            IDataType dataType2;
            SQLQueryItem queryItem1 = (SQLQueryItem)qItems1.get(i);
            SQLQueryItem queryItem2 = (SQLQueryItem)qItems2.get(i);
            IDataType dataType1 = queryItem1.getDataType();
            IDataType dataType = DataTypeComparator.getCompatibleType(dataType1, dataType2 = queryItem2.getDataType());
            if (dataType == null) {
                String queryName = "SetOperation";
                if (sqlQueryBlock.getType() == 301004) {
                    queryName = ((SQLQueryBlock)sqlQueryBlock).getName();
                }
                String datatypes = "(" + dataType1.getTypeName() + " " + dataType2.getTypeName() + ")";
                throw new XQERuntimeException(XQEMessageKeys.PLN_IncompatibleDataTypesInSetOperation, (Object)queryItem1.getName(), (Object)queryName, (Object)datatypes);
            }
            queryItem1.setDataType(dataType);
            queryItem1.setNullable(queryItem1.isNullable() || queryItem2.isNullable());
        }
    }
}

