/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLSort;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.ast.v5.query.V5SqlQuery;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLBinderUtil;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.transformation.relational.binding.exceptions.BindColumnNotFoundException;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class BindSQLSort
extends RQETransformation {
    public BindSQLSort() {
        this(3);
    }

    public BindSQLSort(int passNumber) {
        this.mName = "Bind SQLSort query block.";
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mPassNumbers = new int[]{passNumber};
        this.mTypes = new int[]{301019};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getParent();
        SQLSort sort = (SQLSort)node;
        SQLQueryItemList queryItems = sort.getQueryItemList();
        SQLQueryItemList baseQueryItems = sort.getBaseQueryItemList();
        IXQEQueryNode[] sortKeys = sort.getSortKeyList().getChildren();
        for (int i = 0; i < sortKeys.length; ++i) {
            SQLSortKey sortKey = (SQLSortKey)sortKeys[i];
            try {
                SQLBinderUtil.bindColumns(environment, sortKey, queryItems);
                continue;
            }
            catch (BindColumnNotFoundException e) {
                SQLBinderUtil.bindColumns(environment, sortKey, baseQueryItems);
                sortKey.setUnrelated(true);
            }
        }
        SQLBinderUtil.bindUserDefinedFunctions(environment, qBlock);
        String tableName = qBlock.getName();
        if (tableName != null) {
            for (SQLQueryItem qItem : queryItems) {
                qItem.setTableName(tableName);
            }
        }
        qBlock.setQueryItemList(queryItems);
        IXQEQueryNode parent = qBlock.getParent();
        if (parent.getType() == 101016) {
            ((V5SqlQuery)parent).setQueryItemList(queryItems);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getParent();
        boolean bl = status = qBlock.getQueryItemList() == null;
        if (status) {
            this.traceQueryCondition(status, "Query block has not been bound.", trace);
        } else {
            this.traceQueryCondition(status, "Query block has been bound.", trace);
        }
        return status;
    }
}

