/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLColumn;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLTableValueConstructor;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLBinderUtil;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.transformation.v5.binding.BindRuntimeException;
import com.cognos.xqe.util.ConnectionUtil;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.Collection;

public final class BindSQLTableValueConstructor
extends RQETransformation {
    public BindSQLTableValueConstructor() {
        this(3);
    }

    public BindSQLTableValueConstructor(int passNumber) {
        this.mName = "Bind SQLTableValueConstructor node.";
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mPassNumbers = new int[]{passNumber};
        this.mTypes = new int[]{301039};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        IXQEQueryNode[] columns;
        SQLTableValueConstructor tValueCtor = (SQLTableValueConstructor)node;
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getParent();
        if (!qBlock.isLateralDerivedTable() && (columns = node.getDescendantsOfType(301005, false)).length > 0) {
            throw new BindRuntimeException(XQEMessageKeys.PLN_InvalidColumnReference, ((SQLColumn)columns[0]).getName());
        }
        SQLQueryItemList queryItems = tValueCtor.getQueryItemList();
        for (int i = 0; i < queryItems.size(); ++i) {
            if (((SQLQueryItem)queryItems.get(i)).getName() != null) continue;
            ((SQLQueryItem)queryItems.get(i)).setName("C" + i);
        }
        tValueCtor.setQueryItemList(queryItems);
        Collection<IDataSource> dataSources = SQLBinderUtil.getDataSources(environment.getRequestEnvironment(), node);
        for (IDataSource dataSource : dataSources) {
            if (dataSource == null || !dataSource.isRelational()) continue;
            try {
                ConnectionUtil.connect(environment.getExecutionEnvironment(), dataSource);
                if (!this.dataSourceSupportsTableConstructor(dataSource, tValueCtor)) continue;
                qBlock.setDataSource(dataSource);
                break;
            }
            catch (Throwable throwable) {
            }
        }
    }

    private boolean dataSourceSupportsTableConstructor(IDataSource dataSource, SQLTableValueConstructor tValueCtor) {
        String pattern = tValueCtor.getPattern(dataSource.getCapabilities());
        return pattern != null && pattern.compareToIgnoreCase("true") == 0;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        boolean bl = status = node.getPropertyValue("queryItems") == null;
        if (status) {
            this.traceQueryCondition(status, "Table value constructor has not been bound.", trace);
        } else {
            this.traceQueryCondition(status, "Table value constructor has been bound.", trace);
        }
        return status;
    }
}

