/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.sql.SQLTableFunction;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLBinderUtil;
import com.cognos.xqe.transformation.relational.util.XSSUtility;
import com.cognos.xqe.util.CAMUrl;
import com.cognos.xqeqte.QTEAbstractTransformation;
import com.ibm.cognos.ccl4j.xss.XSSEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GenerateXMLTableFunction
extends RQETransformation {
    private static final String ERROR_MSG_END = "</ERROR_MSG>";
    private static final String ERROR_MSG_BEGIN = "<ERROR_MSG>";
    private static final String ERROR_CODE_END = "</ERROR_CODE>";
    private static final String ERROR_CODE_BEGIN = "<ERROR_CODE>";
    private static final String FAULT = "Fault";
    private static final String UTF_8 = "UTF-8";

    public GenerateXMLTableFunction() {
        this(3);
    }

    public GenerateXMLTableFunction(int passNumber) {
        this.mName = "Generate XMLTable function specification.";
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mPassNumbers = new int[]{passNumber};
        this.mTypes = new int[]{301016};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        URI expUri;
        String uriStr;
        SQLTableFunction tblFunc;
        XQENodeFactory factory;
        SQLRelation relation;
        block6: {
            SQLQueryBlock qBlock;
            relation = (SQLRelation)node;
            factory = environment.getNodeFactory();
            if (node.getParent().getType() != 301004) {
                qBlock = (SQLQueryBlock)factory.createNode(301004);
                qBlock.setForeign(false);
                qBlock.setName(relation.getName());
                relation.insertParent(qBlock);
            } else {
                qBlock = (SQLQueryBlock)node.getParent();
            }
            tblFunc = (SQLTableFunction)factory.createNode(301038);
            tblFunc.setSubType(SQLTableFunction.SubType.XMLEXTERNALDATA);
            tblFunc.setDataSource(relation.getDataSource());
            tblFunc.setQueryItemList(relation.getQueryItemList());
            qBlock.addChild(tblFunc);
            qBlock.setQueryItemList(relation.getQueryItemList());
            tblFunc.setDataType(SQLBinderUtil.makeRowTypeFromQueryItems(relation.getQueryItemList()));
            uriStr = this.getURI(environment, relation.getDataSource());
            expUri = null;
            if (uriStr.indexOf(35) >= 0) {
                MacroExpander me = new MacroExpander();
                uriStr = me.expand(relation, environment, uriStr);
            }
            uriStr = this.xssEncode(uriStr);
            try {
                expUri = new URI(uriStr);
            }
            catch (URISyntaxException e) {
                if (!uriStr.startsWith("\\\\")) break block6;
                uriStr = "file:" + uriStr;
            }
        }
        if (expUri != null && (expUri.toString().contains("/metadataUIService?pid=xml_dstream") || expUri.toString().contains("/metadataUIService?XSSSTARTpid=xml_5fdstream"))) {
            this.checkForFault(expUri);
        }
        SQLLiteral literal = (SQLLiteral)factory.createNode(301031);
        literal.setValue(DataValueFactory.createCharValue(uriStr));
        tblFunc.addChild(literal);
        relation.extract();
    }

    private String xssEncode(String http) {
        if (!XSSUtility.isXSSEnabled()) {
            return http;
        }
        String xurl = XSSUtility.getDispatcherURL();
        if (xurl == null || xurl.equals("")) {
            return http;
        }
        String xurlMetadataUIService = xurl + "/metadataUIService?";
        int xurlMetadataUIServicePos = http.lastIndexOf(xurlMetadataUIService);
        if (xurlMetadataUIServicePos < 0) {
            return http;
        }
        int urlLength = http.length();
        int urlStart = xurlMetadataUIService.length();
        int preXSSUrlLength = urlStart + xurlMetadataUIServicePos;
        String urlPart1 = http.substring(0, preXSSUrlLength);
        String urlPart2 = http.substring(preXSSUrlLength, urlLength);
        return urlPart1 + XSSEncoder.tpXSSEncode((String)urlPart2);
    }

    private String getURI(IPlanningEnvironment environment, IDataSource dataSource) {
        String[] split = dataSource.getDataSourceConnection().getConnectionString(null).split(";");
        String tmpStr = null;
        for (int i = 0; i < split.length && ((tmpStr = split[i]).length() == 0 || tmpStr.equalsIgnoreCase("LOCAL") || tmpStr.equalsIgnoreCase("XML") || tmpStr.equalsIgnoreCase("validate=on") || tmpStr.equalsIgnoreCase("validate=off")); ++i) {
        }
        return tmpStr;
    }

    private void checkForFault(URI expUri) {
        try {
            URL urlLink = expUri.toURL();
            InputStream is = null;
            is = urlLink.getProtocol().equals("https") ? CAMUrl.createInputStream(expUri.toString()) : urlLink.openStream();
            this.getFault(is);
        }
        catch (MalformedURLException e) {
            throw new XQERuntimeException(e);
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    private void getFault(InputStream is) {
        XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "XMLTableFunctionURL", LogLevel.ERROR);
        String document = GenerateXMLTableFunction.convertInputStreamToString(is, logger);
        if (document != null && !document.isEmpty() && document.contains(ERROR_CODE_BEGIN)) {
            int errorCodeBegin = document.indexOf(ERROR_CODE_BEGIN) + ERROR_CODE_BEGIN.length();
            int errorCodeEnd = document.indexOf(ERROR_CODE_END, errorCodeBegin);
            String errorCode = document.substring(errorCodeBegin, errorCodeEnd);
            int errorMsgBegin = document.indexOf(ERROR_MSG_BEGIN, errorCodeEnd + ERROR_CODE_END.length()) + ERROR_MSG_BEGIN.length();
            int errorMsgEnd = document.indexOf(ERROR_MSG_END, errorMsgBegin);
            String errorMsg = document.substring(errorMsgBegin, errorMsgEnd);
            throw new XQERuntimeException(XQEMessageKeys.DS_DataSourceFailure, errorCode, errorMsg);
        }
        try {
            if (document != null && !document.isEmpty()) {
                is = IOUtils.toInputStream((String)document, (String)UTF_8);
            }
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            domFactory.setNamespaceAware(true);
            domFactory.isIgnoringComments();
            domFactory.setCoalescing(true);
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            Document doc = builder.parse(is);
            NodeList faultLst = doc.getElementsByTagNameNS("*", FAULT);
            int numSections = faultLst.getLength();
            if (numSections > 0) {
                Element section = (Element)faultLst.item(0);
                String faultStr = section.getTextContent();
                throw new LogonFailureException(LogonFailureException.SubCodeEnum.XML_TAG_FAULT, faultStr);
            }
        }
        catch (ParserConfigurationException se) {
            throw new XQERuntimeException(se);
        }
        catch (IOException ioe) {
            throw new XQERuntimeException(ioe);
        }
        catch (SAXException saxe) {
            throw new XQERuntimeException(saxe);
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    private static String convertInputStreamToString(InputStream is, XQELogger logger) {
        if (is == null) {
            return null;
        }
        StringBuffer sb = null;
        try {
            sb = new StringBuffer(IOUtils.toString((InputStream)is, (String)UTF_8));
        }
        catch (Throwable t) {
            logger.log(t.getMessage());
        }
        String document = sb.toString();
        return document;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        IDataSource dataSource = ((SQLRelation)node).getDataSource();
        return !((SQLRelation)node).isWithClauseQueryRef() && dataSource != null && "XML".equals(dataSource.getType());
    }
}

