/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.ast.sql.SQLColumn;
import com.cognos.xqe.ast.sql.SQLFunction;
import com.cognos.xqe.function.FunctionManager;
import com.cognos.xqe.function.IFunction;
import com.cognos.xqe.function.udf.IUDSQLFunction;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public final class ReplaceSQLFunction
extends RQETransformation {
    public ReplaceSQLFunction() {
        this(0);
    }

    public ReplaceSQLFunction(int passNumber) {
        this.mName = "Replace SQLFunction node.";
        this.mPassNumbers = new int[]{passNumber};
        this.mTypes = new int[]{301033};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLAbstractFunction fNode = (SQLAbstractFunction)node;
        IUDSQLFunction function = (IUDSQLFunction)FunctionManager.getUserDefinedFunction(fNode.getFunctionName(), fNode.getParameterTypes());
        ReplaceSQLFunction.replaceFunctionWithAst(environment, node, function);
    }

    public static void replaceFunctionWithAst(IPlanningEnvironment environment, IXQEQueryNode node, IUDSQLFunction function) {
        XQENodeFactory factory = environment.getNodeFactory();
        IXQEQueryNode ast = factory.deepCopyNode(function.getSQLAst());
        IXQEQueryNode[] columnNodes = ast.getDescendantsOfType(301005, false);
        int i = 0;
        IXQEQueryNode[] children = node.getChildren();
        node.detachChildren();
        for (String argName : function.getArgumentNames()) {
            for (IXQEQueryNode cNode : columnNodes) {
                if (!((SQLColumn)cNode).getName().equals(argName)) continue;
                cNode.exchange(factory.deepCopyNode(children[i]));
            }
            ++i;
        }
        node.exchange(ast);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLFunction fNode = (SQLFunction)node;
        boolean bl = status = fNode.getSubType() == SQLFunction.SubType.UDF;
        if (status) {
            IFunction function = fNode.getFunction();
            boolean bl2 = status = function != null && function.isSQLFunction();
        }
        if (status) {
            this.traceQueryCondition(status, "Function is a user-defined SQL expression.", trace);
        } else {
            this.traceQueryCondition(status, "Function is not a user-defined SQL expression.", trace);
        }
        return status;
    }
}

