/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.connection.parameters.DataSourceParameter;
import com.cognos.xqe.data.providers.connection.parameters.RunLocaleParameter;
import com.cognos.xqe.data.providers.relational.AbstractConnection;
import com.cognos.xqe.data.providers.relational.IRelationalDataProvider;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.NVarcharType;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionPool;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.util.ConnectionUtil;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.UnsupportedCharsetException;

public class AnalyzeCharacterLiteralsForConversionErrors
extends RQETransformation {
    public AnalyzeCharacterLiteralsForConversionErrors() {
        this.mName = "Normalize Character Literal Type.";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{301004};
        this.mMode = QTEAbstractTransformation.Mode.INDEXED;
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLQueryBlock qBlock = (SQLQueryBlock)node;
        IDataSource dataSource = qBlock.getDataSource();
        if (dataSource == null) {
            qBlock.setPropertyValue("analyzedLiteralsForConversionErrors", Boolean.TRUE);
            return;
        }
        IDataSourceCapabilities capabilities = dataSource.getCapabilities();
        if (capabilities.getBooleanValue("supports.charLiteralRoundTrip")) {
            qBlock.setPropertyValue("analyzedLiteralsForConversionErrors", Boolean.TRUE);
            return;
        }
        String charsetName = null;
        String[] r = new String[]{null};
        charsetName = ConnectionUtil.getDatabaseCharsetFromCache(environment.getExecutionEnvironment(), qBlock.getDataSource(), r) ? r[0] : AnalyzeCharacterLiteralsForConversionErrors.getDatabaseCharset(qBlock.getDataSource(), environment);
        if (charsetName == null) {
            qBlock.setPropertyValue("analyzedLiteralsForConversionErrors", Boolean.TRUE);
            return;
        }
        Charset charset = null;
        try {
            charset = Charset.forName(charsetName);
        }
        catch (UnsupportedCharsetException ex) {
            charset = null;
        }
        if (charset == null) {
            qBlock.setPropertyValue("analyzedLiteralsForConversionErrors", Boolean.TRUE);
            return;
        }
        CharsetEncoder encoder = charset.newEncoder();
        IXQEQueryNode[] literals = qBlock.getDescendantsOfType(301031, false);
        for (int i = 0; i < literals.length; ++i) {
            String value;
            SQLLiteral literal = (SQLLiteral)literals[i];
            IDataType datatype = literal.getDataType();
            if (datatype.getCCLTypeCode() != 45 || encoder.canEncode(value = literal.getValue().toString())) continue;
            literal.setDataType(NVarcharType.DEFAULTNVARCHARTYPE);
            literal.setValue(value);
        }
        qBlock.setPropertyValue("analyzedLiteralsForConversionErrors", Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        Boolean analyzed;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock qBlock = (SQLQueryBlock)node;
        boolean status = qBlock.isForeign();
        if (status && (analyzed = qBlock.getBooleanPropertyValue("analyzedLiteralsForConversionErrors")) != null && analyzed.booleanValue()) {
            status = false;
        }
        if (status) {
            this.traceQueryCondition(status, "Character literals need to be analyzed.", trace);
        } else {
            this.traceQueryCondition(status, "Character literals do not need to be analyzed.", trace);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDatabaseCharset(IDataSource dataSource, IPlanningEnvironment penv) {
        String charset = null;
        Object env = penv.getExecutionEnvironment();
        Object renv = penv.getRequestEnvironment();
        IRelationalDataProvider provider = ProviderManager.getInstance().getRelationalProvider(dataSource.getType());
        IConnectionPool connectionPool = env.getConnectionPool();
        ConnectionParameters parameters = new ConnectionParameters();
        parameters.put(new DataSourceParameter(dataSource));
        parameters.put(new RunLocaleParameter(renv.getRunLocale(), false));
        IPooledConnection pooledConnection = connectionPool.borrowConnection(provider.getProviderInstanceName(), parameters, provider.getConnectionSelector(), provider.getConnectionFactory());
        try {
            AbstractConnection aConnection = (AbstractConnection)pooledConnection.getConnection();
            if (aConnection != null) {
                charset = aConnection.getDatabaseCharset();
            }
        }
        finally {
            pooledConnection.returnConnection();
        }
        return charset;
    }
}

