/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.qep.QEPPlan;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLSort;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.ast.sql.SQLSortKeyList;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class CollapseSortOverMergeJoin
extends RQETransformation {
    public CollapseSortOverMergeJoin() {
        this.mName = "Collapse sort nodes.";
        this.mPassNumbers = new int[]{5};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
        this.mTypes = new int[]{301019};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLProject projNode = (SQLProject)node.getChild(0);
        IXQEQueryNode[] sortNodes = projNode.getChild(0).getChildrenOfType(301019);
        SQLSortKeyList keyList1 = (SQLSortKeyList)node.getChild(1);
        SQLSortKeyList keyList2 = (SQLSortKeyList)sortNodes[0].getChild(1);
        if (keyList1.getNumberChildren() > keyList2.getNumberChildren()) {
            SQLValueList valueList = projNode.getOutputList();
            int nColumns = ((SQLQueryNode)sortNodes[0]).getNumberColumns();
            SQLSortKeyList keyList3 = (SQLSortKeyList)sortNodes[1].getChild(1);
            SQLFid[] fidList = this.getFieldIdentifiers(keyList1, valueList);
            for (int i = keyList2.getNumberChildren(); i < keyList1.getNumberChildren(); ++i) {
                SQLSortKey sortKey = (SQLSortKey)keyList1.getChild(i);
                int vColumnNo = fidList[i].getVirtualColumnNo();
                SQLFid fid1 = (SQLFid)valueList.getChild(sortKey.getColumnNo());
                SQLFid fid2 = (SQLFid)nodeFactory.deepCopyNode(fid1);
                if (vColumnNo < nColumns) {
                    keyList2.addSortKey(nodeFactory, fid2, sortKey.isAscending(), sortKey.getNullOrder());
                    continue;
                }
                fid2.setVirtualColumnNo(vColumnNo - nColumns);
                keyList3.addSortKey(nodeFactory, fid2, sortKey.isAscending(), sortKey.getNullOrder());
            }
        }
        node.getChild(1).detach();
        node.extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        IXQEQueryNode child = node.getChild(0);
        boolean status = !((SQLSort)node).isDistinct() && child.getType() == 301015 && child.getChild(0).getType() == 901014;
        IXQEQueryNode[] sortNodes = null;
        if (status && ((sortNodes = child.getChild(0).getChildrenOfType(301019)).length < 2 || sortNodes[0].getChild(0) instanceof QEPPlan)) {
            status = false;
        }
        if (status) {
            SQLValueList valueList = ((SQLProject)child).getOutputList();
            IXQEQueryNode keyList1 = node.getChild(1);
            SQLFid[] fidList = this.getFieldIdentifiers(keyList1, valueList);
            boolean bl = status = fidList != null;
            if (status) {
                int nColumns = ((SQLQueryNode)sortNodes[0]).getNumberColumns();
                IXQEQueryNode keyList2 = sortNodes[0].getChild(1);
                IXQEQueryNode keyList3 = sortNodes[1].getChild(1);
                int nKeys = 0;
                for (int i = 0; i < keyList1.getNumberChildren() && status; ++i) {
                    SQLSortKey sortKey2;
                    SQLFid fid1 = fidList[i];
                    int vColumnNo = fid1.getVirtualColumnNo();
                    if (i >= keyList2.getNumberChildren()) {
                        if (vColumnNo < nColumns) {
                            ++nKeys;
                            continue;
                        }
                        --nKeys;
                        continue;
                    }
                    SQLSortKey sortKey1 = (SQLSortKey)keyList1.getChild(i);
                    if (vColumnNo < nColumns) {
                        sortKey2 = (SQLSortKey)keyList2.getChild(i);
                    } else {
                        sortKey2 = (SQLSortKey)keyList3.getChild(i);
                        vColumnNo -= nColumns;
                    }
                    if (sortKey1.isAscending() == sortKey2.isAscending() && sortKey1.getNullOrder() == sortKey2.getNullOrder()) {
                        SQLFid fid2 = (SQLFid)sortKey2.getChild(0);
                        if (fid2.getVirtualColumnNo() == vColumnNo) continue;
                        status = false;
                        continue;
                    }
                    status = false;
                }
                if (status && keyList1.getNumberChildren() > keyList2.getNumberChildren()) {
                    boolean bl2 = status = Math.abs(nKeys) == keyList1.getNumberChildren() - keyList2.getNumberChildren();
                }
            }
        }
        if (status) {
            this.traceQueryCondition(status, "Sort nodes can be collapsed.", trace);
        } else {
            this.traceQueryCondition(status, "Sort nodes cannot be collapsed.", trace);
        }
        return status;
    }

    private SQLFid[] getFieldIdentifiers(IXQEQueryNode keyList, SQLValueList valueList) {
        int nKeys = keyList.getNumberChildren();
        SQLFid[] fidList = new SQLFid[nKeys];
        for (int i = 0; i < nKeys; ++i) {
            SQLSortKey sortKey = (SQLSortKey)keyList.getChild(i);
            IXQEQueryNode eNode = valueList.getChild(sortKey.getColumnNo());
            if (eNode.getType() != 301032) {
                return null;
            }
            fidList[i] = (SQLFid)eNode;
        }
        return fidList;
    }
}

