/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.sql.SQLWith;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.rsapi.IRSAPIDataset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.util.Governors;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.HashSet;
import java.util.List;

public class ConvertSQLWith
extends RQETransformation {
    public ConvertSQLWith() {
        this.mName = "Rewrite a WITH clause specification.";
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mPassNumbers = new int[]{10};
        this.mTypes = new int[]{301022};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        ConvertSQLWith.convertWithToDerivedTable(node, nodeFactory);
        int nCTE = node.getNumberChildren() - 1;
        for (int i = 0; i < nCTE; ++i) {
            node.getChild(0).detach();
        }
        IXQEQueryNode child = node.getChild(0);
        if (child.getType() == 301004 && ((SQLQueryBlock)child).isForeign()) {
            child.extract();
        }
        node.extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        boolean bl = status = pQueryBlock != null && pQueryBlock.isForeign();
        if (status) {
            status = false;
            IRSAPIDataset rs = (IRSAPIDataset)node.getAncestorOfType(401005);
            if (rs != null) {
                Governors governors = rs.getGovernors();
                boolean bl2 = status = governors.getSqlWithClause() == false;
            }
            if (!status) {
                SQLRangeVar rv;
                IDataSource dataSource = pQueryBlock.getDataSource();
                IDataSourceCapabilities capabilities = dataSource.getCapabilities();
                boolean bl3 = status = !SQLWith.isFeatureSupported(capabilities);
                if (!status && (rv = (SQLRangeVar)node.getAncestorOfType(301007)) != null) {
                    boolean bl4 = status = !capabilities.isSupported("supports.withClauseInDerivedTable");
                }
                if (!status) {
                    IXQEQueryNode ancstr = node.getAncestorOfType(301022);
                    boolean bl5 = status = ancstr != null && ancstr.isAncestor(pQueryBlock) && !capabilities.isSupported("supports.nestedWithClause");
                }
            }
        }
        if (status) {
            this.traceQueryCondition(status, "The WITH clause is not supported in this context, or a governor is set.", trace);
        } else {
            this.traceQueryCondition(status, "The WITH clause is supported, and the governor is not set.", trace);
        }
        return status;
    }

    private static void convertWithToDerivedTable(IXQEQueryNode node, IXQENodeFactory nodeFactory) {
        int nCommonTableExpression = node.getNumberChildren() - 1;
        List<IXQEQueryNode> list = node.getDescendantsOfTypeOrdered(301016, false);
        ConvertSQLWith.updateRefCountInCommonTable(node, list);
        IXQEQueryNode[] nodes = list.toArray(new IXQEQueryNode[list.size()]);
        block0: for (int i = 0; i < nodes.length; ++i) {
            SQLRelation rNode = (SQLRelation)nodes[i];
            if (!rNode.isWithClauseQueryRef()) continue;
            for (int j = 0; j < nCommonTableExpression; ++j) {
                SQLRangeVar rangeVar = (SQLRangeVar)node.getChild(j);
                if (!rNode.getName().equals(rangeVar.getName())) continue;
                if (rangeVar.getReferenceCount() == 1) {
                    rangeVar.move(rNode);
                    rNode.extract();
                    if (rangeVar.getParent().getType() == 301007) {
                        if (rangeVar.getDerivedColumnList() != null) {
                            ((SQLRangeVar)rangeVar.getParent()).setDerivedColumnList(rangeVar.getDerivedColumnList());
                        }
                        rangeVar.extract();
                    }
                    --nCommonTableExpression;
                    continue block0;
                }
                SQLRangeVar copied = (SQLRangeVar)nodeFactory.deepCopyNode(rangeVar);
                rNode.exchange(copied);
                if (copied.getParent().getType() == 301007) {
                    if (copied.getDerivedColumnList() != null) {
                        ((SQLRangeVar)copied.getParent()).setDerivedColumnList(copied.getDerivedColumnList());
                    }
                    copied.extract();
                }
                rangeVar.setReferenceCount(rangeVar.getReferenceCount() - 1);
                continue block0;
            }
        }
    }

    private static void updateRefCountInCommonTable(IXQEQueryNode withNode, List<IXQEQueryNode> relationNodes) {
        HashSet<SQLRelation> matchingNodes = new HashSet<SQLRelation>();
        int nCommonTableExpression = withNode.getNumberChildren() - 1;
        for (int i = 0; i < nCommonTableExpression; ++i) {
            SQLRangeVar rangeVar = (SQLRangeVar)withNode.getChild(i);
            int refCount = 0;
            for (IXQEQueryNode node : relationNodes) {
                SQLRelation rNode = (SQLRelation)node;
                if (matchingNodes.contains(rNode) || !rNode.getName().equals(rangeVar.getName())) continue;
                ++refCount;
                matchingNodes.add(rNode);
            }
            if (rangeVar.getReferenceCount() >= refCount) continue;
            rangeVar.setReferenceCount(refCount);
        }
    }
}

