/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPNameGenerator;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class CreateAliasListToAvoidDuplicateColumnNames
extends RQETransformation {
    public CreateAliasListToAvoidDuplicateColumnNames() {
        this.mName = "Create alias list to avoid duplicate column names";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{301015};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        int maxColumnNameLength = RQPUtilities.getMaxColumnNameLength((PlanningEnvironment)environment);
        SQLProject sqlProject = (SQLProject)node;
        SQLValueList valueList = sqlProject.getOutputList();
        HashSet<String> aliasNames = new HashSet<String>(valueList.getNumberChildren());
        ArrayList<SQLAlias> aliasList = new ArrayList<SQLAlias>();
        for (int i = 0; i < valueList.getNumberChildren(); ++i) {
            String aliasName;
            IXQEQueryNode childNode = valueList.getChild(i);
            if (childNode.getType() == 301032) {
                String colName = ((SQLFid)childNode).getName();
                aliasName = RQPNameGenerator.generateUniqueAliasName(aliasNames, colName, maxColumnNameLength);
            } else {
                aliasName = RQPNameGenerator.generateUniqueAliasName(aliasNames, "C", maxColumnNameLength);
            }
            SQLAlias alias = new SQLAlias();
            alias.setName(aliasName);
            aliasList.add(alias);
            aliasNames.add(aliasName.toUpperCase());
        }
        valueList.setAliasList(aliasList);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLProject sqlProject;
        SQLValueList valueList;
        List<SQLAlias> aliasList;
        boolean status = false;
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        if (qBlock != null && qBlock.isForeign() && !qBlock.getDataSource().getCapabilities().getBooleanValue("supports.duplicateColumnNamesInSelectList") && (aliasList = (valueList = (sqlProject = (SQLProject)node).getOutputList()).getAliasList()) == null) {
            HashSet<String> columnNameList = new HashSet<String>();
            for (int i = 0; i < valueList.getNumberChildren(); ++i) {
                IXQEQueryNode childNode = valueList.getChild(i);
                if (childNode.getType() != 301032) continue;
                String colName = ((SQLFid)childNode).getName();
                if (colName != null) {
                    colName = colName.toUpperCase();
                }
                if (columnNameList.contains(colName)) {
                    status = true;
                    break;
                }
                columnNameList.add(colName);
            }
        }
        return status;
    }
}

