/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.qep.QEPAbstractPlan;
import com.cognos.xqe.ast.sql.SQLGroupBy;
import com.cognos.xqe.ast.sql.SQLGroupByList;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLSort;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.ast.sql.SQLSortKeyList;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.connection.parameters.DataSourceParameter;
import com.cognos.xqe.data.providers.connection.parameters.RunLocaleParameter;
import com.cognos.xqe.data.providers.relational.AbstractConnection;
import com.cognos.xqe.data.providers.relational.IRelationalDataProvider;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionPool;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.optimization.util.Planner;
import com.cognos.xqe.transformation.relational.util.Ordering;

public class CreateGroupByPlan
extends RQETransformation {
    public CreateGroupByPlan() {
        this.mName = "Create a group by plan.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{301010};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        QEPAbstractPlan plan = null;
        XQENodeFactory factory = environment.getNodeFactory();
        Planner planner = new Planner(environment);
        SQLGroupByList groupByList = ((SQLGroupBy)node).getGroupByList();
        SQLValueList valueList = ((SQLGroupBy)node).getValueList();
        IXQEQueryNode[] aggregates = valueList.getDescendantsOfType(301034, false);
        Ordering ordering = new Ordering();
        if (groupByList != null) {
            IXQEQueryNode[] children;
            for (IXQEQueryNode child : children = groupByList.getChildren()) {
                if (child.getType() == 301031) continue;
                Ordering.OrderItem item = new Ordering.OrderItem(child);
                ordering.addOrMerge(item);
            }
        }
        Ordering aggrOrdering = new Ordering();
        for (IXQEQueryNode aggr : aggregates) {
            SQLSortKeyList sortKeyList = (SQLSortKeyList)aggr.getFirstChildByType(301021);
            if (sortKeyList == null) continue;
            IXQEQueryNode[] sortKeys = sortKeyList.getChildren();
            Ordering to = new Ordering(sortKeys);
            aggrOrdering.merge(to);
        }
        SQLGroupBy.Hint hint = ((SQLGroupBy)node).getHint();
        if (groupByList == null || groupByList.getNumberChildren() == 0 || hint == SQLGroupBy.Hint.ORDER) {
            plan = planner.createPlan(901020);
        }
        IXQEQueryNode child = node.getChild(0);
        boolean bNoHash = plan == null && hint != SQLGroupBy.Hint.HASH && this.pushableSort((IExecutionEnvironment)environment.getExecutionEnvironment(), groupByList, child);
        boolean bl = bNoHash = bNoHash || node.getFirstDescendantOfTypeOrdered(301052, false) != null;
        if (bNoHash) {
            ordering.merge(aggrOrdering);
            this.createSort(factory, ordering, child);
            plan = planner.createPlan(901020);
        } else if (aggrOrdering.size() > 0) {
            this.createSort(factory, aggrOrdering, child);
        }
        if (plan == null) {
            plan = planner.createPlan(901021);
        }
        node.exchange(plan, true);
    }

    private void createSort(XQENodeFactory factory, Ordering ordering, IXQEQueryNode root) {
        SQLSortKeyList sortKeyList = (SQLSortKeyList)factory.createNode(301021);
        for (int i = 0; i < ordering.size(); ++i) {
            Ordering.OrderItem orderItem = ordering.get(i);
            SQLSortKey sortKey = orderItem.createSortKey(factory);
            sortKeyList.addChild(sortKey);
        }
        SQLSort sort = (SQLSort)factory.createNode(301019);
        sort.setCollationIdRequired(true);
        root.insertParent(sort);
        sort.addChild(sortKeyList);
        sort.setPushable(true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock pQueryBlock = ((SQLQueryNode)node).getParentQueryBlock();
        boolean bl = status = pQueryBlock == null || !pQueryBlock.isForeign();
        if (status) {
            this.traceQueryCondition(status, "A group by plan can be created.", trace);
        } else {
            this.traceQueryCondition(status, "A group by plan cannot be created.", trace);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pushableSort(IExecutionEnvironment env, SQLGroupByList groupByList, IXQEQueryNode root) {
        if (root.getType() != 301004 || !((SQLQueryBlock)root).isForeign()) {
            return false;
        }
        IXQEQueryNode child = ((SQLQueryBlock)root).getChild(0);
        if (child.getType() == 301019 || child.getType() == 301012 || child.getType() == 301091 || child.getType() == 301061) {
            return false;
        }
        IDataSource dataSource = ((SQLQueryBlock)root).getDataSource();
        boolean result = SQLSort.isFeatureSupported(dataSource.getCapabilities());
        if (result) {
            IRelationalDataProvider provider = ProviderManager.getInstance().getRelationalProvider(dataSource.getType());
            IConnectionPool connectionPool = env.getConnectionPool();
            ConnectionParameters parameters = new ConnectionParameters();
            parameters.put(new DataSourceParameter(dataSource));
            parameters.put(new RunLocaleParameter(env.getRequestEnvironment().getRunLocale(), false));
            IPooledConnection pooledConnection = connectionPool.borrowConnection(provider.getProviderInstanceName(), parameters, provider.getConnectionSelector(), provider.getConnectionFactory());
            try {
                for (int i = 0; i < groupByList.getNumberChildren() && result; ++i) {
                    SQLQueryNode gColumn = (SQLQueryNode)groupByList.getChild(i);
                    if (!gColumn.isSupported(dataSource)) {
                        result = false;
                        continue;
                    }
                    if (!gColumn.getDataType().isTextType()) continue;
                    result = env.getLocalSortIsCompatibleWithServer((AbstractConnection)pooledConnection.getConnection());
                }
            }
            finally {
                pooledConnection.returnConnection();
            }
        }
        return result;
    }
}

