/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.qep.QEPCollect;
import com.cognos.xqe.ast.qep.QEPDistribute;
import com.cognos.xqe.ast.qep.QEPGroupBy;
import com.cognos.xqe.ast.sql.SQLGroupByList;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.runtree.relational.XDistribute;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.optimization.util.Planner;

public class CreateParallelGroupByPlan
extends RQETransformation {
    public CreateParallelGroupByPlan() {
        this.mName = "Create a parallel group by plan.";
        this.mPassNumbers = new int[]{8};
        this.mTypes = new int[]{901020};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        Planner planner = new Planner(environment);
        SQLGroupByList groupByList = ((QEPGroupBy)node).getGroupByList();
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        int dop = configuration.getMaxDop();
        QEPCollect collector = (QEPCollect)planner.createPlan(901016);
        collector.setDop(dop);
        node.insertParent(collector);
        QEPDistribute distributor = (QEPDistribute)planner.createPlan(901017);
        distributor.setDop(dop);
        distributor.setPartitioningType(XDistribute.PartitioningType.RANGE);
        node.getChild(0).insertParent(distributor);
        distributor.addChild(factory.deepCopyNode(groupByList));
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        boolean bl = status = node.getParent().getType() != 901016;
        if (status) {
            SQLGroupByList groupByList = ((QEPGroupBy)node).getGroupByList();
            boolean bl2 = status = groupByList != null && groupByList.getNumberChildren() > 0 && configuration.isParallelismEnabled() && configuration.getMaxDop() > 1;
        }
        if (status) {
            this.traceQueryCondition(status, "A parallel group by plan can be created.", trace);
        } else {
            this.traceQueryCondition(status, "A parallel group by plan cannot be created.", trace);
        }
        return status;
    }
}

