/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.XQEQueryNode;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLSort;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.ast.sql.SQLSortKeyList;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.SQLWindow;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.optimization.util.RestoreOlapMemberOrderUtil;
import com.cognos.xqe.transformation.relational.preoptimization.SQLPreoptimizerUtil;
import com.cognos.xqe.transformation.relational.util.Ordering;
import java.util.Collection;
import java.util.List;

public class CreateSortForWindowedAggregates
extends RQETransformation {
    public CreateSortForWindowedAggregates() {
        this.mName = "Create sort for windowed aggregates.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{301004};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        Boolean sub;
        Object querySet;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        Collection<IDataSource> dataSources = ((SQLQueryBlock)node).getDataSourceList();
        SQLProject project = (SQLProject)node.getChild(0);
        SQLValueList list = project.getOutputList();
        Ordering ordering = new Ordering();
        List<IXQEQueryNode> windows = list.getDescendantsOfTypeOrdered(301041, false);
        if (RestoreOlapMemberOrderUtil.isOlapBased(project) && (querySet = RestoreOlapMemberOrderUtil.getTopMostQuerySet(node)) != null && (sub = ((XQEQueryNode)querySet).getBooleanPropertyValue("MultiDimensionalSubquery")) != null && sub == Boolean.TRUE) {
            for (IXQEQueryNode window : windows) {
                Integer ub = ((SQLWindow)window).getWindowFrameUpperBound();
                if (ub == null || ub != 0) continue;
                project.setMemberOrdered(true);
                return;
            }
        }
        for (IXQEQueryNode window : windows) {
            Ordering to = SQLPreoptimizerUtil.getWindowOrdering((SQLWindow)window);
            ordering.merge(to);
        }
        if (ordering.size() > 0) {
            IXQEQueryNode child = project.getChild(0);
            SQLSort sort = (SQLSort)nodeFactory.createNode(301019);
            sort.setCollationIdRequired(true);
            sort.setPropertyValue("window.aggregate", Boolean.TRUE);
            child.insertParent(sort);
            SQLQueryBlock qBlock = (SQLQueryBlock)nodeFactory.createNode(301004);
            qBlock.setDataSourceList(dataSources);
            qBlock.setForeign(false);
            sort.insertParent(qBlock);
            SQLSortKeyList sortKeyList = (SQLSortKeyList)nodeFactory.createNode(301021);
            sort.addChild(sortKeyList);
            for (int i = 0; i < ordering.size(); ++i) {
                SQLSortKey sortKey = ordering.get(i).createSortKey(nodeFactory);
                sortKeyList.addChild(sortKey);
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        boolean bl = status = !((SQLQueryBlock)node).isForeign() && node.getChild(0).getType() == 301015;
        if (status) {
            SQLProject project = (SQLProject)node.getChild(0);
            boolean bl2 = status = !project.getMemberOrdered() && CreateSortForWindowedAggregates.sortRequired(project.getOutputList());
            if (status) {
                IXQEQueryNode child = project.getChild(0);
                boolean bl3 = status = child.getType() != 301019 && (child.getType() != 301004 || ((SQLQueryBlock)child).getBlockType() != 301019);
            }
        }
        if (status) {
            this.traceQueryCondition(status, "Projection has window functions", trace);
        } else {
            this.traceQueryCondition(status, "Projection doesn't have window functions", trace);
        }
        return status;
    }

    public static boolean sortRequired(IXQEQueryNode node) {
        IXQEQueryNode[] windows = node.getDescendantsOfType(301041, false);
        if (windows.length > 0) {
            int[] types = new int[]{301042, 301021, 301062};
            for (int i = 0; i < windows.length; ++i) {
                if (windows[i].getNumberChildrenOfTypes(types) <= 0) continue;
                return true;
            }
        }
        return false;
    }
}

