/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.sql.SQLSetOperator;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.LinkedList;

public class NormalizeUnionColumnNames
extends RQETransformation {
    public NormalizeUnionColumnNames() {
        this.mName = "Normalize Union Column names";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{301007};
        this.mMode = QTEAbstractTransformation.Mode.INDEXED;
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLRangeVar qBlock = (SQLRangeVar)node;
        SQLQueryItemList qItemList = ((SQLSetOperator)qBlock.getChild(0)).getQueryItemList();
        LinkedList<String> derivedColumnList = new LinkedList<String>();
        for (SQLQueryItem queryItem : qItemList) {
            derivedColumnList.add(queryItem.getName());
        }
        qBlock.setDerivedColumnList(derivedColumnList);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLRangeVar rangeVar = (SQLRangeVar)node;
        boolean bl = status = rangeVar.getChild(0).getType() == 301018;
        if (status) {
            boolean bl2 = status = rangeVar.getDerivedColumnList() == null;
        }
        if (status) {
            SQLQueryBlock qBlock = rangeVar.getParentQueryBlock();
            status = qBlock != null && qBlock.isForeign() ? qBlock.getDataSource().getCapabilities().getBooleanValue("supports.derivedColumnLists") : false;
        }
        if (status) {
            this.traceQueryCondition(status, "Need to add derived column list.", trace);
        } else {
            this.traceQueryCondition(status, "Do not need to add derived column list.", trace);
        }
        return status;
    }
}

