/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLDistinct;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLSetOperator;
import com.cognos.xqe.ast.sql.SQLSort;
import com.cognos.xqe.ast.sql.SQLSortKeyList;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.optimization.RemoveSQLDistinct;

public class OptimizeUnionDistinct
extends RQETransformation {
    public OptimizeUnionDistinct() {
        this.mName = "Create a DISTINCt node for Union operator.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{301018};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        int blockType;
        IXQEQueryNode child;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLSetOperator union = (SQLSetOperator)node;
        union.setAll(true);
        SQLQueryBlock qBlock = union.getParentQueryBlock();
        if (qBlock.isRecursive()) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidSetOperator, qBlock.getName());
        }
        IXQEQueryNode parent = union.getParent().getParent();
        if (parent != null && parent.getType() == 301019 && (child = union.getChild(0)).getType() == 301004 && ((blockType = ((SQLQueryBlock)child).getBlockType()) == 301015 || blockType == 301010)) {
            IXQEQueryNode vList = child.getChild(0).getChild(1);
            SQLSortKeyList sortList = (SQLSortKeyList)parent.getChild(1);
            RemoveSQLDistinct.adjustSortList(nodeFactory, sortList, vList);
            ((SQLSort)parent).setDistinct(true);
            return;
        }
        SQLDistinct distinct = (SQLDistinct)nodeFactory.createNode(301008);
        union.insertParent(distinct);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        boolean bl = status = (pQueryBlock == null || !pQueryBlock.isForeign()) && ((SQLSetOperator)node).getSubType() == SQLSetOperator.SubType.UNION && !((SQLSetOperator)node).getAll();
        if (status) {
            this.traceQueryCondition(status, "UNION operator requires duplicate elimination.", trace);
        } else {
            this.traceQueryCondition(status, "UNION operator doesn't require duplicate elimination", trace);
        }
        return status;
    }
}

