/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization.util;

import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.transformation.relational.optimization.util.BitMask;
import com.cognos.xqe.transformation.relational.optimization.util.JoinGraph;
import java.util.ArrayList;
import java.util.List;

public class JoinMatrix {
    private BitMask[] mask;

    public JoinMatrix(int nSources) {
        this.mask = new BitMask[nSources];
        for (int i = 0; i < nSources; ++i) {
            this.mask[i] = new BitMask(nSources);
        }
    }

    public JoinMatrix(int nSources, List<SQLFilter> factorList) {
        this(nSources);
        for (SQLFilter factor : factorList) {
            this.set(factor.getLeftSourceNo(), factor.getRightSourceNo());
        }
    }

    public void set(int lSourceNo, int rSourceNo) {
        this.mask[lSourceNo].set(rSourceNo);
        this.mask[rSourceNo].set(lSourceNo);
    }

    public BitMask get(int sourceNo) {
        return this.mask[sourceNo];
    }

    public List<JoinGraph> enumerateJoinGraphs() {
        BitMask sources = new BitMask();
        int nSources = this.mask.length;
        ArrayList<JoinGraph.Vertex> allNodes = new ArrayList<JoinGraph.Vertex>();
        for (int i = 0; i < nSources; ++i) {
            allNodes.add(new JoinGraph.Vertex(i));
        }
        ArrayList<JoinGraph> joinGraphs = new ArrayList<JoinGraph>();
        for (int i = 0; i < nSources; ++i) {
            if (sources.get(i)) continue;
            ArrayList<JoinGraph.Vertex> nodes = new ArrayList<JoinGraph.Vertex>();
            ArrayList<JoinGraph.Edge> edges = new ArrayList<JoinGraph.Edge>();
            this.getNodesAndEdges(sources, i, allNodes, nodes, edges);
            JoinGraph jGraph = new JoinGraph(nodes, edges);
            joinGraphs.add(jGraph);
        }
        return joinGraphs;
    }

    private void getNodesAndEdges(BitMask sources, int sourceNo, List<JoinGraph.Vertex> allNodes, List<JoinGraph.Vertex> nodes, List<JoinGraph.Edge> edges) {
        if (sources.get(sourceNo)) {
            return;
        }
        sources.set(sourceNo);
        nodes.add(allNodes.get(sourceNo));
        int j = -1;
        BitMask jMask = this.mask[sourceNo];
        for (int i = 0; i < jMask.cardinality(); ++i) {
            j = jMask.nextSetBit(j + 1);
            edges.add(new JoinGraph.Edge(allNodes.get(sourceNo), allNodes.get(j)));
            this.getNodesAndEdges(sources, j, allNodes, nodes, edges);
        }
    }
}

